
#==============================================================================#
# $Id: pie.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  class PieBase < GraphBase

    # Private Instance Methods

    def create_legend
      font = @legend.font.create_font

      legend = Legend.new(@legend)

      @data.each { |item|
        legend.add(font, item[:name], Legend::Marker::Color.new(item[:color], @chart.edge.color))
      }

      return legend
    end
    private :create_legend

    def create_graph
      graph = create_chart

      @data.each { |item|
        graph.add_value(item[:name], item[:value], item[:color])
      }

      return graph
    end
    private :create_graph

  end

  class Pie < PieBase

    # Private Instance Methods

    def create_attribute_chart
      return Attribute::Chart::Pie.new
    end
    private :create_attribute_chart

    def create_chart
      return Chart::Pie.new(@chart)
    end
    private :create_chart

  end

  class Pie3D < PieBase

    def create_attribute_chart
      return Attribute::Chart::Pie3D.new
    end
    private :create_attribute_chart

    def create_chart
      return Chart::Pie3D.new(@chart)
    end
    private :create_chart

  end

end
