#! /usr/bin/ruby -Ke

#==============================================================================#
# example/graph/pie3.rb
# $Id: pie3.rb,v 1.1 2002/09/20 07:55:22 yuya Exp $
#==============================================================================#

require 'gruby/gruby'
require 'gruby/graph/graph'

#==============================================================================#

data = [
  {:name => 'Field 1', :value => 9, :color => GRb::Color.red(224)    },
  {:name => 'Field 2', :value => 8, :color => GRb::Color.green(224)  },
  {:name => 'Field 3', :value => 6, :color => GRb::Color.blue(224)   },
  {:name => 'Field 4', :value => 5, :color => GRb::Color.yellow(224) },
  {:name => 'Field 5', :value => 3, :color => GRb::Color.skyblue(224)},
  {:name => 'Field 6', :value => 2, :color => GRb::Color.purple(224) },
]

#==============================================================================#

graph = GRb::Graph::Pie.create(400, 300, true)
graph.title.text                   = 'Pie Graph Sample 3'          # ȥ ʸ
graph.title.font.color             = GRb::Color.white              # ȥ ե 
graph.frame.gradation.visible      = true                          # ط ǡ ɽ
graph.frame.gradation.start_color  = GRb::Color.new(0, 0, 64)      # ط ǡ Ͽ
graph.frame.gradation.end_color    = GRb::Color.new(0, 128, 255)   # ط ǡ λ
graph.legend.vertical              = false                         #  ʿ
graph.legend.position              = :bottom_center                #  
graph.legend.border.visible        = false                         #   ɽ
graph.legend.gradation.visible     = true                          #  ǡ ɽ
graph.legend.gradation.start_color = GRb::Color.new(128, 192, 255) #  ǡ Ͽ
graph.legend.gradation.end_color   = GRb::Color.new(192, 255, 255) #  ǡ λ
graph.legend.gradation.angle       = 90                            #  ǡ 
graph.data                         = data
graph.png_file('pie3.png')

#==============================================================================#
#==============================================================================#
