#! /usr/bin/ruby -Ke

#==============================================================================#
# example/graph/pie4.rb
# $Id: pie4.rb,v 1.1 2002/09/20 07:55:22 yuya Exp $
#==============================================================================#

require 'gruby/gruby'
require 'gruby/graph/graph'

#==============================================================================#

data = [
  {:name => 'Field 1', :value => 9, :color => GRb::Color.red(224)    },
  {:name => 'Field 2', :value => 8, :color => GRb::Color.green(224)  },
  {:name => 'Field 3', :value => 6, :color => GRb::Color.blue(224)   },
  {:name => 'Field 4', :value => 5, :color => GRb::Color.yellow(224) },
  {:name => 'Field 5', :value => 3, :color => GRb::Color.skyblue(224)},
  {:name => 'Field 6', :value => 2, :color => GRb::Color.purple(224) },
]

#==============================================================================#

graph = GRb::Graph::Pie.create(400, 300)
graph.title.text             = 'Pie Graph Sample 4'   # ȥ ʸ
graph.title.position         = :middle_left           # ȥ 
graph.title.font.vertical    = true                   # ȥ ե ľ
graph.frame.fill.visible     = true                   # ط طʿ ɽ
graph.frame.fill.color       = GRb::Color.gray(224)   # ط طʿ 
graph.frame.shadow.visible   = true                   # ط  ɽ
graph.frame.shadow.color     = GRb::Color.gray(192)   # ط  
graph.frame.shadow.offset_x  = -3                     # ط  եå
graph.frame.shadow.offset_y  = 3                      # ط  եå
graph.legend.vertical        = false                  #  ʿ
graph.legend.position        = :bottom_left           #  
graph.legend.font.name       = GRb::Graph::Font::Tiny #  ե ̾
graph.legend.fill.visible    = true                   #  طʿ ɽ
graph.legend.fill.color      = GRb::Color.gray(192)   #  طʿ 
graph.legend.shadow.visible  = true                   #   ɽ
graph.legend.shadow.color    = GRb::Color.gray(128)   #   
graph.legend.shadow.offset_x = -3                     #   եå
graph.legend.shadow.offset_y = 3                      #   եå
graph.chart.fill.visible     = true                   # 㡼 طʿ ɽ
graph.chart.fill.color       = GRb::Color.gray(192)   # 㡼 طʿ 
graph.chart.border.visible   = true                   # 㡼  ɽ
graph.chart.shadow.visible   = true                   # 㡼  ɽ
graph.chart.shadow.color     = GRb::Color.gray(128)   # 㡼  
graph.chart.shadow.offset_x  = -3                     # 㡼  եå
graph.chart.shadow.offset_y  = 3                      # 㡼  եå
graph.data                   = data
graph.png_file('pie4.png')

#==============================================================================#
#==============================================================================#
