#! /usr/bin/ruby -Ke

#==============================================================================#
# example/graph/pie5.rb
# $Id: pie5.rb,v 1.1 2002/09/20 07:55:22 yuya Exp $
#==============================================================================#

require 'gruby/gruby'
require 'gruby/graph/graph'

#==============================================================================#

data = [
  {:name => 'Field 1', :value => 9, :color => GRb::Color.red(224)    },
  {:name => 'Field 2', :value => 8, :color => GRb::Color.green(224)  },
  {:name => 'Field 3', :value => 6, :color => GRb::Color.blue(224)   },
  {:name => 'Field 4', :value => 5, :color => GRb::Color.yellow(224) },
  {:name => 'Field 5', :value => 3, :color => GRb::Color.skyblue(224)},
  {:name => 'Field 6', :value => 2, :color => GRb::Color.purple(224) },
]

#==============================================================================#

graph = GRb::Graph::Pie.create(400, 300, true)
graph.title.text              = 'Pie Graph Sample 5' # ȥ ʸ
graph.title.font.color        = GRb::Color.white     # ȥ ե 
graph.frame.border.visible    = true                 # ط  ɽ
graph.frame.picture.visible   = true                 # ط  ɽ
graph.frame.picture.filepath  = 'background.png'     # ط  եѥ
graph.legend.position         = :bottom_right        #  
graph.legend.border.visible   = true                 #   ɽ
graph.legend.picture.visible  = true                 #   ɽ
graph.legend.picture.filepath = 'background.png'     #   եѥ
graph.legend.picture.opacity  = 70                   #   Ʃ
graph.chart.border.visible    = true                 # 㡼  ɽ
graph.chart.picture.visible   = true                 # 㡼  ɽ
graph.chart.picture.filepath  = 'background.png'     # 㡼  եѥ
graph.chart.picture.opacity   = 70                   # 㡼  Ʃ
graph.data                    = data
graph.png_file('pie5.png')

#==============================================================================#
#==============================================================================#
