#! /usr/bin/ruby

#==============================================================================#
# example/webcolor.rb
# $Id: webcolor.rb,v 1.2 2002/09/19 07:46:40 yuya Exp $
#==============================================================================#

require 'gruby/gruby'

#==============================================================================#

COLOR = [0x00, 0x33, 0x66, 0x99, 0xCC, 0xFF]

def draw(img, x, y, blue)
  6.times { |r|
    6.times { |g|
      xx = x + r * 10
      yy = y + g * 10
      img.rect!(xx, yy, xx + 10, yy + 10, nil, GRb::Color.new(COLOR[r], COLOR[g], blue))
    }
  }
end

img = GRb.create(300, 200)

grid = GRb::Color.new(208, 208, 208)
0.step(300, 10) { |x| img.line(x, 0, x, 199, grid) }
0.step(200, 10) { |y| img.line(0, y, 299, y, grid) }

draw(img,  40,  30, COLOR[0])
draw(img, 120,  30, COLOR[1])
draw(img, 200,  30, COLOR[2])
draw(img,  40, 110, COLOR[3])
draw(img, 120, 110, COLOR[4])
draw(img, 200, 110, COLOR[5])

img.png_file('webcolor.png')

#==============================================================================#
#==============================================================================#
