
#==============================================================================#
# gruby/graph/decorator/align.rb
# $Id: align.rb,v 1.4 2002/09/19 10:58:13 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    module Decorator

      class VerticalAlign < Base

        def initialize(*children)
          @children = children
        end

        def has_child?
          return !@children.empty?
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          height = box.dy.to_f / @children.size

          @children.each_with_index { |child, index|
            child_box = Box.new
            child_box.x  = box.x
            child_box.y  = box.y + (height * index).floor
            child_box.dx = box.dx
            child_box.dy = height

            child.draw(image, child_box)
          }
        end

        def dx
          return @children.collect { |child| child.dx }.max
        end

        def dy
          raise NotImplementedError
        end

      end

      #====================================================================#

      class VerticalAlignCenter < Base

        def initialize(child)
          super(child)
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          child_dy = @child.dy

          child_box = Box.new
          child_box.x = box.x
          child_box.y = box.y + box.dy / 2 - child_dy / 2
          child_box.dx = box.dx
          child_box.dy = child_dy

          @child.draw(image, child_box)
        end

      end

      #====================================================================#

      class VerticalAlignTop < Base

        def initialize(child)
          super(child)
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          child_dy = @child.dy

          child_box = Box.new
          child_box.x  = box.x
          child_box.y  = box.y
          child_box.dx = box.dx
          child_box.dy = child_dy

          @child.draw(image, child_box)
        end

      end

      #====================================================================#

      class VerticalAlignBottom < Base

        def initialize(child)
          super(child)
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          child_dy = @child.dy

          child_box = Box.new
          child_box.x  = box.x
          child_box.y  = box.y + box.dy - child_dy
          child_box.dx = box.dx
          child_box.dy = child_dy

          @child.draw(image, child_box)
        end

      end

      #====================================================================#

      class HorizontalAlign < Base

        def initialize(*children)
          @children = children
        end

        def has_child?
          return !@children.empty?
        end

        def draw_self(image, box)
        end

        def draw_child(image, box)
          width = box.dx.to_f / @children.size

          @children.each_with_index { |child, index|
            child_box = Box.new
            child_box.x  = box.x + (width * index).floor
            child_box.y  = box.y
            child_box.dx = width.floor
            child_box.dy = box.dy

            child.draw(image, child_box)
          }
        end

        def dx
          raise NotImplementedError
        end

        def dy
          return @children.collect { |child|
            child.dy
          }.max
        end

      end

      #====================================================================#

      class HorizontalAlignCenter < Base

        def initialize(child)
          super(child)
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          child_dx = @child.dx

          child_box = Box.new
          child_box.x = box.x + box.dx / 2 - child_dx / 2
          child_box.y = box.y
          child_box.dx = child_dx
          child_box.dy = box.dy

          @child.draw(image, child_box)
        end

      end

      #====================================================================#

      class HorizontalAlignLeft < Base

        def initialize(child)
          super(child)
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          child_dx = @child.dx

          child_box = Box.new
          child_box.x  = box.x
          child_box.y  = box.y
          child_box.dx = child_dx
          child_box.dy = box.dy

          @child.draw(image, child_box)
        end

      end

      #====================================================================#

      class HorizontalAlignRight < Base

        def initialize(child)
          super(child)
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          child_dx = @child.dx

          child_box = Box.new
          child_box.x  = box.x + box.dx - child_dx
          child_box.y  = box.y
          child_box.dx = child_dx
          child_box.dy = box.dy

          @child.draw(image, child_box)
        end

      end

    end

  end

end # GRb

#==============================================================================#
#==============================================================================#
