
#==============================================================================#
# gruby/graph/decorator/padding.rb
# $Id: padding.rb,v 1.4 2002/09/19 10:58:13 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    module Decorator

      class Padding < Base

        def initialize(child)
          super(child)

          @spacing_left   = 0
          @spacing_right  = 0
          @spacing_top    = 0
          @spacing_bottom = 0
        end

        attr_accessor :spacing_left, :spacing_right, :spacing_top, :spacing_bottom

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          child_box = Box.new
          child_box.x  = box.x + @spacing_left
          child_box.y  = box.y + @spacing_top
          child_box.dx = [box.dx - @spacing_left - @spacing_right,  0].max
          child_box.dy = [box.dy - @spacing_top  - @spacing_bottom, 0].max

          @child.draw(image, child_box)
        end

        def dx
          return child_dx + @spacing_left + @spacing_right
        end

        def dy
          return child_dy + @spacing_top + @spacing_bottom
        end

      end

    end

  end

end # GRb

#==============================================================================#
#==============================================================================#
