
#==============================================================================#
# $Id: border.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/border.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/singular_base'

#==============================================================================#

module GRb

  module Chart

    class BorderDecorator < SingularDecoratorBase

      def initialize(child = nil)
        super(child)

        @color = GRb::Color.black
        @width = 1
      end

      attr_accessor :color, :width

      def draw_self(image, box)
        if @width == 1
          image.rect(box.x, box.y, box.x2, box.y2, @color)
        else
          @width.times { |i|
            image.rect(box.x + i, box.y + i, box.x2 - i, box.y2 - i, @color)
          }
        end
      end

      def draw_child(image, box)
        child_box = GRb::Chart::Box.new
        child_box.x  = box.x + @width
        child_box.y  = box.y + @width
        child_box.dx = [box.dx - @width * 2, 0].max
        child_box.dy = [box.dy - @width * 2, 0].max

        @child.draw(image, child_box)
      end

      def dx
        return self.child_dx + @width * 2
      end

      def dy
        return self.child_dy + @width * 2
      end

    end # BorderDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  image = GRb::Image.create(100, 100)

  decorator = GRb::Chart::Decorator::Border.new
  decorator.color = GRb::Color.blue
  decorator.width = 1
  decorator.draw(image, GRb::Chart::Box.new(0, 0, 50, 100))

  decorator = GRb::Chart::Decorator::Border.new
  decorator.color = GRb::Color.red
  decorator.width = 3
  decorator.draw(image, GRb::Chart::Box.new(50, 0, 50, 100))

  image.write_png_file(__FILE__ + '.png')
end

#==============================================================================#
#==============================================================================#
