/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JRadioButton;
import javax.swing.table.DefaultTableModel;

class CheckAction
implements ActionListener {
    private RiderSelectionPanel vanguard;
    private RiderSelectionPanel rearguard;
    private KamenrideSelectionPanel kamenride;
    private StatusBrowserModel model;
    private DefaultTableModel tableModel;
    private JRadioButton[] modeButton;
    private FilterPanel filter;
    private OptionPanel options;

    CheckAction(RiderSelectionPanel vanguard, RiderSelectionPanel rearguard, KamenrideSelectionPanel kamenride, StatusBrowserModel model, DefaultTableModel tableModel, JRadioButton[] modeButton, FilterPanel filter, OptionPanel options) {
        this.vanguard = vanguard;
        this.rearguard = rearguard;
        this.kamenride = kamenride;
        this.model = model;
        this.tableModel = tableModel;
        this.modeButton = modeButton;
        this.filter = filter;
        this.options = options;
    }

    public void actionPerformed(ActionEvent e) {
        Rider r1 = this.vanguard.getSelectedRider();
        if (this.kamenride.isSelected() && r1 != null) {
            r1 = r1.kamenride(this.kamenride.getSelectedRider());
        }
        Rider r2 = this.rearguard.getSelectedRider();
        if (this.modeButton[0].isSelected()) {
            if (r1 != null && r2 != null && !r1.getName().equals(r2.getName())) {
                DeckStatus status = this.model.getStatus(r1, r2);
                this.tableModel.addRow(new Object[]{r1.toString(), r2.toString(), status.getOffense(), status.getDefense(), status.getHitpoint(), status.getSpecialAttack()});
            }
        } else {
            Rider rider = null;
            boolean isVanguard = true;
            if (this.modeButton[1].isSelected()) {
                rider = r1;
            } else if (this.modeButton[2].isSelected()) {
                rider = r2;
                isVanguard = false;
            }
            if (rider != null) {
                List<DeckStatus> list = this.model.getStatusList(rider, isVanguard, this.filter.getFilter(), this.options.getSortIndex());
                for (DeckStatus status : list) {
                    Rider van = status.getVanguard();
                    Rider rea = status.getRearguard();
                    this.tableModel.addRow(new Object[]{van.toString(), rea.toString(), status.getOffense(), status.getDefense(), status.getHitpoint(), status.getSpecialAttack()});
                }
            }
        }
    }
}

