#ifndef GAME_SYOKUNIN_COM_SAPLING_TREE_H

#define GAME_SYOKUNIN_COM_SAPLING_TREE_H

/*
gslib/sapling/tree.h

zlib/libpng license
-------------------

Copyright (C) 2004 &o

This software is provided 'as-is', without any express or implied warranty. In n
o event will the authors be held liable for any damages arising from the use of 
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

The origin of this software must not be misrepresented; you must not claim that 
you wrote the original software. If you use this software in a product, an ackno
wledgment in the product documentation would be appreciated but is not required.

Altered source versions must be plainly marked as such, and must not be misrepre
sented as being the original software.
This notice may not be removed or altered from any source distribution.

project site : https://sourceforge.jp/projects/gslib/
my site : http://www.game-syokunin.com/
--------------------------------------------------------------------------------

@Iɂ́AĽ̂قLȂ̂ŁA茵ɂ͓{Qlɂ
ĂB{́Ahttp://opensource.jp/licenses/zlib-license.html 璸
Ă܂B

zlib/libpngCZX ( { )

Copyright (C) 2004 &o

{\tgEFÁû܂܁vŁAł邩Öقł邩킸A̕ۏ؂
Ȃ񋟂܂B{\tgEFA̎gpɂĐ邢Ȃ鑹QɂĂA
͈؂̐ӔC𕉂Ȃ̂Ƃ܂B ȉ̐ɏ]ApAvP[V
܂߂āA{\tgEFACӂ̖ړIɎgpARɉςčĔЕz邱Ƃ
Ă̐lɋ܂B

{\tgEFȀoɂċU̕\Ă͂Ȃ܂BȂIWĩ\
tgEFA쐬Ǝ咣Ă͂Ȃ܂BȂ{\tgEFA𐻕iŎgp
ꍇAi̕ɎӎĂ΍KłAK{ł͂܂B
\[XύXꍇ́ÂƂ𖾎Ȃ΂Ȃ܂BIWĩ\tgE
FAłƂU̕\Ă͂Ȃ܂B
\[X̔ЕzA̕\폜A\̓eύX肵Ă͂Ȃ܂
B 

project site : https://sourceforge.jp/projects/gslib/
my site : http://www.game-syokunin.com/
*/

#include <boost/assert.hpp>
#include <boost/iterator/iterator_facade.hpp>
#include <memory>

#pragma warning( disable : 4355 )

namespace gslib {
	namespace sapling {

		///	ėp؃NX
		/**
		 *	STL Rei̖؃NXB
		 *
		 *	- [g
		 *		- ŏʑwɂ͈̃m[hȂ
		 *		- ؂ꂽiKł̓[g݂͑Ȃ
		 *		- root() ܂ insert() ֐Ő\
		 *	- Ce[^[
		 *		- ASYɂCe[^[݂
		 *			- sibling_iterator
		 *				- ڂ̎q݂̂𑖍
		 *			- pre_order_iterator
		 *				- sŕ؂𑖍
		 *			- post_order_iterator
		 *				- sŕ؂𑖍
		 *			- ꂼ̃Ce[^[͔rɊւČ݊
		 *		- łeAZAqm[hֈړł
		 */
		template < typename Value, typename Allocator = std::allocator< void > >
		class tree {
		public:
			typedef Value				value_type;
			typedef value_type&			reference;
			typedef const value_type&	const_reference;
			typedef size_t				size_type;
			static const size_type npos = ~0;
			
		private:
			struct link {
				link*	self;
				link*	prev;
				link*	next;
				
				link() : self( this ), prev( this ), next( this ) {}
				link( link* ioSelf ) : self( ioSelf ), prev( this ), next( this ) {}
			};
			
			struct root_end : public link {
				root_end*	parent;
				
				root_end() : link(), parent( 0 ) {}
				root_end( root_end* ioSelf ) : link( ioSelf ), parent( 0 ) {}
			};
			
			struct value_holder : public root_end {
				Value	value;
				
				value_holder() : root_end() {}
				value_holder( const_reference v ) : value( v ), root_end( this ) {}
			};
			
			///	ۂɃAP[VNX
			class node : public value_holder {
				link			self_children_;		///< q(Jn`I[)i[
			public:
				
				///	get depth / [擾
				/**
				 *	@retval	0			root
				 *	@retval	tree::npos	root end ( = tree.end() )
				 *	@retval	others		distance from root
				 */
				size_type depth() const {
					if ( is_root_end( this ) ) {
						return npos;
					}
					size_type i = 0;
					const node* n = this;
					while ( false == is_root( n ) ) {
						++i;
						n = n->parent();
					}
					return i;
				}
				node*	parent() {
					return static_cast< node* >( value_holder::parent );
				}
				node*	next() {
					return static_cast< node* >( value_holder::next );
				}
				node*	prev() {
					return static_cast< node* >( value_holder::prev );
				}
				node*	begin() {
					return static_cast< node* >( self_children_.next );
				}
				node*	end() {
					return static_cast< node* >( &self_children_ );
				}
				const node*	parent() const {
					return static_cast< const node* >( value_holder::parent );
				}
				const node*	next() const {
					return static_cast< const node* >( value_holder::next );
				}
				const node*	prev() const {
					return static_cast< const node* >( value_holder::prev );
				}
				const node*	begin() const {
					return static_cast< const node* >( self_children_.next );
				}
				const node*	end() const {
					return static_cast< const node* >( &self_children_ );
				}
				reference	value() {
					return value_holder::value;
				}
				const_reference	value() const {
					return value_holder::value;
				}
				void next( link* n ) {
					value_holder::next = n;
				}
				void prev( link* p ) {
					value_holder::prev = p;
				}
				void parent( link* p ) {
					value_holder::parent = static_cast< root_end* >( p );
				}
				
				node( const_reference v ) :
					value_holder( v ),
					self_children_( this ) {
				}
			};

			class iterator_base {
			protected:
				friend class tree;
				
				value_holder*	cur_;
				
				void link_next() {
					cur_ = static_cast< value_holder* >( cur_->next );
				}
				void link_prev() {
					cur_ = static_cast< value_holder* >( cur_->prev );
				}
				
				node* self() {
					return static_cast< node* >( cur_->self );
				}
				iterator_base() {}
				iterator_base( value_holder* n ) : cur_( n ) {}

			public:
				bool equal( const iterator_base& other ) const {
					return cur_ == other.cur_;
				}
				
				size_type depth() const {
					BOOST_ASSERT( 0 != cur_ );
					return get_node( cur_ )->depth();
				}
				
				const_reference	dereference() const {
					return cur_->value;
				}
				
				bool operator == ( const iterator_base& other ) const {
					return equal( other );
				}
				bool operator != ( const iterator_base& other ) const {
					return !equal( other );
				}
			};
			
			static node* get_node( link* lnk ) {
				return static_cast< node* >( lnk->self );
			}
				
			static bool has_child( const link* lnk ) {
				const node* n = static_cast< const node* >( lnk->self );
				return n->begin() != n->end();
			}
			
			static bool is_root_end( const link* lnk ) {
				return 0 == static_cast< const root_end* >( lnk )->parent;
			}

			static node* get_parent( link* lnk ) {
				node* n = static_cast< node* >( lnk->self );
				return lnk == n->end() ? n : static_cast< node* >( n->parent() );
			}

			static const node* get_parent( const link* lnk ) {
				const node* n = static_cast< const node* >( lnk->self );
				return lnk == n->end() ? n : static_cast< const node* >( n->parent() );
			}

			static bool is_end( link* lnk ) {
				return lnk == get_node( lnk )->end();
			}
			
			static bool is_back( link* lnk ) {
				return lnk == get_parent( lnk )->end()->prev;
			}

			static bool is_begin( link* lnk ) {
				return lnk == get_parent( lnk )->begin();
			}
			
			static bool is_root( const link* lnk ) {
				return is_root_end( get_parent( lnk ) );
			}
			
			typedef typename Allocator::rebind< node >::other	allocator_type;

			allocator_type	allocator_;
			root_end		end_;

			node* root_ptr() {
				return static_cast< node* >( end_.next->self );
			}
			const node* root_ptr() const {
				return static_cast< node* >( end_.next->self );
			}

		public:
			static const size_type
				allocation_size = sizeof ( node ); ///< tree xɃAP[V傫 ( v[Ȃǂɗp )

			class const_sibling_iterator :
				public iterator_base,
				public boost::iterator_facade<
					const_sibling_iterator,
					const value_type,
					boost::bidirectional_traversal_tag > {
			public:
				void increment() {
					iterator_base::link_next();
				}
				void decrement() {
					iterator_base::link_prev();
				}

				const_sibling_iterator parent() {
					BOOST_ASSERT( cur_ && self() );
					return const_sibling_iterator( get_parent( cur_ ) );
				}
				
				const_sibling_iterator next() {
					BOOST_ASSERT( cur_ && self() );
					return const_sibling_iterator( self()->next() );
				}

				const_sibling_iterator prev() {
					BOOST_ASSERT( cur_ && self() );
					return const_sibling_iterator( self()->prev() );
				}

				const_sibling_iterator begin() {
					BOOST_ASSERT( cur_ && self() );
					return const_sibling_iterator( self()->begin() );
				}

				const_sibling_iterator end() {
					BOOST_ASSERT( cur_ && self() );
					return const_sibling_iterator( self()->end() );
				}
										
				const_sibling_iterator() {}
				const_sibling_iterator( const value_holder* lnk ) : iterator_base( const_cast< value_holder* >( lnk ) ) {}
			};
			
			#define ITERATOR_COMMON( x )	\
				class x##_iterator :\
					public const_##x##_iterator {\
				public:\
					reference	dereference() const {\
						return cur_->value;\
					}\
					reference	operator * () const {\
						return dereference();\
					}\
					value_type*	operator -> () const {\
						return &dereference();\
					}\
					x##_iterator& operator ++ () {\
						return static_cast< x##_iterator& >( const_##x##_iterator::operator ++ () );\
					}\
					x##_iterator operator ++ ( int ) {\
						return static_cast< x##_iterator& >( const_##x##_iterator::operator ++ ( int() ) );\
					}\
					x##_iterator& operator -- () {\
						return static_cast< x##_iterator& >( const_##x##_iterator::operator -- () );\
					}\
					x##_iterator operator -- ( int ) {\
						return static_cast< x##_iterator& >( const_##x##_iterator::operator -- ( int() ) );\
					}\
					x##_iterator parent() {\
						return static_cast< x##_iterator& >( const_##x##_iterator::parent() );\
					}\
					x##_iterator next() {\
						BOOST_ASSERT( cur_ && cur_->self );\
						return static_cast< x##_iterator& >( const_##x##_iterator::next() );\
					}\
					x##_iterator prev() {\
						BOOST_ASSERT( cur_ && cur_->self );\
						return static_cast< x##_iterator& >( const_##x##_iterator::prev() );\
					}\
					x##_iterator begin() {\
						BOOST_ASSERT( cur_ && cur_->self );\
						return static_cast< x##_iterator& >( const_##x##_iterator::begin() );\
					}\
					x##_iterator end() {\
						BOOST_ASSERT( cur_ && cur_->self );\
						return static_cast< x##_iterator& >( const_##x##_iterator::end() );\
					}\
					x##_iterator() {}\
					x##_iterator( value_holder* lnk ) : const_##x##_iterator( lnk ) {}\
				};\
				x##_iterator end_##x##() { return x##_iterator( static_cast< value_holder* >( &end_ ) ); }\
				x##_iterator begin_##x##() { return ++end_##x##(); }\
				const_##x##_iterator end_##x##() const { return const_##x##_iterator( static_cast< const value_holder* >( &end_ ) ); }\
				const_##x##_iterator begin_##x##() const { return ++end_##x##(); }
			
			ITERATOR_COMMON( sibling )

			class const_post_order_iterator :
				public iterator_base,
				public boost::iterator_facade<
					const_post_order_iterator,
					const Value,
					boost::bidirectional_traversal_tag > {
				
				void down() {
					cur_ = self()->begin();
				}
				void up() {
					cur_ = get_parent( cur_ );
				}
				
				friend class tree;
				
				///	Ƃ܂ŉ
				void bottom() {
					while ( self()->begin() != self()->end() ) {
						down();
					}
				}
			public:
				void increment() {
					iterator_base::link_next();
					if ( is_root_end( cur_ ) ) {
						//	Ȃ
						return;
					} else if ( is_end( cur_ ) ) {
						//	I[܂ŗ̂ŏオ
						up();
						return;
					}
					//	Ƃ܂ŉ
					bottom();
				}

				void decrement() {
					while ( false == is_root_end( cur_ ) && is_begin( cur_ ) ) {
						//	擪łオ葱
						up();
					}
					if ( 0 != self()->parent() ) {
						iterator_base::link_prev();
					}
				}
				const_post_order_iterator parent() {
					BOOST_ASSERT( cur_ && self() );
					return const_post_order_iterator( get_parent( cur_ ) );
				}
				
				const_post_order_iterator next() {
					BOOST_ASSERT( cur_ && self() );
					return const_post_order_iterator( self()->next() );
				}

				const_post_order_iterator prev() {
					BOOST_ASSERT( cur_ && self() );
					return const_post_order_iterator( self()->prev() );
				}

				const_post_order_iterator begin() {
					BOOST_ASSERT( cur_ && self() );
					return const_post_order_iterator( self()->begin() );
				}

				const_post_order_iterator end() {
					return *this;
				}
				const_post_order_iterator() {}
				const_post_order_iterator( const value_holder* lnk ) : iterator_base( const_cast< value_holder* >( lnk ) ) {}
			};

			ITERATOR_COMMON( post_order )
			
			class const_pre_order_iterator :
				public iterator_base,
				public boost::iterator_facade<
					const_pre_order_iterator,
					const Value,
					boost::bidirectional_traversal_tag > {

				void down_front() {
					cur_ = self()->begin();
				}
				
				void down_back() {
					cur_ = self()->end()->prev();
				}
				void up() {
					cur_ = get_parent( cur_ );
				}
				
				friend class tree;
				
				///	Ƃ܂ŉ
				void bottom_back() {
					while ( has_child( cur_ ) ) {
						down_back();
					}
				}
			public:
				void increment() {
					if ( is_root_end( cur_ ) ) {
						iterator_base::link_next();
					} else if ( has_child( cur_ ) ) {
						down_front();
					} else {
						iterator_base::link_next();
						while ( false == is_root_end( cur_ ) && is_end( cur_ ) ) {
							//	I[łオ葱
							up();
							iterator_base::link_next();
						}
					}
				}

				void decrement() {
					if ( false == is_root_end( cur_ ) && ( is_root( cur_ ) || is_begin( cur_ ) ) ) {
						up();
					} else {
						iterator_base::link_prev();
						bottom_back();
					}
				}
				const_pre_order_iterator parent() {
					BOOST_ASSERT( cur_ && self() );
					return const_pre_order_iterator( get_parent( cur_ ) );
				}
				
				const_pre_order_iterator next() {
					BOOST_ASSERT( cur_ && self() );
					return const_pre_order_iterator( self()->next() );
				}

				const_pre_order_iterator prev() {
					BOOST_ASSERT( cur_ && self() );
					return const_pre_order_iterator( self()->prev() );
				}

				const_pre_order_iterator begin() {
					BOOST_ASSERT( cur_ && self() );
					return const_pre_order_iterator( self()->begin() );
				}

				const_pre_order_iterator end() {
					return *this;
				}
				const_pre_order_iterator() {}
				const_pre_order_iterator( const value_holder* lnk ) : iterator_base( const_cast< value_holder* >( lnk ) ) {}
			};

			ITERATOR_COMMON( pre_order )
			
			typedef sibling_iterator			iterator;
			typedef const_sibling_iterator	const_iterator;
			
			template < typename It >
			It insert( It& ioWhere, const Value& v ) {
				node* n;
				if ( &end_ == ioWhere.cur_ ) {
					BOOST_ASSERT( empty() );
					n = new( allocator_.allocate( 1 ) )	node( v );
					connect_root( n );
				} else {
					BOOST_ASSERT( root_ptr() != ioWhere.cur_ );
					value_holder* w = ioWhere.cur_;
					link* p = ioWhere.cur_->prev;
					
					n = new( allocator_.allocate( 1 ) )	node( v );
					
					p->next = n;
					n->prev( p );
					n->parent( get_parent( w ) );
					n->next( w );
					w->prev = n;
				}		
				return It( n );
			}
			
			void erase( iterator_base& it ) {
				if ( empty() ) {
					//	łɋȂ̂ŁAȂ
					return;
				}
				
				post_order_iterator first = post_order_iterator( it.self() );
				first.bottom();
				post_order_iterator last = post_order_iterator( it.self() );
				for ( post_order_iterator j = first; j != last; ) {
					post_order_iterator del( j++ );
					del.self()->~node();
					allocator_.deallocate( del.self(), 1 );
				}
				link* n = it.cur_->next;
				link* p = it.cur_->prev;
				p->next = n;
				n->prev = p;
				it.self()->~node();
				allocator_.deallocate( it.self(), 1 );
			}
			
			void clear() {
				erase( begin() );
			}

		private:
			void connect_root( link* root ) {
				BOOST_ASSERT( root == root->self );
				end_.next = root;
				end_.prev = root;
				root->next = &end_;
				root->prev = &end_;
				static_cast< node* >( root )->parent( &end_ );
			}
			void copy( const_sibling_iterator first, const_sibling_iterator last, sibling_iterator out_last ) {
				for ( const_sibling_iterator it = first; it != last; ++it ) {
					copy(
						it.begin(),
						it.end(),
						insert( out_last, *it ).end() );
				}
			}
		public:
			///	[g𐶐/ύX
			/**
			 *	[g݂Ȃꍇ̓[g쐬B
			 *	łɃ[g݂ꍇ v ŏ㏑B
			 */
			void root( const_reference v ) {
				if ( empty() ) {
					//	root 쐬
					insert( end(), v );
				} else {
					//	root ㏑
					root() = v;
				}
			}
			
			reference root() {
				return root_ptr() ? root_ptr()->value() : *( ( value_type* ) 0 );
			}
			const_reference root() const {
				return root_ptr() ? root_ptr()->value() : *( ( value_type* ) 0 );
			}
			
			iterator begin() {
				return begin_sibling();
			}
			
			iterator end() {
				return end_sibling();
			}
			
			const_iterator begin() const {
				return begin_sibling();
			}
			
			const_iterator end() const {
				return end_sibling();
			}
			
			bool empty() const { return end_.next == &end_; }
			
			explicit tree( const Allocator& allocator = Allocator() ) :
				allocator_( allocator ) {
			}
			
			void swap( tree& other ) {
				std::swap( allocator_, other.allocator_ );
				if ( end_.prev == &end_ ) {
					if ( other.end_.next != &other.end_ ) {
						connect_root( other.end_.next );
					}
					other.end_.prev = &other.end_;
					other.end_.next = &other.end_;
				} else if ( other.end_.next == &other.end_ ) {
					other.connect_root( end_.next );
					end_.prev = &end_;
					end_.next = &end_;
				} else {
					//	oƂqĂ
					link* other_root = other.end_.next;
					other.connect_root( end_.next );
					connect_root( other_root );
				}
			}
			
			tree( const tree& other ) {
				if ( false == other.empty() ) {
					root( other.root() );
					const_sibling_iterator it = other.begin_sibling();
					copy( it.begin(), it.end(), begin_sibling().end() );
				}
			}
			
			tree& operator = ( const tree& other ) {
				tree deadbeef( other );
				deadbeef.swap( *this );
				return *this;
			}
			
			~tree() {
				clear();
			}

			#undef ITERATOR_COMMON
		};
	}
}

#endif
