package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import java.util.*;
import java.math.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * Cѓɂ闝_<I>m/z</I> vZNXłD
 * @author m
 * @version 20090129
 */
public class MassCalc
{
    // eq̕q <http://physics.nist.gov/PhysRefData/Compositions/>
    static final double MONO_1H  = 1.0078250321;
    static final double ABUND_1H = 99.9885;
    static final double MONO_2H  = 2.0141017780;
    static final double ABUND_2H = 0.0115;
    static final double AVG_H    = MONO_1H * ABUND_1H / 100
                                 + MONO_2H * ABUND_2H / 100;

    static final double MONO_6Li  = 6.0151223;
    static final double ABUND_6Li = 7.59;
    static final double MONO_7Li  = 7.0160040;
    static final double ABUND_7Li = 92.41;
    static final double AVG_Li    = MONO_6Li * ABUND_6Li / 100
                                  + MONO_7Li * ABUND_7Li / 100;

    static final double MONO_12C  = 12.0000000;
    static final double ABUND_12C = 98.93;
    static final double MONO_13C  = 13.0033548378;
    static final double ABUND_13C = 1.07;
    static final double AVG_C     = MONO_12C * ABUND_12C / 100
                                  + MONO_13C * ABUND_13C / 100;

    static final double MONO_14N  = 14.0030740052;
    static final double ABUND_14N = 99.632;
    static final double MONO_15N  = 15.0001088984;
    static final double ABUND_15N = 0.368;
    static final double AVG_N     = MONO_14N * ABUND_14N / 100
                                  + MONO_15N * ABUND_15N / 100;

    static final double MONO_16O  = 15.9949146221;
    static final double ABUND_16O = 99.757;
    static final double MONO_17O  = 16.99913150;
    static final double ABUND_17O = 0.038;
    static final double MONO_18O  = 17.9991604;
    static final double ABUND_18O = 0.205;
    static final double AVG_O     = MONO_16O * ABUND_16O / 100
                                  + MONO_17O * ABUND_17O / 100
                                  + MONO_18O * ABUND_18O / 100;

    static final double MONO_23Na  = 22.98976967;
    static final double ABUND_23Na = 100.0;
    static final double AVG_Na     = MONO_23Na * ABUND_23Na / 100;

    static final double MONO_28Si  = 27.9769265327;
    static final double ABUND_28Si = 92.2297;
    static final double MONO_29Si  = 28.97649472;
    static final double ABUND_29Si = 4.6832;
    static final double MONO_30Si  = 29.97377022;
    static final double ABUND_30Si = 3.0872;
    static final double AVG_Si     = MONO_28Si * ABUND_28Si / 100
                                   + MONO_29Si * ABUND_29Si / 100
                                   + MONO_30Si * ABUND_30Si / 100;

    static final double MONO_31P  = 30.97376151;
    static final double ABUND_31P = 100.0;
    static final double AVG_P     = MONO_31P * ABUND_31P / 100;

    static final double MONO_32S  = 31.97207069;
    static final double ABUND_32S = 94.93;
    static final double MONO_33S  = 32.97145850;
    static final double ABUND_33S = 0.76;
    static final double MONO_34S  = 33.96786683;
    static final double ABUND_34S = 4.29;
    static final double MONO_36S  = 35.96708088;
    static final double ABUND_36S = 0.02;
    static final double AVG_S     = MONO_32S * ABUND_32S / 100
                                  + MONO_33S * ABUND_33S / 100
                                  + MONO_34S * ABUND_34S / 100
                                  + MONO_36S * ABUND_36S / 100;

    static final double MONO_39K  = 38.9637069;
    static final double ABUND_39K = 93.2581;
    static final double MONO_40K  = 39.96399867;
    static final double ABUND_40K = 0.0117;
    static final double MONO_41K  = 40.96182597;
    static final double ABUND_41K = 6.7302;
    static final double AVG_K     = MONO_39K * ABUND_39K / 100
                                  + MONO_40K * ABUND_40K / 100
                                  + MONO_41K * ABUND_41K / 100;

    static final double MONO_127I  = 126.904468;
    static final double ABUND_127I = 100.0;
    static final double AVG_I      = MONO_127I * ABUND_127I / 100;

    int H  = 0;           // eqi[
    int Li = 0;
    int C  = 0;
    int N  = 0;
    int O  = 0;
    int Na = 0;
    int Si = 0;
    int P  = 0;
    int S  = 0;
    int K  = 0;

    boolean monoisotopic; // MONO_MASS(true), AVG_MASS(false)i[D
    static final boolean MONO_MASS = true;
    static final boolean AVG_MASS  = false;

    String adduct;        // tCI
    static final String H_ION  = "h";
    static final String Li_ION = "li";
    static final String Na_ION = "na";
    static final String K_ION  = "k";
    static final String H_NION = "h-";

    /**
     * mAC\g[vC܂̓Ax[WŌvZ邩ݒ肷RXgN^
     * @param monoisotopic mAC\gsbN܂̓Ax[WD
     * @param adduct tCI
     */
    public MassCalc(boolean monoisotopic, String adduct)
    {
        this.monoisotopic = monoisotopic;
        this.adduct = adduct;
    }

    /**
     * <I>m/z</I> vZgo^܂D
     * @param cp m/zvZg
     */
    public void setComposition(Composition cp) throws Exception
    {
        Composition temp_cp = new Composition(cp);                       // gCX^XRs[D

        for (int i = 0; i < Collections.frequency(temp_cp, "-h2o"); i++) // ŏɎwEĂD
            modif("-h2o");
        temp_cp.removeAll(new Composition("-h2o"));                      // g폜

        for (int i = 0; i < Collections.frequency(temp_cp, "h2o"); i++)  // ŏɎwĂD
            modif("h2o");
        temp_cp.removeAll(new Composition("h2o"));                       // g폜

        for (int i = 0; i < Collections.frequency(temp_cp, "-h"); i++)   // ŏɎw폜ĂD
            H--;
        temp_cp.removeAll(new Composition("-h"));                        // g폜

        for (int i = 0; i < Collections.frequency(temp_cp, "h"); i++)    // ŏɎwĂD
            H++;
        temp_cp.removeAll(new Composition("h"));                         // g폜

        for (int i = 0; i < Collections.frequency(temp_cp, "na"); i++)   // ŏɎwĂD
            Na++;
        temp_cp.removeAll(new Composition("na"));                        // g폜

        for (int i = 0; i < Collections.frequency(temp_cp, "li"); i++)   // ŏɎwĂD
            Li++;
        temp_cp.removeAll(new Composition("li"));                        // g폜

        for (int i = 0; i < Collections.frequency(temp_cp, "k"); i++)    // ŏɎwĂD
            K++;
        temp_cp.removeAll(new Composition("k"));                         // g폜

        Iterator<String> it = temp_cp.iterator();
        for (int i = 0; it.hasNext(); i++)
        {
            String temp = it.next();

            temp = temp.replaceAll("glc|man|gal", "hex");                // Hex֕ϊ
            temp = temp.replaceAll("lfuc|fuc|rha", "dhex");              // dHex֕ϊ
            temp = temp.replaceAll("xyl|ara", "pen");                    // pen֕ϊ

            if (temp.matches("\\w+-\\w+"))                               // "a-fuc"trueC"-h2o"false
            {
                String[] temps = temp.split("-");
                temp = temps[temps.length-1];                            // "-"ŋ؂ꂽ̈ԍŌ
            }

            if (temp.matches("^(dhex|hex|hexnac|p|c|pc|ins|hexa|pen|pea|aep|kdn|neuac|neugc)$"))
                glycan(temp);
            else if (temp.matches("^(dhex|hex|hexnac|p|c|pc|ins|hexa|pen|pea|aep|kdn|neuac|neugc)([0-9]*)(me|ac)$"))
                methylglycan(temp);                                      // `
            else if (temp.matches("^(dhex|hex|hexnac|p|c|pc|ins|hexa|pen|pea|aep|kdn|neuac|neugc)pa$"))
                paglycan(temp);                                          // sWA~m
            else if (temp.matches("^(dhex|hex|hexnac|p|c|pc|ins|hexa|pen|pea|aep|kdn|neuac|neugc)ab$"))
                abglycan(temp);                                          // A~mxYA~h
            else if (temp.matches("^[dt][ch][0-9]+:[0-9]$"))
                cer(temp);
            else if (temp.matches("^[dt][0-9]+:[0-9]$"))
                lcb(temp);
            else if (temp.matches("^[ch][0-9]+:[0-9]$"))
                fa(temp);
            else if (temp.matches("^(me|et|ac|s|tms|pa|ab)$"))
                modif(temp);
            else
                throw new Exception("Unknown Composition: " + temp);

            if (i != 0)                                                  // gPȏ̎
            {
                H -= 2; O -= 1;                                          // Ek
            }
        }
    }

    /**
     * qǉ郁\bh
     * @param line "Hex", "TMS"Ȃǂi[
     */
    private void glycan(String str) throws Exception
    {
        if (str.equals("dhex"))
        {
            C += 6; H += 12; O += 5;
        }
        else if (str.equals("hex") || str.equals("ins"))
        {
            C += 6; H += 12; O += 6;
        }
        else if (str.equals("hexnac"))
        {
            C += 8; H += 15; O += 6; N += 1;
        }
        else if (str.equals("p"))
        {
            H += 3; P += 1; O += 4;                                      // OȞ`ŌvZ
        }
        else if (str.equals("c"))
        {
            C += 5; H += 14; O += 1; N += 1;
        }
        else if (str.equals("pc"))
        {
            glycan("p");
            glycan("c");
            H -= 2; O -= 1;                                              // Ek
        }
        else if (str.equals("hexa"))
        {
            C += 6; H += 10; O += 7;                                     // COOHƂČvZ
        }
        else if (str.equals("pen"))
        {
            C += 5; H += 10; O += 5;
        }
        else if (str.equals("pea"))
        {
            glycan("p");
            C += 2; H += 7; O += 1; N += 1;                              // OH-CH2-CH2-NH2
            H -= 2; O -= 1;                                              // Ek
        }
        else if (str.equals("aep"))
        {
            glycan("pea");
            O -= 1;                                                      // AEPPEAC-O-PC-P
        }
        else if (str.equals("kdn"))
        {
            C += 9; H += 16; O += 9;                                     // COOHƂČvZ
        }
        else if (str.equals("neuac"))
        {
            glycan("kdn");                                               // KDN  NeuAcւ̕ώC5ʂ̍\
            C += 2; H += 3; N += 1;                                      // -OH  -NH-CO-CH3֕ώD
        }
        else if (str.equals("neugc"))
        {
            glycan("neuac");                                             // NeuAc  NeuGcւ̕ώC5ʂ̍\
            O += 1;                                                      // -NH-CO-CH3  -NH-CO-CH2-OH֕ώD
        }
        else                                                             // SĈvȂꍇ
            throw new Exception("Unknown Composition: " + str);
    }

    /**
     * `ǉ郁\bh
     * @param line "Hex", "TMS"Ȃǂi[
     */
    private void methylglycan(String str) throws Exception
    {
        Pattern pt = Pattern.compile("^(dhex|hex|hexnac|p|c|pc|ins|hexa|pen|pea|aep|kdn|neuac|neugc)([0-9]*)(me|ac)$");
        Matcher mt = pt.matcher(str);

        if (mt.matches())
        {
            glycan(mt.group(1));                       // CtP

            int count;                                 // Či[
            if(mt.group(2).equals(""))
                count = 1;                             // w肳ĂȂ΁CPƂD
            else
                count = Integer.parseInt(mt.group(2)); // w肳ꂽi[D

            for (int i = 0; i < count; i++)            // Č[v
            {
                modif(mt.group(3));                    // Ct
                H -= 2; O -= 1;                        // Ek
            }
        }
        else                                           // K\ƈvȂꍇ
            throw new Exception("Unknown Composition: " + str);
    }

    /**
     * sWA~mǉ郁\bh
     * @param line "Hex", "TMS"Ȃǂi[
     */
    private void paglycan(String str) throws Exception
    {
        Pattern pt = Pattern.compile("^(dhex|hex|hexnac|p|c|pc|ins|hexa|pen|pea|aep|kdn|neuac|neugc)pa$");
        Matcher mt = pt.matcher(str);

        if (mt.matches())
        {
            glycan(mt.group(1)); // CtP
            modif("pa");         // Ct
            H -= 2; O -= 1;      // Ek
            H += 2;              // ̊JPǍ̌ʂ̍
        }
        else                     // K\ƈvȂꍇ
            throw new Exception("Unknown Composition: " + str);
    }

    /**
     * A~mxYA~hǉ郁\bh
     * @param line "Hex", "TMS"Ȃǂi[
     */
    private void abglycan(String str) throws Exception
    {
        Pattern pt = Pattern.compile("^(dhex|hex|hexnac|p|c|pc|ins|hexa|pen|pea|aep|kdn|neuac|neugc)ab$");
        Matcher mt = pt.matcher(str);

        if (mt.matches())
        {
            glycan(mt.group(1)); // CtP
            modif("ab");         // Ct
            H -= 2; O -= 1;      // Ek
            H += 2;              // ̊JPǍ̌ʂ̍
        }
        else                     // K\ƈvȂꍇ
            throw new Exception("Unknown Composition: " + str);
    }

    /**
     * qǉ郁\bh
     * @param line "Hex", "TMS"Ȃǂi[
     */
    private void cer(String str) throws Exception
    {
        Pattern pt = Pattern.compile("^([dt])([ch][0-9]+:[0-9])$");
        Matcher mt = pt.matcher(str);

        if (mt.matches())
        {
            lcb(mt.group(1) + "0:0"); // ͒YfOCdOƂāC
            fa(mt.group(2));          // YfƓd͎b_։ČvZD
            H -= 2; O -= 1;           // Ek
        }
        else
            throw new Exception("Unknown Composition: " + str);
    }

    /**
     * qǉ郁\bh
     * @param line "d16:1", "t16:0"Ȃǂi[
     */
    private void lcb(String str) throws Exception
    {
        Pattern pt = Pattern.compile("^([dt])([0-9]+):([0-9])$");
        Matcher mt = pt.matcher(str);

        if (mt.matches())
        {
            int corbons = Integer.parseInt(mt.group(2));
            int bonds   = Integer.parseInt(mt.group(3));

            if (mt.group(1).equals("d"))
            {
                C += corbons; H += corbons*2-bonds*2+3; O += 2; N += 1;
            }
            else if (mt.group(1).equals("t"))
            {
                C += corbons; H += corbons*2-bonds*2+3; O += 3; N += 1;
            }
        }
        else
            throw new Exception("Unknown Composition: " + str);
    }


    /**
     * b_qǉ郁\bh
     * @param line "d16:1", "t16:0"Ȃǂi[
     */
    private void fa(String str) throws Exception
    {
        Pattern pt = Pattern.compile("^([ch])([0-9]+):([0-9])$");
        Matcher mt = pt.matcher(str);

        if (mt.matches())
        {
            int corbons = Integer.parseInt(mt.group(2));
            int bonds   = Integer.parseInt(mt.group(3));

            if (mt.group(1).equals("c"))
            {
                C += corbons; H += corbons*2-bonds*2; O += 2;
            }
            else if (mt.group(1).equals("h"))
            {
                C += corbons; H += corbons*2-bonds*2; O += 3;
            }
        }
        else
            throw new Exception("Unknown Composition: " + str);
    }

    /**
     * qǉ郁\bh
     * @param line "d16:1", "t16:0"Ȃǂi[
     */
    private void modif(String str) throws Exception
    {
        if (str.equals("me"))
        {
            C += 1; H += 4; O += 1;
        }
        else if (str.equals("et"))
        {
            C += 2; H += 6; O += 1;
        }
        else if (str.equals("-h2o"))
        {
            H -= 2; O -= 1;
        }
        else if (str.equals("h2o"))
        {
            H += 2; O += 1;
        }
        else if (str.equals("ac"))
        {
            C += 2; H += 4; O += 2;
        }
        else if (str.equals("s"))
        {
            H += 2; S += 1; O += 4;
        }
        else if (str.equals("tms"))
        {
            C += 3; H += 10; O += 1; Si += 1;
        }
        else if (str.equals("pa"))
        {
            C += 5; H += 6; N += 2;
        }
        else if (str.equals("ab"))
        {
            C += 6; H += 6; N += 3; O += 1;
        }
        else
            throw new Exception("Unknown Composition: " + str);
    }

    /**
     * _<I>m/z</I> Ԃ܂D
     * @return _<I>m/z</I>
     */
    public double getMass()
    {
        if (monoisotopic)
            return MONO_1H   * H
                 + MONO_6Li  * Li
                 + MONO_12C  * C
                 + MONO_14N  * N
                 + MONO_16O  * O
                 + MONO_23Na * Na
                 + MONO_28Si * Si
                 + MONO_31P  * P
                 + MONO_32S  * S
                 + MONO_39K  * K;
        else
            return AVG_H  * H
                 + AVG_Li * Li
                 + AVG_C  * C
                 + AVG_N  * N
                 + AVG_O  * O
                 + AVG_Na * Na
                 + AVG_Si * Si
                 + AVG_P  * P
                 + AVG_S  * S
                 + AVG_K  * K;
    }

    /**
     * _<I>m/z</I> Ԃ܂D
     * @return _<I>m/z</I>
     * @param cp vZg
     */
    public double getMass(Composition cp) throws Exception
    {
        H=0; Li=0; C=0; N=0; O=0; Na=0; Si=0; P=0; S=0; K=0; // 

        if (adduct.equals("h"))                              // tCIǉ
            H++;
        else if (adduct.equals("li"))
            Li++;
        else if (adduct.equals("na"))
            Na++;
        else if (adduct.equals("k"))
            K++;
        else if (adduct.equals("h-"))
            H--;
        else if (!adduct.equals("") && adduct != null)
            throw new Exception("Unknown adduct ion: " + adduct);

        setComposition(cp);                                 // go^D

        return getMass();
    }

    /**
     * _<I>m/z</I> Ԃ܂D
     * @return _<I>m/z</I>
     * @param gc vZ\
     */
    public double getMass(Glycan gc) throws Exception
    {
        return getMass(new Composition(gc));
    }

    /**
     * qԂ܂D
     * @return q
     * @param cp vZg
     */
    public String getMolecularFormula(Composition cp) throws Exception
    {
        H=0; Li=0; C=0; N=0; O=0; Na=0; Si=0; P=0; S=0; K=0; // 

        if (adduct.equals("h"))                              // tCIǉ
            H++;
        else if (adduct.equals("li"))
            Li++;
        else if (adduct.equals("na"))
            Na++;
        else if (adduct.equals("k"))
            K++;
        else if (adduct.equals("h-"))
            H--;
        else if (!adduct.equals("") && adduct != null)
            throw new Exception("Unknown adduct ion: " + adduct);

        setComposition(cp);                                 // go^D

        StringBuilder sb = new StringBuilder();
        if (C == 1)
            sb.append("C");
        else if (C > 1)
            sb.append("C" + C);
        if (H == 1)
            sb.append("H");
        else if (H > 1)
            sb.append("H" + H);
        if (N == 1)
            sb.append("N");
        else if (N > 1)
            sb.append("N" + N);
        if (S == 1)
            sb.append("S");
        else if (S > 1)
            sb.append("S" + S);
        if (P == 1)
            sb.append("P");
        else if (P > 1)
            sb.append("P" + P);
        if (O == 1)
            sb.append("O");
        else if (O > 1)
            sb.append("O" + O);
        if (Si == 1)
            sb.append("Si");
        else if (Si > 1)
            sb.append("Si" + Si);
        if (Li == 1)
            sb.append("Li");
        else if (Li > 1)
            sb.append("Li" + Li);
        if (Na == 1)
            sb.append("Na");
        else if (Na > 1)
            sb.append("Na" + Na);
        if (K == 1)
            sb.append("K");
        else if (K > 1)
            sb.append("K" + K);

        return sb.toString();
    }

    /**
     * ʑ̃CĨCIxԂ܂D
     * @return mAC\gsbN}Xɑ΂CIx
     * @param num nԖڂ̓ʑ̃CIw肷D
     */
    public double getIsotopeIntensity(int num)
    {
        double intensity = 0.0; // mAC\gsbN}Xɑ΂iԖڂ̃CIx

        // 23Na31P͓ʑ݂̂Ȃfor͕sKv
        for (int i_2H = 0; i_2H <= H && i_2H <= num; i_2H++) {
            int i_1H = H - i_2H;
            int num_H = i_2H;                             // ݂foȓg̓ʑ̌q̐
            double abund_H = Math.pow(ABUND_1H/100, i_1H) // ݂̑g̑ݔ䗦
                           * Math.pow(ABUND_2H/100, i_2H);
        for (int i_7Li = 0; i_7Li <= Li && num_H + i_7Li <= num; i_7Li++) {
            int i_6Li = Li - i_7Li;
            int num_Li = num_H + i_7Li;
            double abund_Li = abund_H * Math.pow(ABUND_6Li/100, i_6Li)
                                      * Math.pow(ABUND_7Li/100, i_7Li);
        for (int i_13C = 0; i_13C <= C && num_Li + i_13C <= num; i_13C++) {
            int i_12C = C - i_13C;
            int num_C = num_Li + i_13C;
            double abund_C = abund_Li * Math.pow(ABUND_12C/100, i_12C)
                                      * Math.pow(ABUND_13C/100, i_13C);
        for (int i_15N = 0; i_15N <= N && num_C + i_15N <= num; i_15N++) {
            int i_14N = N - i_15N;
            int num_N = num_C + i_15N;
            double abund_N = abund_C * Math.pow(ABUND_14N/100, i_14N)
                                     * Math.pow(ABUND_15N/100, i_15N);
        for (int i_18O = 0; i_18O <= O && num_N + i_18O*2 <= num; i_18O++)
        for (int i_17O = 0; i_17O <= O - i_18O && num_N + i_18O*2 + i_17O <= num; i_17O++) {
            int i_16O = O - i_18O - i_17O;
            int num_O = num_N + i_18O*2 + i_17O;
            double abund_O = abund_N * Math.pow(ABUND_16O/100, i_16O)
                                     * Math.pow(ABUND_17O/100, i_17O)
                                     * Math.pow(ABUND_18O/100, i_18O);
        for (int i_30Si = 0; i_30Si <= Si && num_O + i_30Si*2 <= num; i_30Si++)
        for (int i_29Si = 0; i_29Si <= Si - i_30Si && num_O + i_30Si*2 + i_29Si <= num; i_29Si++) {
            int i_28Si = Si - i_30Si - i_29Si;
            int num_Si = num_O + i_30Si*2 + i_29Si;
            double abund_Si = abund_O * Math.pow(ABUND_28Si/100,i_28Si)
                                      * Math.pow(ABUND_29Si/100,i_29Si)
                                      * Math.pow(ABUND_30Si/100,i_30Si);
        for (int i_36S = 0; i_36S <= S && num_Si + i_36S*4 <= num; i_36S++)
        for (int i_34S = 0; i_34S <= S - i_36S && num_Si + i_36S*4 + i_34S*2 <= num; i_34S++)
        for (int i_33S = 0; i_33S <= S - i_36S - i_34S && num_Si + i_36S*4 + i_34S*2 + i_33S <= num; i_33S++) {
            int i_32S = S - i_36S - i_34S - i_33S;
            int num_S = num_Si + i_36S*4 + i_34S*2 + i_33S;
            double abund_S = abund_Si * Math.pow(ABUND_32S/100, i_32S)
                                      * Math.pow(ABUND_33S/100, i_33S)
                                      * Math.pow(ABUND_34S/100, i_34S)
                                      * Math.pow(ABUND_36S/100, i_36S);
        for (int i_41K = 0; i_41K <= K && num_S + i_41K*2 <= num; i_41K++)
        for (int i_40K = 0; i_40K <= K - i_41K && num_S + i_41K*2 + i_40K <= num; i_40K++) {
            int i_39K = K - i_41K - i_40K;
            int num_K = num_S + i_41K*2 + i_40K;
            double abund_K = abund_S * Math.pow(ABUND_39K/100, i_39K)
                                     * Math.pow(ABUND_40K/100, i_40K)
                                     * Math.pow(ABUND_41K/100, i_41K);
            if (num_K == num)
            {
                int loop = permutation(H,  i_1H,   i_2H)  // ܂ޏ
                         * permutation(Li, i_6Li,  i_7Li) // n!/(p!*q!)́Cpermutation(n, p, q)
                         * permutation(C,  i_12C,  i_13C) // n!/(p!*q!*r!)́Cpermutation(n, p, q, r)
                         * permutation(N,  i_14N,  i_15N) // Ɠ͂D
                         * permutation(O,  i_16O,  i_17O,  i_18O)
                         * permutation(Si, i_28Si, i_29Si, i_30Si)
                         * permutation(S,  i_32S,  i_33S,  i_34S, i_36S)
                         * permutation(K,  i_39K,  i_40K,  i_41K);
                for (int i = 0; i < loop; i++)
                    intensity += abund_K;                 // ̑gݍ킹̐𑫂킹D
        }}}}}}}}}

        intensity /= Math.pow(ABUND_1H/100,   H)          // mAC\gsbN}Xɂ萳K
                   * Math.pow(ABUND_6Li/100,  Li)
                   * Math.pow(ABUND_12C/100,  C)
                   * Math.pow(ABUND_14N/100,  N)
                   * Math.pow(ABUND_16O/100,  O)
                   * Math.pow(ABUND_28Si/100, Si)
                   * Math.pow(ABUND_32S/100,  S)
                   * Math.pow(ABUND_39K/100,  K);

        return intensity;
    }

    /**
     * ܂ޏvZ܂D
     */
    private int permutation(int... n)
    {
        // n̂̂̂Ȃp̓́Aq̓́Ar̓̂Ƃ
        // n̂̂S1ɕׂ鏇̐
        // n!/(p!*q!*r!) n=p+q+r
        // F1, 1, 1, 2, 2, 36ׂ̐ėp6̐ƁAS
        // 6!/(3!*2!*1!)=60
        BigInteger permu = BigInteger.ONE;
        BigInteger bi = new BigInteger(new Integer(n[0]).toString());
        while (bi.compareTo(BigInteger.ONE) > 0) // KvZD
        {
            permu = permu.multiply(bi);
            bi = bi.subtract(BigInteger.ONE);
        }

        for (int i = 1; i < n.length; i++)       // q̊KŊĂD
        {
            bi = new BigInteger(new Integer(n[i]).toString());
            while (bi.compareTo(BigInteger.ONE) > 0)
            {
                permu = permu.divide(bi);
                bi = bi.subtract(BigInteger.ONE);
            }
        }

        return permu.intValue();
    }
}
