package jp.ac.ritsumei.is.infobio;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import org.jfree.chart.*;
import org.jfree.data.xy.*;
import org.jfree.chart.plot.*;
import org.jfree.ui.*;
import org.jfree.chart.entity.*;

/**
 * Cѓɂ闝_<I>m/z</I> vZNXłDiGUIŁj
 * @author m
 * @version 20090130
 */
public class MassCalcGUI extends JFrame implements ActionListener
{
    JTextField tf_comp;   // g͕
    JTextField tf_mass;   // m/zo͕
    JComboBox cb_monoavg; // mAC\gsbNʂ܂͕ώ
    JComboBox cb_adduct;  // tCI
    ChartPanel cpl;       // Ot\

    MassCalcGUI() throws Exception
    {
        super("Mass Calculator");
        this.setLayout(new BorderLayout());
        this.add(this.getIOPanel(), BorderLayout.NORTH);        // õ͕pl擾
        JFreeChart jc = ChartFactory.createXYLineChart ("", "m/z", "Intensity (%)",
                                                        null, PlotOrientation.VERTICAL,
                                                        true, true, true);
        cpl = new ChartPanel(jc);
        this.add(cpl, BorderLayout.CENTER);                     // ʑ̃CIxOt̃pl
        this.add(this.getConditionPanel(), BorderLayout.SOUTH); // vZ̃pl擾

        try // Swing̃fUCCWindows̃fUC֕ύXiLinux̏ꍇ͗OCSwing\ƂȂj
        {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel"); // Oςݒ
            SwingUtilities.updateComponentTreeUI(this);                                     // OϕύX
        }
        catch (Exception e)
        {
            System.err.println("Cannot use WindowsLookAndFeel: " + e);
        }

        this.pack();                                         // EBhETCY̎
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); // EChEꂽɏI
        this.setVisible(true);
    }

    /*
     * õ͕pl擾܂D
     */
    private JPanel getIOPanel()
    {
        JPanel pl = new JPanel();
        pl.setLayout(new BorderLayout());

        pl.add(new JLabel("Composition: "), BorderLayout.WEST);
        tf_comp = new JTextField(24);         // g͕
        tf_comp.setText("dc34:1, Hex*2, HexNAc*3");
        tf_comp.addActionListener(this);
        pl.add(tf_comp, BorderLayout.CENTER); // CENTERp邱ƂɂCEBhETCYɍ킹ĕ𒲐

        JPanel east = new JPanel();           // EASTɓ\tpl
        east.add(new JLabel("="));
        tf_mass = new JTextField(8);          // m/zo͕
        east.add(tf_mass);
        JButton jb = new JButton("Calculate");
        jb.addActionListener(this);
        east.add(jb);
        pl.add(east, BorderLayout.EAST);

        return pl;
    }

    /*
     * vZ̃pl擾܂D
     */
    private JPanel getConditionPanel()
    {
        JPanel pl = new JPanel();
        pl.setLayout(new GridLayout(1, 6));
        pl.add(new JLabel(""));
        //pl.add(new JLabel("(c) Kazuhito Yokoi"));
        pl.add(new JLabel(""));
        pl.add(new JLabel("Adduct ion: "));
        cb_adduct = new JComboBox(new String[]{"Na+","H+","Li+","K+","H-","M.W."});
        cb_adduct.addActionListener(this);
        pl.add(cb_adduct);
        pl.add(new JLabel("Mass mode: "));
        cb_monoavg = new JComboBox(new String[]{"Monoisotopic", "Average"});
        cb_monoavg.addActionListener(this);
        pl.add(cb_monoavg);
        return pl;
    }

    /*
     * w肳ꂽm/zvZďo͂܂D
     */
    public void actionPerformed(ActionEvent ae)
    {
        try // m/zvZ
        {
            Composition cp = new Composition(tf_comp.getText());

            // Iꂽʃ[h擾D
            boolean monoavg = ((String)cb_monoavg.getSelectedItem()).equals("Monoisotopic");

            // IꂽtCI擾D
            String temp = (String)cb_adduct.getSelectedItem();
            String adduct;
            if (temp.equals("Na+"))
                adduct = MassCalc.Na_ION;
            else if (temp.equals("H+"))
                adduct = MassCalc.H_ION;
            else if (temp.equals("Li+"))
                adduct = MassCalc.Li_ION;
            else if (temp.equals("K+"))
                adduct = MassCalc.K_ION;
            else if (temp.equals("H-"))
                adduct = MassCalc.H_NION;
            else if (temp.equals("M.W."))
                adduct = "";
            else
                throw new Exception(temp + " is unknown adduct ion.");

            tf_mass.setText(String.format("%.4f", cp.getMass(monoavg, adduct)));
            tf_comp.setText(cp.toString()); // ͂ꂽύX

            // ȍ~Cʑ̃CIx\
            MassCalc mc = new MassCalc(monoavg, adduct);
            
            double[] mass = new double[5];
            double[] intensity = new double[mass.length];
            for (int i = 0; i < mass.length; i++)
            {
                mass[i] = mc.getMass(cp) + i;
                intensity[i] = mc.getIsotopeIntensity(i);
            }

            IsotopeXYDataset xy = new IsotopeXYDataset(mass, intensity);
            JFreeChart jc = ChartFactory.createXYLineChart ("", "m/z", "Intensity (%)",
                                                            xy, PlotOrientation.VERTICAL,
                                                            true, true, true);
            cpl.setChart(jc);               // Ot\̃OtD
        }
        catch (Exception e)
        {
            tf_mass.setText("ERROR!");
            System.err.println(e);
        }
    }

    public static void main(String[] args) throws Exception
    {
        new MassCalcGUI();
    }
}
