package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * tOgCȊgƗ_<I>m/z</I> vZServletNXłD
 * @author m
 * @version 20090102
 */
public class FragmentationServlet extends HttpServlet
{
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        try
        {
            Glycan gc;                                           // J􂳂\
            String adduct = "";                                  // tCI
            boolean monoavg = true;                              // Monoisotopic(ture),Averaget(false)

            try
            {
                gc = new Glycan(request.getParameter("struct")); // w肳ȂꍇCO
            }
            catch (Exception e1)
            {
                try
                {
                    GlycanTools gi = new GlycanTools();          // Linucs`ȊǑ`ŎĂ݂D
                    gc = gi.readNormalFormat(request.getParameter("struct"));
                }
                catch (Exception e2)
                {
                    GlycanTools gi = new GlycanTools();          // SĂɂĎsꍇCL5\D
                    gc = gi.readNormalFormat("dc34:1-glc-man-glcnac-galnac-galnac");
                }
            }

            try
            {
                adduct = request.getParameter("adduct");

                if (adduct == null)                              // w肳ȂꍇC
                    adduct = MassCalc.Na_ION;                    // ̃CItCIƂD
            }
            catch (Exception e)
            {
                adduct = MassCalc.Na_ION;                        // ̃CItCIƂD
            }

            try
            {
                String temp = request.getParameter("monoavg");
                if (temp.equals("mono"))
                    monoavg = true;
                else if (temp.equals("avg"))
                    monoavg = false;
                else
                    monoavg = true;                              // ̑̏ꍇMonoisotopicƂD
            }
            catch (Exception e)
            {
                monoavg = true;                                  // ̑̏ꍇMonoisotopicƂD
            }

            out.println("<HTML><HEAD><TITLE>Fragmentation</TITLE></HEAD><BODY>"); // ͕
            out.println("<FONT SIZE=+2>Fragmentation</FONT><BR><BR>");
            out.println("<FORM>");

            try
            {
                String normal = gc.toNormalFormat();             // m[}`擾C
                if (normal.length() <= 60)                       // ͕̃TCY𒲐߂D
                    out.println("Structure: <INPUT TYPE=text NAME=struct VALUE='"
                               + normal + "' SIZE=90><BR>");
                else
                    out.println("Structure: <INPUT TYPE=text NAME=struct VALUE='"
                               + normal + "' SIZE=" + (normal.length() + 30) + "><BR>");
            }
            catch (Exception e)                                  // 3ȏ̏ꍇCLinucs`ŕ\
            {
                String linucs = gc.toString();                   // Linucs`擾C
                if (linucs.length() <= 60)                       // ͕̃TCY𒲐߂D
                    out.println("Structure: <INPUT TYPE=text NAME=struct VALUE='"
                               + linucs + "' SIZE=80><BR>");
                else
                    out.println("Structure: <INPUT TYPE=text NAME=struct VALUE='"
                               + linucs + "' SIZE=" + (linucs.length()+20) + "><BR>");
            }

            out.println("Adduct ion: <SELECT NAME=adduct>"+adduct); // O̓elƂD
            if (adduct.equals(MassCalc.Na_ION))
                out.println("<OPTION VALUE="+MassCalc.Na_ION+" SELECTED>Na+");
            else
                out.println("<OPTION VALUE="+MassCalc.Na_ION+">Na+");
            if (adduct.equals(MassCalc.H_ION))
                out.println("<OPTION VALUE="+MassCalc.H_ION+" SELECTED>H+");
            else
                out.println("<OPTION VALUE="+MassCalc.H_ION+">H+");
            if (adduct.equals(MassCalc.Li_ION))
                out.println("<OPTION VALUE="+MassCalc.Li_ION+" SELECTED>Li+");
            else
                out.println("<OPTION VALUE="+MassCalc.Li_ION+">Li+");
            if (adduct.equals(MassCalc.K_ION))
                out.println("<OPTION VALUE="+MassCalc.K_ION+" SELECTED>K+");
            else
                out.println("<OPTION VALUE="+MassCalc.K_ION+">K+");
            if (adduct.equals(MassCalc.H_NION))
                out.println("<OPTION VALUE="+MassCalc.H_NION+" SELECTED>H-");
            else
                out.println("<OPTION VALUE="+MassCalc.H_NION+">H-");
            if (adduct.equals(""))
                out.println("<OPTION VALUE='' SELECTED>no adduct");
            else
                out.println("<OPTION VALUE=''>No adduct");
            out.println("</SELECT><BR>");
            out.println("Mass mode: <SELECT NAME=monoavg>");
            if (monoavg)
            {
                out.println("<OPTION VALUE=mono SELECTED>Monoisotopic");
                out.println("<OPTION VALUE=avg>Average");
            }
            else
            {
                out.println("<OPTION VALUE=mono>Monoisotopic");
                out.println("<OPTION VALUE=avg SELECTED>Average");
            }
            out.println("</SELECT><BR>");
            out.println("<INPUT TYPE=submit>");
            out.println("</FORM><BR>");

            out.println("<B>Result</B><BR>");         // \
            out.println("LINUCS: " + gc + "<BR>");
            try
            {
                out.println("NORMAL: " + gc.toNormalFormat() + "<BR>");
            }
            catch (Exception e)
            {
                out.println("NORMAL: " + e + "<BR>"); // 3ȏ̏ꍇ
            }

            if (adduct.equals(MassCalc.Na_ION))
                out.println("Adduct ion: Na+<BR>");
            else if (adduct.equals(MassCalc.H_ION))
                out.println("Adduct ion: H+<BR>");
            else if (adduct.equals(MassCalc.Li_ION))
                out.println("Adduct ion: Li+<BR>");
            else if (adduct.equals(MassCalc.K_ION))
                out.println("Adduct ion: K+<BR>");
            else if (adduct.equals(MassCalc.H_NION))
                out.println("Adduct ion: H-<BR>");
            else if (adduct.equals(""))
                out.println("Adduct ion: No adduct<BR>");
            else
                out.println("Adduct ion: "+adduct+"<BR>");
            if (monoavg)
                out.println("Mass mode: Monoisotopic<BR><BR>");
            else
                out.println("Mass mode: Average<BR><BR>");
            out.println("<B>Fragment table</B><BR><TABLE border=1><TR>");
            out.println("<TH>Composition</TH>");
            out.println("<TH><I>m/z</I></TH>");
            out.println("</TR>");

            Fragmentation fg = new Fragmentation();
            Glycan temp = new Glycan(gc.toString());   // Hex֕ϊ邽߂ɃCX^X𐶐
            temp.toHexose();                           // Glc->Hex֕ϊ܂D
            fg.setGlycan(temp);

            int dehydrate = 0;                         // E܂񂾑g̐
            int oligo = 0;                             // t[̓̑g̐
            int ceramide = 0;                          // Z~h܂񂾑g̐

            for (Composition cp : fg.getComposition())
            {
                if (cp.hasCeramide())
                {
                    out.print("<TR bgcolor=#B0C4DE>"); // Z~h܂񂾑ǵCwiFɂD
                    ceramide++;
                }
                else if (cp.contains("-h2o"))
                {
                    out.print("<TR bgcolor=#DCDCDC>"); // E܂񂾑ǵCwiFDFɂD
                    dehydrate++;
                }
                else
                {
                    out.print("<TR bgcolor=#98FB98>"); // t[̓̑ǵCwiF΂ɂD
                    oligo++;
                }
                out.print("<TD>" + cp + "</TD>");
                out.print(String.format("<TD align=right>%.4f</TD>", cp.getMass(monoavg, adduct)));
                out.println("</TR>");
            }
            out.println("</TABLE><BR>");

            out.println("<B>Number of fragment</B><BR><TABLE border=1><TR>"); // tOg̓
            out.print("<TH bgcolor=#DCDCDC>Dehydrated<BR>oligosaccharide</TH>");
            out.print("<TH bgcolor=#98FB98>Oligosaccharide</TH>");
            if (ceramide != 0)                                                // ̑g0̏ꍇ́C\
                out.print("<TH bgcolor=#B0C4DE>Glycosphingolipid</TH>");
            out.print("<TH>Total</TH>");
            out.println("</TR>");
            out.print("<TR>");
            out.print("<TD bgcolor=#DCDCDC  align=center>" + dehydrate + "</TD>"); // E܂ޑǵCwiFDF
            out.print("<TD bgcolor=#98FB98  align=center>" + oligo + "</TD>");     // t[̓̑ǵCwiF
            if (ceramide != 0)                                                     // ̑g0̏ꍇ́C\
                out.print("<TD bgcolor=#B0C4DE  align=center>" + ceramide + "</TD>");   // ̑ǵCwiF
            out.print("<TD  align=center>" + (dehydrate + oligo + ceramide) + "</TD>"); // v
            out.println("</TR>");
            out.println("</TABLE><BR><BR>");
        }
        catch (Exception e)
        {
            out.println("ERROR:"+e.getMessage());
        }

        out.println("<Div Align=right><FONT color=gray>(c) Kazuhito Yokoi</FONT></Div><BR>");
        out.println("<A HREF=../>Back</A>");              // gbvy[Wւ̃N

        out.println("<script type=\"text/javascript\">");
        out.println("var gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");");
        out.println("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));");
        out.println("</script>");
        out.println("<script type=\"text/javascript\">");
        out.println("try {");
        out.println("var pageTracker = _gat._getTracker(\"UA-1643740-14\");");
        out.println("pageTracker._trackPageview();");
        out.println("} catch(err) {}</script>");
        out.println("</BODY></HTML>");                    // I^O
    }
}
