package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;

/**
 * \̃f[^NXłD
 * @author m
 * @version 20080514
 */
public class Glycan
{
    String node = "";                               // i[f[^
    String edge = "";                               // ̎
    ArrayList<Glycan> al = new ArrayList<Glycan>(); // qm[hi[郊Xg

    /**
     * RXgN^
     */
    public Glycan()
    {

    }

    /**
     * nꂽGlycanCX^X瓜\\z܂D
     * @param gc GlycanCX^X
     */
    public Glycan(Glycan gc) throws Exception
    {
        Glycan temp = new Glycan(gc.toString());
        this.setNode(temp.getNode()); // \o^D
        this.setEdge(temp.getEdge());
        this.setChildren(temp.getChildren());
    }

    /**
     * nꂽ񂩂瓜\\z܂D
     * @param str Linucs`ŕ\\i"th38:0-Glc(-Fuc)-GalNAc-GlcNAc-Rha"Ȃǂ͉\j
     */
    public Glycan(String str) throws Exception
    {
        str = str.replaceAll("\\s", "");                                    // 󔒕폜i\s͉s܂ށj
        str = str.toLowerCase();                                            // Sďɕϊ

        Pattern pt = Pattern.compile("^\\[(.*?)\\]\\[(.*?)\\]\\{(.*)\\}$"); // ߏƕӏ؂oCi[
        Matcher mt = pt.matcher(str);

        if (mt.matches())                                                   // ܂CLinucs`ō\͂D
        {
            edge = mt.group(1);                                             // 1ڂ[]̕
            node = mt.group(2);                                             // 2ڂ[]̕
            String child = mt.group(3);                                     // Ō{}̕

            for (int i = 0, j = 0; j <= child.length(); j++)
            {
                String temp = child.substring(i, j);

                if (isLinucs(temp))
                {
                    al.add(new Glycan(temp));
                    i = j;                                                  // ̍\ֈڍsD
                }
            }
        }
        else                                                                // Linucs`łȂꍇ
        {
            throw new Exception("Linucs format parse error : " + str);
        }
    }

    /**
     * Linucs`ł邩𔻒肵܂D
     * @param str Linucs`̕
     */
    private boolean isLinucs(String str)
    {
        String temp = "";

        for (int i = 0; i < str.split("\\{").length; i++)                   // q"{"̐ȉƂȂD
        {
            // "[^\\[\\]\\{\\}]"ɂC"[]{}"ȊOwD
            String regex = "\\[([^\\[\\]\\{\\}])*?\\]\\[([^\\[\\]\\{\\}])*?\\]\\{" + temp + "\\}";

            if (str.matches("^" + regex + "$"))
                return true;

            temp = "(" + regex + ")*?";
        }

        return false;
    }

    /**
     * o^ĂPύX܂D
     * @param node  ߏ̕
     */
    public void setNode(String node)
    {
        this.node = node;
    }

    /**
     * o^Ă錋ύX܂D
     * @param edge  ӏ̕
     */
    public void setEdge(String edge)
    {
        this.edge = edge;
    }

    /**
     * o^ĂPԂ܂D
     * @return  ߏ̕
     */
    public String getNode()
    {
        return node;
    }

    /**
     * Ԃ܂D
     * @return  ӏ̕
     */
    public String getEdge()
    {
        return edge;
    }

    /**
     * 񂪓o^Ă邩Ԃ܂D
     * @return ߏ񂪑݂邩
     */
    public boolean hasNode()
    {
        String temp = this.getNode();
        if (temp == null || temp.equals("") || temp.equals("0+0") || temp.equals("0-0"))
            return false;
        else
            return true;
    }

    /**
     * 񂪓o^Ă邩Ԃ܂D
     * @return ӏ񂪑݂邩
     */
    public boolean hasEdge()
    {
        String temp = this.getEdge();
        if (temp == null || temp.equals("") || temp.equals("0+0") || temp.equals("0-0"))
            return false;
        else
            return true;
    }

    /**
     * Z~h܂ł邩Ԃ܂D
     * @return Z~h܂ł邩
     */
    public boolean hasCeramide() throws Exception
    {
        if (this.getNode().matches("^([dt])([ch][0-9]+:[0-9])$")) // [gm[hɃZ~h݂ꍇ
            return true;
        else
        {
            boolean flag = false;                                 // returnptbO
            for (Glycan gc : this.getChildren())                  // qm[hȂ΁CɒTsD
                if (gc.hasCeramide())                             // qm[h1łZ~h݂ꍇC
                    flag = true;                                  // trueƂĕԂ߂ɁCem[hɓ`D
            return flag;
        }
    }

    /**
     * \Linucs`ŕԂ܂D
     * @return Linucs`̕
     */
    public String toString()
    {
        if (al.isEmpty())
            return Composition.toFixSignage("[" + getEdge() + "][" + getNode() + "]{}"); // \Lŏo
        else                                                      // qm[hꍇCċAD
        {
            Iterator it = al.iterator();
            String temp = "";

            while (it.hasNext())                                  // "{}"̕q킹D
                temp = temp + ((Glycan)it.next()).toString();

            return Composition.toFixSignage("[" + getEdge() + "][" + getNode() + "]{" + temp + "}"); // \Lŏo
        }
    }

    /**
     * ؍\`\ŕԂ\bh
     * @return ؍\"th38:0-Glc(-Fuc)-GalNAc-GlcNAc-Rha"̐`\ŕԂD
     */
    public String toNormalFormat() throws Exception
    {
        GlycanTools gi = new GlycanTools();
        return Composition.toFixSignage(gi.toNormalFormat(this)); // \Lŏo
    }

    /**
     * ؍\ɂ錻݂̗vftł邩Ԃ܂D
     * @return tł邩ԂD
     */
    public boolean isLeaf()
    {
        return al.isEmpty();
    }

    /**
     * tȊOɎw肵vf݂ȂԂ܂D
     * @return ݂ȂԂD
     */
    public boolean containsOnlyLeaf(String str) throws Exception  // [݂̂FucMe݂\true
    {
        boolean flag = true;

        for (Glycan gc : this.getChildren())    // qm[hȂ΁CɒTsD
            if (!gc.isLeaf() && gc.getNode().equals(str))
                return false;
            else if (!gc.containsOnlyLeaf(str)) // ċA
                flag = false;                   // ċA1łfalseԂꂽCċÅ֐falseԂD

        return flag;                            // ċAŗtȊOɎw肵vf݂ȂꍇԂD
    }

    /**
     * Glc,Gal,ManHexցCGlcNAc,GalNAcHexNAc֕ϊ܂D
     */
    public void toHexose()
    {
        node = node.replaceAll("glc|man|gal", "hex");   // Hex֕ϊ
        node = node.replaceAll("lfuc|fuc|rha", "dhex"); // dHex֕ϊ
        node = node.replaceAll("xyl|ara", "pen");       // pen֕ϊ

        for (Glycan gc : this.getChildren())            // qm[hȂ΁CɒTsD
            gc.toHexose();
    }

    /**
     * qm[hԂ܂D
     * @return qm[h
     */
    public List<Glycan> getChildren()
    {
        return al;
    }

    /**
     * qm[h܂D
     * @param li qm[h
     */
    public void setChildren(List<Glycan> li)
    {
        al.clear();    // qm[h폜
        al.addAll(li); // ̎qm[hǉ
    }

    /**
     * P̐Ԃ܂D
     * @return \̃m[h
     */
    public int size() throws Exception
    {
        int sum = 1;                         // ċAɂĈPsum։ZĂD
        for (Glycan gc : this.getChildren()) // qm[hȂ΁CɒTsD
            sum += gc.size();                // ċA

        return sum;
    }

    /**
     * \̗tm[hԂ܂D
     * @return \̗tm[h
     */
    public int countLeaf()
    {
        int sum = 0;                         // ċAɂCsum։ZĂD

        if (this.isLeaf())
            sum++;

        for (Glycan gc : this.getChildren()) // qm[hȂ΁CɒTsD
            sum += gc.countLeaf();           // ċA

        return sum;
    }

    /**
     * _<I>m/z</I> Ԃ܂D
     * @param monoisotopic mAC\gsbNAx[WMassCalc.MONO_MASSŎw
     * @param adduct tCIMassCalc.Na_IONŎw
     * @return _<I>m/z</I>
     */
    public double getMass(boolean monoisotopic, String adduct) throws Exception
    {
        MassCalc mc = new MassCalc(monoisotopic, adduct);
        return mc.getMass(this);
    }

    /**
     * \Ɏw肵񂪑݂邩Ԃ܂D
     * @param str 
     * @return \ɕ񂪑݂邩
     */
    public boolean contains(String str) throws Exception
    {
        Composition cp = new Composition(this); // g쐬
        return cp.contains(str);
    }

    /**
     * \ɑ΂Aɍč\zs܂D
     */
    public void reconstruct()
    {
        ArrayList<Glycan> al = new ArrayList<Glycan>(); // qm[hi[郊Xgiɏ邽߁j

        for (Glycan gc : this.getChildren())            // qm[hȂ΁CɒTsD
        {
            al.add(gc);                                 // ɏ邽߂ɕۑD
            gc.reconstruct();                           // ċA
        }

        Collections.sort(al, new Comparator<Glycan>()   // TAɎɃ\[gCm[h̏ԂD
        {
            public int compare(Glycan gc1, Glycan gc2)
            {
                return gc1.toString().compareTo(gc2.toString());
            }
        });

        this.setChildren(al);                           // al̓eɏD
    }

    /**
     * ̃NXRNV֊i[ł悤equals\bhI[o[Ch܂D
     * @param gc rΏۂƂȂGlycanNX
     * @return ꂼLinucs`֕ϊCString^ɂrʂԂD
     */
    public boolean equals(Object gc) // I[o[ChȂ̂ň̌^ObjectłȂĂ͂ȂȂD
    {
        try
        {
            Glycan temp1 = new Glycan(this.toString());         // GlycanCX^XRs[D
            Glycan temp2 = new Glycan(((Glycan)gc).toString()); // jvm1.5ȉł̓IuWFNǧ^ϊKvD
            temp1.reconstruct();                                // ꂼ̃m[hɕѕςC
            temp2.reconstruct();                                // rsD

            return temp1.toString().equals(temp2.toString());
        }
        catch (Exception e)
        {
            System.out.println("Exception at Glycan.equals(Glycan.java) " + e); // OC
            return false;                                                       // \łĂfalseԂD
        }
    }

    /**
     * ̃NXRNV֊i[ł悤hashCode\bhI[o[Ch܂D
     * @return ꂼLinucs`֕ϊCString^ɂhashCode\bh̒lԂD
     */
    public int hashCode()
    {
        try
        {
            Glycan temp = new Glycan(this.toString()); // GlycanCX^XRs[D
            temp.reconstruct();                        // m[hɕѕςChashCode()sD
            return temp.toString().hashCode();
        }
        catch (Exception e)
        {
            System.out.println("Exception at Glycan.hashCode(Glycan.java)");
            return 0;                                  // OC0ԂD
        }
    }

    /**
     * tOgGlycanƂĕԂ܂D
     * @return GlycanSet
     */
    public List<Glycan> getGlycanFragment() throws Exception
    {
        Fragmentation fg = new Fragmentation();
        fg.setGlycan(new Glycan(this.toString()));
        return fg.getGlycan();
    }

    /**
     * tOgCompositionƂĕԂ܂D
     * @return CompositionSet
     */
    public List<Composition> getCompositionFragment() throws Exception
    {
        Fragmentation fg = new Fragmentation();
        fg.setGlycan(new Glycan(this.toString()));
        return fg.getComposition();
    }

    /**
     * qm[hƂGlycanǉ܂D
     * @param gc ǉGlycanNX
     */
    public void addChild(Glycan gc)
    {
        al.add(gc);
    }

    /**
     * w肵qm[h폜܂D
     * @param gc 폜GlycanNX
     */
    public boolean removeChild(Glycan gc)
    {
        return al.remove(gc);                  // trueԂD
    }

    /**
     * S`s܂D
     */
    public void methylation() throws Exception // Ҍ[̏ꍇC
    {                                          // Ҍ[Ƀ`邱Ƃl邽߂Ɋ֐2d
        this.methylation(false);               // em[h݂Ȃ(=false)ƂĎsD
    }

    /**
     * S`s܂D
     * @parm flag em[h݂邩
     */
    private void methylation(boolean flag) throws Exception
    {
        Pattern pt1 = Pattern.compile("^(xyl|ara|pen|dhex|fuc|rha|hex|glc|gal|man|hexnac|glcnac|galnac|hexa|kdn|neuac|neugc)([0-9]*)((me)?)$");
        Matcher mt1 = pt1.matcher(node); // AZ`ɂ͖Ή
        Pattern pt2 = Pattern.compile("^([dt])([ch])([0-9]+):([0-9])$");
        Matcher mt2 = pt2.matcher(node);

        if (mt1.matches())                                     // ̃`
        {
            int count = 0;                                     // `
            if (mt1.group(1).matches("^(xyl|ara|pen)$"))       // yg[X̏ꍇ́C
                count = 3 - this.getChildren().size();         // C̕tł镔͍ő3
            else if (mt1.group(1).matches("^(dhex|fuc|rha)$")) // fILVwL\[X̏ꍇ́C
                count = 3 - this.getChildren().size();         // C̕tł镔͍ő3
            else if (mt1.group(1).matches("^(hex|glc|gal|man|hexnac|glcnac|galnac|hexa)$")) // ̑̏ꍇ́C
                count = 4 - this.getChildren().size();                                      // ő4
            else if (mt1.group(1).matches("^(neuac|kdn)$"))    // NeuAc,KDŃCő6
                count = 6 - this.getChildren().size();
            else if (mt1.group(1).matches("^(neugc)$"))        // NeuGćCNeuAc炳OH1߁Cő7
                count = 7 - this.getChildren().size();
            else
                throw new Exception("Regular expression error in above program: + " + mt1.group(1));

            if (!flag)                                         // em[h݂Ȃ͊Ҍ[Ƀ`D
                count++;

            node = mt1.group(1) + count + "me";
        }
        else if (mt2.matches())                                // Z~h̃`(Nɂ`)
        {
            int count = Integer.parseInt(mt2.group(3));        // Z~h̒Yfi[
            if (mt2.group(1).equals("d"))                      // WqhLVXtBSV̏ꍇC
                count += 2;                                    // `2iYf2j
            else if (mt2.group(1).equals("t"))                 // gqhLVXtBSV̏ꍇC
                count += 3;                                    // `3iYf3j

            if (mt2.group(2).equals("h"))                      // qhLVb_̏ꍇC
                count++;                                       // `1iYf1j

            node = mt2.group(1) + mt2.group(2) + count + ":" + mt2.group(4);
        }
        else                                                   // K\ƈvȂꍇ
            throw new Exception("Unknown Composition: " + node);

        for (Glycan gc : this.getChildren())                   // qm[hɂĂ`sD
            gc.methylation(true);                              // em[h݂(=true)ƂčċAD
    }


    /**
     * w肵\L\ł邩Ԃ܂D
     * @param gc ΏۂƂ铜\
     * @return L\ł邩ԂD
     */
    public boolean contains(Glycan gc) throws Exception
    {
        if (gc == null) // null̏ꍇfalse
            return false;

        if (this.getNode().equals(gc.getNode()))             // m[hvꍇ
        {
            ArrayList<Glycan> al1 = new ArrayList<Glycan>(); // qm[h폜邽߁C
            ArrayList<Glycan> al2 = new ArrayList<Glycan>(); // ArrayList<Glycan>pӁD
            for (Glycan gc1 : this.getChildren())
                al1.add(gc1);                                // ꂼ̎qm[hi[D
            for (Glycan gc2 : gc.getChildren())
                al2.add(gc2);

            if (al1.size() == 0 && al2.size() == 0) // m[hvĂCƂɎqm[hȂꍇ
                return true;                        // ȉif(!flag)ɂflaseƂȂ邽߁CtrueԂĂD
            else if (al1.size() >= al2.size())      // łGlycan̎qm[h̕ꍇCꍇ
            {
                for (Glycan temp : al2)             // Glycan̎qm[h𒲂ׂD
                {
                    Iterator<Glycan> it1 = al1.iterator();
                    boolean flag = false;           // łGlycan̎qm[h̗vfSĎĂȂꍇfalse
                    while (it1.hasNext() && !flag)  // ]ɍ폜̂邽߁C!flagpD
                        if (temp.contains(it1.next()))
                        {
                            flag = true;            // vvfPCEQȏ̏ꍇC
                            it1.remove();           // ԈĔ肳̂ō폜ĂD
                        }
                    if (!flag)
                        return false;               // łGlycan̎qm[h̗vfSĎĂȂꍇfalse
                }
                return true;                        // flaseԂꂸ̍s֗̂true
            }
            else
                return false;                       // łGlycan̎qm[h̕傫ꍇfalse
        }
        else
            return false;                           // m[hvȂꍇfalse
    }
}
