package jp.ac.ritsumei.is.infobio;
import java.io.*;
import java.util.*;
import java.awt.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * 2̃XyNgrServletNXłD
 * @author m
 * @version 20090102
 */
public class SpctrumAlignment extends HttpServlet
{
    /*
     * T[ubg\\bhłD
     * @parm request HttpServletRequest
     * @parm response HttpServletResponse
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        double[] sp1;
        double[] sp2;
        double tolerance;
        double[][] matrix;           // m/z̃}gbNX
        boolean[][] flag;            // qʍ݂鎞truei[
        double max = 0.0, min = 0.0; // F̕\͈͂߂邽߂ɓqʍ̂̍őŏli[
        String[][] color;            // }gbNX̕\Fi[

        try
        {
            String[] strs = request.getParameter("sp1").split("[^\\.\\d]"); // '.'ƐȊO̕Ő؂oD
            java.util.List<Double> massli = new ArrayList<Double>();        // ϒzpӂD

            for (String str : strs)
            {
                try
                {
                    massli.add(Double.parseDouble(str));
                }
                catch (Exception e)                // ȊO̕Ăꍇ̎CƂ
                {
                    System.err.println(e);
                }
            }
            sp1 = new double[massli.size()];       // ListƓ傫̔zpӂD

            Iterator<Double> massit = massli.iterator();
            for (int i = 0; massit.hasNext(); i++) // double[]^sp1֔ž^ϊ
                sp1[i] = massit.next();
        }
        catch (Exception e)
        {
            double[] temp = {568.1277, 656.0609, 672.0352, 1038.3757, 1056.3867, 1056.9378, 1057.3902,
                             1072.358, 1073.3609, 1259.4545, 1368.6981, 1637.8142}; // 5HexNAcl
            sp1 = temp;                            // 2iKŏȂƃG[ƂȂD
        }

        try
        {
            String[] strs = request.getParameter("sp2").split("[^\\.\\d]"); // '.'ƐȊO̕Ő؂oD
            java.util.List<Double> massli = new ArrayList<Double>();        // ϒzpӂD

            for (String str : strs)
            {
                try
                {
                    massli.add(Double.parseDouble(str));
                }
                catch (Exception e)                // ȊO̕Ăꍇ̎CƂ
                {
                    System.err.println(e);
                }
            }
            sp2 = new double[massli.size()];       // ListƓ傫̔zpӂD

            Iterator<Double> massit = massli.iterator();
            for (int i = 0; massit.hasNext(); i++) // double[]^sp1֔ž^ϊ
                sp2[i] = massit.next();
        }
        catch (Exception e)
        {
            double[] temp = {568.1277, 656.0609, 672.0352, 1038.3757, 1056.3867, 1056.9378, 1057.3902,
                             1072.358, 1073.3609, 1259.4545, 1368.6981, 1637.8142}; // 5HexNAcl
            sp2 = temp;                            // 2iKŏȂƃG[ƂȂD
        }

        try
        {
            tolerance = Double.parseDouble(request.getParameter("tolerance"));    // w肳ȂꍇCO
        }
        catch (Exception e)
        {
            tolerance = 1.0;                                                      // e덷w
        }

        Arrays.sort(sp1);                                                         // ёւsD
        Arrays.sort(sp2);

        out.println("<HTML><HEAD><TITLE>Spctrum Alignment</TITLE></HEAD><BODY>"); // ͕
        out.println("<FONT SIZE=+2>Spctrum Alignment</FONT><BR>");
        out.println("<FORM>");
        out.println("<BR>");
        out.println("Spctrum1: <TEXTAREA name=sp1 rows=20>");
        for (double value : sp1)
            out.println(value);
        out.println("</TEXTAREA>");
        out.println("Spctrum2: <TEXTAREA name=sp2 rows=20>");
        for (double value : sp2)
            out.println(value);
        out.println("</TEXTAREA><BR><BR>");
        out.println("Mass tolerance (Da): <INPUT type=text name=tolerance value=" + tolerance + ">");
        out.println("<INPUT type=submit>");
        out.println("</FORM><BR>");

        matrix = new double[sp1.length][sp2.length];                         // qʍ̃}gbNX
        for (int i = 0; i < sp1.length; i++)                                 // SĂ̑gɂĕqʂ̍vZ
            for (int j = 0; j < sp2.length; j++)
                matrix[i][j] = sp1[i] - sp2[j];

        flag = new boolean[sp1.length][sp2.length];                          // qʍ݂鎞truei[
        for (int i = 0; i < sp1.length-1; i++)                               // qʍ݂邩vZ
            for (int j = 0; j < sp2.length-1; j++)
                for (int k = i+1; k < sp1.length; k++)
                    for (int l = j+1; l < sp2.length; l++)
                        if (Math.abs(matrix[i][j]-matrix[k][l]) < tolerance) // e덷ȉ̏ꍇ
                        {
                            flag[i][j] = true; flag[k][l] = true;            // tureƂD
                        }

        for (int i = 0; i < sp1.length-1; i++)                               // qʍ̍őŏlvZ
            for (int j = 0; j < sp2.length-1; j++)
            {
                if (max < matrix[i][j] && flag[i][j])
                    max = matrix[i][j];

                if (min > matrix[i][j] && flag[i][j])
                    min = matrix[i][j];
            }

        color = new String[sp1.length][sp2.length];                          // }gbNX̕\Fi[
        for (int i = 0; i < sp1.length; i++)                                 // }gbNX̕\FvZ
        {
            for (int j = 0; j < sp2.length; j++)
            {
                int r, g, b;                                                 // F

                if (flag[i][j])                                              // qʍ݂鎞
                {

                    double hue = 0.9 * (matrix[i][j] - min) / (max - min);   // 0.0`0.9͈̔͂悤ɕϊ
                    Color cl = Color.getHSBColor((float)hue, (float)1.0, (float)1.0); // HSBJ[fgp
                    r = cl.getRed();                                         // 0.0()`0.9(sN)̐F𗘗pC
                    g = cl.getGreen();                                       // ʓxƖx͍ől1.0
                    b = cl.getBlue();
                }
                else
                {
                    r = 255; g = 255; b = 255;                               // F
                }
                color[i][j] = "#" + Integer.toHexString(r)
                                  + Integer.toHexString(g)
                                  + Integer.toHexString(b);                  // Fi[
            }
        }

        out.println("<B>Result</B><BR>rows=Spctrum1, cols=Spctrum2<BR>");    // o
        out.println("<TABLE border=1>");
        out.print("</TR><TD></TD>");                                         // \1s
        for (int j = 0; j < sp2.length; j++)
            out.print("<TH><A HREF=../composition?mass_a=" + sp2[j]
                    + "&tolerance=" + tolerance + ">"
                    + String.format("%.1f",sp2[j]) + "<A></TH>");            // <TH>͌o
        out.println("</TR>");

        for (int i = 0; i < sp1.length; i++)                                 // \2sڈȍ~
        {
            out.print("<TH><A HREF=../composition?mass_a=" + sp1[i]
                    + "&tolerance=" + tolerance + ">"
                    + String.format("%.1f",sp1[i]) + "<A></TH>");            // <TH>͌o
            for (int j = 0; j < sp2.length; j++)
            {
                if (146.06 - tolerance < Math.abs(matrix[i][j])
                 && Math.abs(matrix[i][j]) < 146.06 + tolerance)      // dHex
                    out.print("<TD bgcolor="+ color[i][j] +" align=center>"
                            + String.format("%.1f", matrix[i][j]) + "<BR>(dHex)</TD>");
                else if (160.07 - tolerance < Math.abs(matrix[i][j])
                      && Math.abs(matrix[i][j]) < 160.07 + tolerance) // dHexMe
                    out.print("<TD bgcolor="+ color[i][j] +" align=center>"
                            + String.format("%.1f", matrix[i][j]) + "<BR>(dHexMe)</TD>");
                else if (162.05 - tolerance < Math.abs(matrix[i][j])
                      && Math.abs(matrix[i][j]) < 162.05 + tolerance) // Hex
                    out.print("<TD bgcolor="+ color[i][j] +" align=center>"
                            + String.format("%.1f", matrix[i][j]) + "<BR>(Hex)</TD>");
                else if (203.08 - tolerance < Math.abs(matrix[i][j])
                      && Math.abs(matrix[i][j]) < 203.08 + tolerance) // HexNAc
                    out.print("<TD bgcolor="+ color[i][j] +" align=center>"
                            + String.format("%.1f", matrix[i][j]) + "<BR>(HexNAc)</TD>");
                else if (18.01 - tolerance < Math.abs(matrix[i][j])
                      && Math.abs(matrix[i][j]) < 18.01 + tolerance)  // H2Ȍꍇ͎Α̂ɂD
                    out.print("<TD bgcolor="+ color[i][j] +" align=center><I>"
                            + String.format("%.1f", matrix[i][j]) + "</I></TD>");
                else if (Math.abs(matrix[i][j]) % 14.02 < tolerance)  // CH2̒̈Ⴂ̏ꍇ͑ɂD
                    out.print("<TD bgcolor="+ color[i][j] +" align=center><B>"
                            + String.format("%.1f", matrix[i][j]) + "</B></TD>");
                else
                    out.print("<TD bgcolor="+ color[i][j] +" align=center>"
                            + String.format("%.1f", matrix[i][j]) + "</TD>");
            }
            out.println("</TR>");
        }
        out.println("</TABLE><BR>");

        out.println("<Div Align=right><FONT color=gray>(c) Kazuhito Yokoi</FONT></Div><BR>");
        out.println("<A HREF=../>Back</A>"); // gbvy[Wւ̃N

        out.println("<script type=\"text/javascript\">");
        out.println("var gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");");
        out.println("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));");
        out.println("</script>");
        out.println("<script type=\"text/javascript\">");
        out.println("try {");
        out.println("var pageTracker = _gat._getTracker(\"UA-1643740-14\");");
        out.println("pageTracker._trackPageview();");
        out.println("} catch(err) {}</script>");
        out.println("</BODY></HTML>"); // I^O
    }
}
