package jp.ac.ritsumei.is.infobio;
import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.util.regex.*;
import org.jfree.chart.*;
import org.jfree.data.xy.*;
import org.jfree.chart.plot.*;
import org.jfree.ui.*;
import org.jfree.chart.entity.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * tOgCIɂ闝_<I>m/z</I> ƎXyNgdˍ킹NXłD
 * @author m
 * @version 20090102
 */
public class FragmentationGUI implements ActionListener, ItemListener, WindowListener
{
    XYSeries xs;                             // l̃XyNgi[
    XYSeriesCollection xc;
    JFreeChart jc;
    JTextField inpit_tf;                     // \i[
    JComboBox ion_ch;                        // tCIi[
    JComboBox ma_ch;                         // MONO/AVGi[
    JButton theory_bt;                       // Calculate{^
    JButton actual_bt;                       // lǂݍ݃{^(Plot data{^)

    String[] title = {"m/z", "Composition"}; // fЉ̑g̏o͕
    DefaultTableModel tm = new DefaultTableModel(title, 0);
    JTable theory_tb = new JTable(tm);       // PSDf[^i[

    TextArea actual_ta;                      // li[

    FragmentationGUI()                       // t[̕\
    {
        byte[] bytes = {40, 99, 41, 32, 75, 97, 122, 117, 104, 105, 116, 111, 32, 89, 111, 107, 111, 105};

        JFrame fr = new JFrame("Fragment Matcher");
        xc = new XYSeriesCollection();       // Ot̐ݒ
        jc = ChartFactory.createXYBarChart("", "m/z", false, "Intensity (%)", xc, PlotOrientation.VERTICAL,
                                           false, false, false);
        // \͕
        inpit_tf = new JTextField("dc34:1-Glc-Man-GlcNAc-GalNAc-GalNAc-Gal-GlcNAc", 40);
        inpit_tf.addActionListener(this);
        JPanel input_pn = new JPanel();
        input_pn.setLayout(new FlowLayout());
        input_pn.add(new JLabel("Structure:"));
        input_pn.add(inpit_tf);

        // tCII
        ion_ch = new JComboBox(new String[] {"Na+",
                                             "H+",
                                             "Li+",
                                             "K+",
                                             "H-",
                                             "No adduct"});
        ion_ch.addItemListener(this);

        JPanel ion_pn = new JPanel();
        ion_pn.setLayout(new FlowLayout());
        ion_pn.add(new JLabel("Adduct ion:"));
        ion_pn.add(ion_ch);

        // MONO/AVGI
        ma_ch = new JComboBox(new String[] {"Monoisotopic", "Average"});
        ma_ch.addItemListener(this);
        JPanel ma_pn = new JPanel();
        ma_pn.setLayout(new FlowLayout());
        ma_pn.add(new JLabel("Mass mode: "));
        ma_pn.add(ma_ch);

        // tOgvZ{^
        theory_bt = new JButton("Calculate");
        theory_bt.addActionListener(this);

        // ݒ蕔
        JPanel condi_pn = new JPanel();
        condi_pn.setLayout(new FlowLayout());
        condi_pn.add(input_pn);
        condi_pn.add(ion_pn);
        condi_pn.add(ma_pn);
        condi_pn.add(theory_bt);

        // _s[No͕
        JPanel  theory_pn_north = new JPanel();
        theory_pn_north.setLayout(new BorderLayout());
        theory_pn_north.add(new JLabel("Calculated fragments:"), BorderLayout.WEST);

        JPanel theory_pn = new JPanel();
        theory_pn.setLayout(new BorderLayout());
        theory_pn.add(theory_pn_north, BorderLayout.NORTH);
        resetTableColumnSize(); // e[ũJ𒲐

        // gɏ]ăZɐFtDiZ~htcĈ݁c΁CEcDFj
        TableColumn tc = theory_tb.getColumnModel().getColumn(0);
        tc.setCellRenderer(new DefaultTableCellRenderer()
        {

        });

        JScrollPane theory_sp = new JScrollPane(theory_tb); // JTableփXN[o[D
        theory_sp.addMouseListener(new MouseListener()      // \ENbNƈD
        {
            public void mouseExited(MouseEvent me){}
            public void mouseEntered(MouseEvent me){}
            public void mousePressed(MouseEvent me){}
            public void mouseReleased(MouseEvent me){}
            public void mouseClicked(MouseEvent me)
            {
                if (me.getButton() == MouseEvent.BUTTON3)   // ENbN
                {
                    try
                    {
                        theory_tb.print();                  // _CAO\
                    }
                    catch (Exception e)
                    {
                        System.out.println("Cannot print: " + e);
                    }
                }
            }
        });
        theory_pn.add(theory_sp, BorderLayout.CENTER);

       
        actual_bt = new JButton("Plot data");               // s[N͕
        actual_bt.addActionListener(this);

        try                                                 // f[^̓ǂݍ
        {
            File fi = new File("L7.dat");
            FileReader rd = new FileReader(fi);
            BufferedReader br = new BufferedReader(rd);
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null)
                sb.append(line + "\n");
            actual_ta = new TextArea(sb.toString());
        }
        catch (Exception e)
        {
            System.err.println(e);
            actual_ta = new TextArea("Index	Centroid Mass	Lower Bound	Upper Bound	Charge (z)	Height	Relative Intensity	Area\n"
                                    + "1	226.086656	214.70	239.20	0	114	10.96	34568.98\n"
                                    + "2	387.921207	386.08	389.29	0	213	20.48	14047.02\n"
                                    + "3	405.818468	404.62	406.39	0	498	47.84	15389.71\n"
                                    + "4	428.798146	427.14	429.52	0	721	69.26	36846.05\n"
                                    + "5	429.659166	429.52	430.33	0	227	21.78	4598.69\n"
                                    + "6	591.182879	589.05	594.66	0	168	16.15	10405.74\n"
                                    + "7	631.871619	629.39	632.56	0	172	16.57	6567.95\n"
                                    + "8	667.634938	645.90	695.00	0	35	3.40	3256.74\n"
                                    + "9	723.822798	697.10	752.20	0	125	12.03	13931.21\n"
                                    + "10	794.294571	791.94	794.56	0	376	36.11	9785.54\n"
                                    + "11	866.510011	852.50	875.70	0	31	2.96	2429.69\n"
                                    + "12	888.507352	866.70	917.90	0	109	10.45	13012.58\n"
                                    + "13	953.956244	926.00	971.00	0	98	9.42	8019.90\n"
                                    + "14	996.455212	993.22	997.08	1	908	87.21	25463.38\n"
                                    + "15	1087.733154	1086.34	1088.26	0	161	15.49	3065.23\n"
                                    + "16	1159.078169	1157.70	1159.41	0	556	53.40	8082.03\n"
                                    + "17	1161.051801	1160.86	1163.34	0	224	21.56	4189.52\n"
                                    + "18	1177.134560	1167.00	1193.70	0	39	3.71	3051.84\n"
                                    + "19	1236.261198	1214.10	1261.10	0	35	3.37	3128.91\n"
                                    + "20	1290.025315	1288.32	1290.50	0	294	28.26	4952.25\n"
                                    + "21	1323.832952	1314.20	1337.40	0	63	6.03	3641.91\n"
                                    + "22	1333.465729	1308.20	1371.40	0	126	12.12	14288.28\n"
                                    + "23	1473.616981	1457.30	1485.90	0	46	4.38	4034.31\n"
                                    + "24	1493.937713	1492.41	1494.44	0	422	40.60	5174.78\n"
                                    + "25	1513.374222	1500.30	1533.00	0	75	7.21	9087.53\n"
                                    + "26	1859.320454	1858.70	1859.85	1	1041	100.00	6482.10\n"
                                    + "27	1877.614229	1870.20	1893.40	0	153	14.70	6686.62");
        }

        JPanel actual_pn = new JPanel();
        actual_pn.setLayout(new BorderLayout());
        actual_pn.add(new JLabel("Measured data:"), BorderLayout.WEST);
        actual_pn.add(actual_bt, BorderLayout.EAST);
        actual_pn.add(actual_ta, BorderLayout.SOUTH);

       
        JPanel south_pn = new JPanel(); // SOUTH̐ݒ
        south_pn.setLayout(new BorderLayout());
        south_pn.add(new ChartPanel(jc), BorderLayout.CENTER);
        south_pn.add(actual_pn, BorderLayout.SOUTH);

        fr.add(condi_pn, BorderLayout.NORTH);
        fr.add(theory_pn, BorderLayout.WEST);
        fr.add(south_pn, BorderLayout.CENTER);
        JLabel author = new JLabel(new String(bytes));
        author.setForeground(Color.gray);
        fr.add(author, BorderLayout.SOUTH);
        fr.addWindowListener(this);
        fr.pack();
        //jf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); // EChEꂽɏI

        try // Swing̃fUCCWindows̃fUC֕ύXiLinux̏ꍇ͗OCSwing\ƂȂj
        {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel"); // Oςݒ
            SwingUtilities.updateComponentTreeUI(fr);                                       // OϕύX
        }
        catch (Exception e)
        {
            System.err.println("Cannot use WindowsLookAndFeel: " + e);
        }

        int width = fr.getWidth() / 3;                           // \̃TCY1/3̃TCYƂD
        theory_pn.setPreferredSize(new Dimension(width, width));

        fr.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae)
    {
        if (ae.getSource() == actual_bt) // "Plot peaks"{^NbNꂽ
        {
            xc.removeAllSeries();        // OXYSeries폜
            xs = new XYSeries("");

            double temp = 0.0;
            BufferedReader br = new BufferedReader(new StringReader(actual_ta.getText()));
            boolean flag = true;         // BarChartLineChartw肷D(trueBarChart)
            try
            {
                String str;
                while ((str = br.readLine()) != null)
                {
                    Pattern pt1 = Pattern.compile("^(\\d+)[\\t|\\s]+(\\d+\\.\\d+)[\\t|\\s]+"
                                                 + "(\\d+\\.\\d+)[\\t|\\s]+(\\d+\\.\\d+)[\\t|\\s]+"
                                                 + "(\\d+)[\\t|\\s]+(\\d+)[\\t|\\s]+"
                                                 + "(\\d+\\.\\d+)[\\t|\\s]+(\\d+\\.\\d+).*");
                    Matcher mt1 = pt1.matcher(str);

                    if (mt1.matches()) // 擪̏ǂݔ΂C
                    {                  // C'.'C^uō\ĂsǂݍށD
                        xs.add(Double.parseDouble(mt1.group(2)), Double.parseDouble(mt1.group(7)));
                        flag = true;   // BarChartŕ\
                    }

                    Pattern pt2 = Pattern.compile("^(\\d+\\.\\d+)[\\t|\\s]+(\\d+\\.\\d+).*");
                    Matcher mt2 = pt2.matcher(str);

                    if (mt2.matches()) // 擪̏ǂݔ΂C
                    {                  // C'.'C^uō\ĂsǂݍށD
                         xs.add(Double.parseDouble(mt2.group(1)), Double.parseDouble(mt2.group(2)));
                         flag = false; // LineChartŕ\
                    }
                }
            }
            catch (Exception e)
            {
                System.err.println("markPeaks error1 : " + e);
                e.printStackTrace();
            }

            actual_bt.setText("Plot data"); // {^ɖ߂
            xc.addSeries(xs);
        }

        // "Mark peaks"{^NbNꂽ
        if (ae.getSource() == theory_bt || ae.getSource() == inpit_tf)
            try
            {
                markPeaks();
            }
            catch (Exception e)
            {
                System.err.println("markPeaks error2 : " + e);
                e.printStackTrace();
            }
    }

    public void itemStateChanged(ItemEvent ie)
    {
        if (ie.getSource() == ion_ch || ie.getSource() == ma_ch)
            try
            {
                markPeaks();
            }
            catch (Exception e)
            {
                System.err.println("markPeaks error3 : " + e);
                e.printStackTrace();
            }
    }

    void markPeaks() throws Exception
    {
        XYPlot xp = jc.getXYPlot();
        xp.clearDomainMarkers();                                        // ɕ\Ă}[J[폜

        DefaultTableModel tm = (DefaultTableModel)theory_tb.getModel(); // e[uf擾C
        tm.setRowCount(0);                                              // \̓e폜D

        String adduct;
        if (ion_ch.getSelectedItem().equals("Na+"))
            adduct = MassCalc.Na_ION;
        else if (ion_ch.getSelectedItem().equals("H+"))
            adduct = MassCalc.H_ION;
        else if (ion_ch.getSelectedItem().equals("Li+"))
            adduct = MassCalc.Li_ION;
        else if (ion_ch.getSelectedItem().equals("K+"))
            adduct = MassCalc.K_ION;
        else if (ion_ch.getSelectedItem().equals("H-"))
            adduct = MassCalc.H_NION;
        else if (ion_ch.getSelectedItem().equals("No adduct"))
            adduct = "";
        else
            adduct = "";

        boolean monoavg;
        if (ma_ch.getSelectedItem().equals("Monoisotopic"))
            monoavg = true;
        else
            monoavg = false;

        Glycan gc = null;
        try
        {
            gc = new Glycan(inpit_tf.getText());
        }
        catch (Exception e1)
        {
            try
            {
                GlycanTools gi = new GlycanTools();
                gc = gi.readNormalFormat(inpit_tf.getText());
            }
            catch (Exception e2)
            {
                System.err.println("Input format error: " + e1 + e2);
            }
        }

        try // ͂\𐳂CDihex,hexnacȂǂHex,HexNAcɏCj
        {
            inpit_tf.setText(gc.toNormalFormat()); // Linucs`łȂ\@\ł邩Ă݂D
        }
        catch (Exception e)
        {
            inpit_tf.setText(gc.toString());       // sꍇ́CLinucs`pĕ\D
        }

        gc.toHexose();                             // Glc->Hex֕ϊ܂D
        Fragmentation fg = new Fragmentation();
        fg.setGlycan(gc);
        for (Composition cp : fg.getComposition())
        {
            System.out.println(cp);
            String[] table = new String[2];        // J̒ǉ́Cz̑傫ɒӂD
            table[0] = String.format("%.4f", cp.getMass(monoavg, adduct));
            table[1] = cp.toString();
            tm.addRow(table);                      // e[uɒǉ

            ValueMarker mk1 = new ValueMarker(cp.getMass(monoavg, adduct) - 1);
            ValueMarker mk2 = new ValueMarker(cp.getMass(monoavg, adduct) + 1);
            if (cp.hasCeramide())
            {
                mk1.setPaint(Color.blue);
                mk2.setPaint(Color.blue);
            }
            else if(!cp.contains("-h2o"))
            {
                mk1.setPaint(Color.green);
                mk2.setPaint(Color.green);
            }
            xp.addDomainMarker(mk1);               // }[J[ǉ
            xp.addDomainMarker(mk2);
        }

        resetTableColumnSize();                    // e[ũJ𒲐
    }

    /*
     * e[ũJ𒲐߂܂D
     */
    private void resetTableColumnSize()
    {
        DefaultTableCellRenderer tr = new DefaultTableCellRenderer(); // e[ũJ𒲐
        tr.setHorizontalAlignment(SwingConstants.RIGHT);
        TableColumn tc0 = theory_tb.getColumnModel().getColumn(0);    // m/z̃Ji0Ԗځj̃TCYŒ
        tc0.setMinWidth(70);
        tc0.setMaxWidth(70);
        tc0.setCellRenderer(tr);                                      // JE񂹂
    }

    public void windowOpened(WindowEvent evt){}
    public void windowClosing(WindowEvent evt)
    {
        System.exit(0);
    }
    public void windowClosed(WindowEvent evt){}
    public void windowIconified(WindowEvent evt){}
    public void windowDeiconified(WindowEvent evt){}
    public void windowActivated(WindowEvent evt){}
    public void windowDeactivated(WindowEvent evt) {}

    public static void main(String[] args)
    {
        new FragmentationGUI();
    }
}
