/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import jp.sourceforge.gtibuilder.util.CharArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class HTMLColoring
implements DocumentListener {
    private JTextPane tp = null;
    private StyledDocument document = null;
    private static String[][] colorText = new String[20][20];
    private static boolean inited = false;
    private Vector commentDatabase = new Vector();
    private boolean commentFound = false;
    public static final SimpleAttributeSet javaKey = new SimpleAttributeSet();
    public static final SimpleAttributeSet comment = new SimpleAttributeSet();
    public static final SimpleAttributeSet text = new SimpleAttributeSet();
    public static final SimpleAttributeSet normal = new SimpleAttributeSet();

    public HTMLColoring(JTextPane jTextPane) {
        this.tp = jTextPane;
        this.document = this.tp.getStyledDocument();
        this.document.addDocumentListener(this);
        StyleConstants.setItalic(comment, true);
        StyleConstants.setForeground(comment, new Color(150, 150, 150));
        StyleConstants.setForeground(text, new Color(180, 0, 0));
        StyleConstants.setBold(javaKey, true);
        Color color = new Color(0, 0, 200);
        StyleConstants.setForeground(javaKey, color);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(final DocumentEvent documentEvent) {
        new Thread(){

            public void run() {
                HTMLColoring.this.changeDocument(documentEvent.getOffset(), documentEvent.getLength());
            }
        }.start();
    }

    public void removeUpdate(final DocumentEvent documentEvent) {
        new Thread(){

            public void run() {
                if (documentEvent.getOffset() == 0) {
                    if (HTMLColoring.this.tp.getText().length() != 0) {
                        HTMLColoring.this.changeDocument(documentEvent.getOffset(), 1);
                    }
                } else if (HTMLColoring.this.tp.getText().length() >= documentEvent.getOffset() + 2) {
                    HTMLColoring.this.changeDocument(documentEvent.getOffset() - 1, 3);
                } else if (HTMLColoring.this.tp.getText().length() >= documentEvent.getOffset() + 1) {
                    HTMLColoring.this.changeDocument(documentEvent.getOffset() - 1, 2);
                }
            }
        }.start();
    }

    public void changeDocument(int n, int n2) {
        int n3;
        this.commentFound = false;
        String string = this.tp.getText();
        TextBuffer.replace(string, "\r", "");
        int n4 = string.lastIndexOf(10, n);
        int n5 = string.indexOf(10, n + n2);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = string.length();
        }
        for (n3 = 0; n3 < this.commentDatabase.size(); ++n3) {
            Comment comment = (Comment)this.commentDatabase.elementAt(n3);
            if (!comment.isCommentArea(n4, n5)) continue;
            this.commentFound = true;
            break;
        }
        this.document.setCharacterAttributes(n4, n5 - n4, normal, true);
        n3 = string.indexOf(10, n4 + 1);
        int n6 = n4;
        while (n3 != -1 && n3 <= n5) {
            this.coloringText(n6, n3);
            n6 = n3;
            n3 = string.indexOf(10, n3 + 1);
        }
        if (n3 == -1) {
            this.coloringText(n6, this.tp.getText().length());
        }
        if (this.commentFound) {
            this.coloringComment();
        }
    }

    private void coloringText(int n, int n2) {
        int n3;
        char[] cArray;
        int n4;
        if (n > n2) {
            return;
        }
        CharArray charArray = new CharArray();
        String string = this.tp.getText().substring(n, n2);
        TextBuffer.replace(string, "\r", "");
        char[] cArray2 = string.toCharArray();
        Word word = new Word();
        word.start = n;
        word.end = n2;
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n2 - n > n4; ++n4) {
            if (n5 <= 1) {
                if (!Character.isLetterOrDigit(cArray2[n4])) {
                    if (charArray.size() != 0) {
                        cArray = new char[charArray.size()];
                        for (n3 = 0; n3 < charArray.size(); ++n3) {
                            cArray[n3] = charArray.getAt(n3);
                        }
                        word.end = n + n4;
                        word.word = new String(cArray);
                        this.coloring(word);
                        charArray.clear();
                        word = new Word();
                        word.start = n + n4 + 1;
                        Thread.yield();
                    } else {
                        word.start = n + n4 + 1;
                    }
                    if (cArray2[n4] == '<') {
                        if (n5 == 0) {
                            n6 = n4;
                        }
                        ++n5;
                        continue;
                    }
                    if (cArray2[n4] == '\"') {
                        n6 = n4;
                        n5 = 3;
                        continue;
                    }
                    if (cArray2[n4] == '!') {
                        if (n5 != 1) continue;
                        this.commentFound = true;
                        continue;
                    }
                    if (n5 != 1) continue;
                    n5 = 0;
                    continue;
                }
                charArray.add(cArray2[n4]);
                if (n5 != 1) continue;
                n5 = 0;
                continue;
            }
            if (n5 == 2) break;
            if (n5 != 3 || cArray2[n4] != '\"') continue;
            n5 = 0;
            this.document.setCharacterAttributes(n6 + n, n + n4 - (n6 + n) + 1, text, true);
        }
        if (n5 == 2) {
            this.document.setCharacterAttributes(n6 + n, n2 - (n6 + n), comment, true);
        } else if (n5 == 3) {
            this.document.setCharacterAttributes(n6 + n, n2 - (n6 + n), text, true);
        } else if (charArray.size() != 0) {
            cArray = new char[charArray.size()];
            for (n3 = 0; n3 < charArray.size(); ++n3) {
                cArray[n3] = charArray.getAt(n3);
            }
            word.end = n + n4;
            word.word = new String(cArray);
            this.coloring(word);
            charArray.clear();
        }
    }

    private void coloring(Word word) {
        HTMLColoring.init();
        int n = word.end - word.start;
        if (n > 19) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < colorText[n].length; ++i) {
            String string = colorText[n][i];
            if (!string.equals(word.word)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.document.setCharacterAttributes(word.start, n, javaKey, true);
        } else {
            this.document.setCharacterAttributes(word.start, n, normal, true);
        }
    }

    private void coloringComment() {
        this.commentDatabase = new Vector();
        String string = this.tp.getText();
        int n = -1;
        while ((n = string.indexOf("<!", n + 1)) != -1) {
            int n2 = n;
            n = string.indexOf(">", n + 1);
            int n3 = n + 2;
            Comment comment = new Comment(n2, n3);
            this.document.setCharacterAttributes(n2, n3 - n2, HTMLColoring.comment, true);
            this.commentDatabase.addElement(comment);
        }
    }

    private static void init() {
        int n;
        if (inited) {
            return;
        }
        Vector[] vectorArray = new Vector[20];
        for (int i = 0; i < colorText.length; ++i) {
            vectorArray[i] = new Vector();
        }
        String[] stringArray = new String[]{"a", "address", "applet", "area", "base", "basefont", "bgsound", "big", "blink", "blockquote", "body", "br", "caption", "center", "cite", "code", "dd", "dfn", "dir", "div", "dl", "dt", "em", "embed", "font", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html", "i", "iframe", "img", "input", "kbd", "li", "link", "map", "marquee", "menu", "multicol", "nobr", "noembed", "noframes", "object", "ol", "option", "p", "param", "plaintext", "pre", "rp", "rt", "ruby", "s", "samp", "script", "select", "small", "spacer", "span", "strong", "style", "sub", "sup", "table", "td", "textarea", "th", "title", "tr", "tt", "u", "ul", "vbr", "xmp", "meta"};
        for (n = 0; n < stringArray.length; ++n) {
            vectorArray[stringArray[n].length()].addElement(stringArray[n]);
        }
        for (n = 0; n < vectorArray.length; ++n) {
            Enumeration enumeration = vectorArray[n].elements();
            HTMLColoring.colorText[n] = new String[vectorArray[n].size()];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                HTMLColoring.colorText[n][n2] = (String)enumeration.nextElement();
                ++n2;
            }
        }
        inited = true;
    }

    public static void reset() {
        inited = false;
    }

    class Comment {
        private int start = 0;
        private int end = 0;

        public Comment(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public boolean isCommentArea(int n) {
            return this.start <= n && this.end >= n;
        }

        public boolean isCommentArea(int n, int n2) {
            if (this.start <= n && this.end >= n) {
                return true;
            }
            if (this.start <= n2 && this.end >= n2) {
                return true;
            }
            if (this.start >= n && this.end <= n) {
                return true;
            }
            return this.start >= n2 && this.end <= n2;
        }

        public String toString() {
            return "COMMENT START:" + this.start + "/END:" + this.end;
        }
    }

    class Word {
        public int start = 0;
        public int end = 0;
        public String word = new String();

        Word() {
        }

        public String toString() {
            return "Start AT:" + this.start + " / END AT:" + this.end + " / WORD:\"" + this.word + "\"";
        }
    }
}

