/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.Timer;
import jp.sourceforge.gtibuilder.editor.DefaultFilePreference;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.ProjectFile;

public class Editor
extends JInternalFrame
implements ProjectFile {
    private EditorComponent ecomp = null;
    private Timer timer = null;
    private Task tt = null;

    public Editor(EditorComponent ecompx) {
        super("", true, true, true, true);
        this.init(ecompx);
    }

    protected final void init(EditorComponent ecompx) {
        if (ecompx == null) {
            throw new NullPointerException();
        }
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.ecomp = ecompx;
        this.getContentPane().add(this.ecomp.getComponent());
        this.setTitle(this.ecomp.getFileName());
        this.tt = new Task(this, this.ecomp);
        this.timer = new Timer(1000, this.tt);
        this.timer.start();
        this.setDefaultCloseOperation(1);
    }

    public boolean readData(byte[] data) {
        return this.ecomp.readData(data);
    }

    public byte[] getData() {
        return this.ecomp.getData();
    }

    public FileType getFileType() {
        return this.ecomp.getFileType();
    }

    public boolean setFileType(FileType ft) {
        if (this.ecomp.isSupportedType(ft)) {
            return this.ecomp.setFileType(ft);
        }
        return false;
    }

    public boolean isAutoCheckProperty() {
        return this.ecomp.isAutoCheckProperty();
    }

    public String getFileName() {
        return this.ecomp.getFileName();
    }

    public boolean setFileName(String name) {
        if (this.isAutoCheckProperty()) {
            return false;
        }
        return this.ecomp.setFileName(name);
    }

    public String getDirectory() {
        return this.ecomp.getDirectory();
    }

    public boolean setDirectory(String pack) {
        return this.ecomp.setDirectory(pack);
    }

    public JMenu[] usingMenu() {
        return this.ecomp.usingMenu();
    }

    public boolean usingEditMenu() {
        return this.ecomp.usingEditMenu();
    }

    public boolean close() {
        return this.ecomp.close();
    }

    public void copy() {
        this.ecomp.copy();
    }

    public void cut() {
        this.ecomp.cut();
    }

    public void delete() {
        this.ecomp.delete();
    }

    public void paste() {
        this.ecomp.paste();
    }

    public void undo() {
        this.ecomp.undo();
    }

    public void redo() {
        this.ecomp.redo();
    }

    public void saved() {
        this.ecomp.saved();
    }

    public void showFilePreference() {
        Dialog dialog = this.ecomp.getFilePreference();
        if (dialog != null) {
            dialog.show();
        } else {
            new DefaultFilePreference(null, true, this.ecomp).show();
        }
    }

    private class Task
    implements ActionListener {
        private Editor editor = null;
        private EditorComponent ecomp = null;

        public Task(Editor e, EditorComponent ec) {
            this.editor = e;
            this.ecomp = ec;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String e;
            String ec = this.ecomp.getFileName();
            if (!ec.equals(e = this.editor.getTitle())) {
                this.editor.setTitle(ec);
            }
        }
    }
}

