/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.main;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jp.sourceforge.gtibuilder.main.NewWindowListener;

public class WindowManager
implements NewWindowListener {
    private Vector windows = new Vector();
    private Vector frames = new Vector();
    private JMenu menu = new JMenu("Window");

    public void addWindow(Frame window) {
        this.windows.addElement(window);
        this.menu.add(new WindowMenu(window, this.menu));
    }

    public void addWindow(JInternalFrame frame) {
        this.frames.addElement(frame);
        this.menu.add(new WindowMenu(frame, this.menu));
    }

    public void setWindowMenu(JMenu menu) {
        this.menu = menu;
    }

    public JMenu getWindowMenu() {
        return this.menu;
    }

    public void updataLookAndFeel() {
        int count = 0;
        while (count < this.windows.size()) {
            SwingUtilities.updateComponentTreeUI((Window)this.windows.elementAt(count));
            ++count;
        }
    }

    public void restart() {
        int count = 0;
        while (count < this.frames.size()) {
            ((JInternalFrame)this.frames.elementAt(count)).setVisible(false);
            ((JInternalFrame)this.frames.elementAt(count)).dispose();
            ++count;
        }
        int count2 = 0;
        while (count2 < this.windows.size()) {
            ((Component)((Window)this.windows.elementAt(count2))).setVisible(false);
            ((Window)this.windows.elementAt(count2)).dispose();
            ++count2;
        }
    }

    class WindowMenu
    extends JMenuItem
    implements ActionListener,
    WindowListener,
    InternalFrameListener {
        Window window;
        JInternalFrame frame;
        boolean isWindow = true;
        JMenu menu;

        public WindowMenu(Frame window, JMenu menu) {
            this.window = window;
            this.setText(window.getTitle());
            this.init(menu);
        }

        public WindowMenu(JInternalFrame frame, JMenu menu) {
            this.frame = frame;
            this.setText(frame.getTitle());
            this.isWindow = false;
            this.init(menu);
        }

        private void init(JMenu menu) {
            this.addActionListener(this);
            this.menu = menu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isWindow) {
                this.window.show();
            } else {
                this.frame.show();
            }
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            this.menu.remove(this);
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

