/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.plugin;

import java.util.Enumeration;
import java.util.Vector;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.plugin.Plugin;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class PluginManager {
    private Vector plugins = null;
    private StringArray list = null;
    private ProjectManager manager = null;
    private boolean inited = false;
    private Plugin[] pluginIntastances = null;
    private boolean[] enabled = null;
    static /* synthetic */ Class class$jp$sourceforge$gtibuilder$plugin$PluginManager;

    public PluginManager(ProjectManager manager) {
        UserPreferences up = UserPreferences.loadPreferences("PluginDataBase");
        if (up.getStringArray().getKeys().length == 0) {
            this.list = new StringArray((class$jp$sourceforge$gtibuilder$plugin$PluginManager == null ? (class$jp$sourceforge$gtibuilder$plugin$PluginManager = PluginManager.class$("jp.sourceforge.gtibuilder.plugin.PluginManager")) : class$jp$sourceforge$gtibuilder$plugin$PluginManager).getResourceAsStream("PluginDataBase.properties"));
            up.setStringArray(this.list);
            up.saveData();
        } else {
            this.list = up.getStringArray();
        }
        this.manager = manager;
        String[] keys = this.list.getKeys();
        this.plugins = new Vector();
        int count = 0;
        while (count < keys.length) {
            this.plugins.addElement(keys[count]);
            ++count;
        }
    }

    public void init() {
        if (this.inited) {
            return;
        }
        Plugin[] p = this.getInstances();
        this.pluginIntastances = p;
        int count = 0;
        while (p.length > count) {
            if (this.enabled[count]) {
                if (p[count].getMenuAddPoint() == 1) {
                    this.manager.addMenuAt("FILE", p[count].getJMenuItem());
                } else if (p[count].getMenuAddPoint() == 2) {
                    this.manager.addMenuAt("EDIT", p[count].getJMenuItem());
                } else if (p[count].getMenuAddPoint() == 4) {
                    this.manager.addMenuAt("TOOLS", p[count].getJMenuItem());
                } else if (p[count].getMenuAddPoint() == 3) {
                    this.manager.addMenuAt("PROJECT", p[count].getJMenuItem());
                } else if (p[count].getMenuAddPoint() == 5) {
                    this.manager.addMenuAt("HELP", p[count].getJMenuItem());
                } else {
                    this.manager.addMenu(p[count].getJMenu());
                }
                p[count].setProjectManager(this.manager);
            }
            ++count;
        }
        this.inited = true;
    }

    private Plugin getInstance(String key) {
        try {
            String[] name = TextBuffer.cutString((String)this.list.getContent(key), " ");
            Class<?> clazz = Class.forName(name[0]);
            return (Plugin)clazz.newInstance();
        }
        catch (Exception e) {
            Debug.print(e);
            new ErrorDialog(e).show();
            return null;
        }
    }

    private Plugin[] getInstances() {
        Enumeration enu = this.plugins.elements();
        Plugin[] p = new Plugin[this.plugins.size()];
        this.enabled = new boolean[p.length];
        int count = 0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            p[count] = this.getInstance(key);
            String[] name = TextBuffer.cutString((String)this.list.getContent(key), " ");
            this.enabled[count] = Boolean.valueOf(name[1]);
            Debug.print(this.enabled[count]);
            ++count;
        }
        return p;
    }

    public Plugin[] getPlugins() {
        return this.pluginIntastances;
    }

    public Plugin getPlugin(int index) {
        return this.pluginIntastances[index];
    }

    public boolean isEnablePlugin(int index) {
        return this.enabled[index];
    }

    public void setEnablePlugin(int index, boolean enabled) {
        this.enabled[index] = enabled;
    }

    public int getPluginIndex(String name) {
        int count = 0;
        while (this.pluginIntastances.length > count) {
            if (this.pluginIntastances[count].getPluginName().equals(name)) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public void savePluginDataBase() {
        UserPreferences up = UserPreferences.loadPreferences("PluginDataBase");
        int count = 0;
        while (this.pluginIntastances.length > count) {
            up.setData(this.pluginIntastances[count].getPluginName(), this.pluginIntastances[count].getClass().getName() + " " + this.isEnablePlugin(count));
            ++count;
        }
        up.saveData();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

