/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.project;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.io.ProjectWriter;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.main.WindowManager;
import jp.sourceforge.gtibuilder.project.AddFileDialog;
import jp.sourceforge.gtibuilder.project.NameUpdataEvent;
import jp.sourceforge.gtibuilder.project.NameUpdataListener;
import jp.sourceforge.gtibuilder.project.ProjectPreference;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class Project
extends JPanel
implements ActionListener,
MouseListener {
    public static final String MASTER = "MASTER";
    public static final String NAME = "NAME";
    public static final String COPYRIGHT = "COPYRIGHT";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String COMMENT = "COMMENT";
    public static final String WINDOW_MANAGER = "WINDOW_MANAGER";
    private JSplitPane sp = null;
    private JDesktopPane dp = null;
    private JTree jt = null;
    private Vector editors = new Vector();
    private DefaultMutableTreeNode node = null;
    private DefaultTreeModel model = null;
    private File file = null;
    private String mainClass = null;
    private String copyright = null;
    private String projectName = null;
    private String org = null;
    private String comment = null;
    private String master = null;
    private String dpackage = null;
    private Timer timer = null;
    private WindowListener listener = null;
    private NewWindowListener newListener = null;
    private Vector listeners = new Vector();
    private int newx = 0;
    private int newy = 0;

    public Project(StringArray map) {
        this.timer = new Timer(1000, this);
        this.projectName = (String)map.getContent(NAME);
        this.copyright = (String)map.getContent(COPYRIGHT);
        this.org = (String)map.getContent(ORGANIZATION);
        this.master = (String)map.getContent(MASTER);
        this.comment = (String)map.getContent(COMMENT);
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.projectName);
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane spp = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, spp, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = (NewWindowListener)map.getContent(WINDOW_MANAGER);
        this.timer.start();
        this.jt.addMouseListener(this);
    }

    public Project(byte[] info, WindowManager manager) {
        this.timer = new Timer(1000, this);
        this.setProjectInfo(info);
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.projectName);
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane spp = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, spp, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = manager;
        this.timer.start();
        this.jt.addMouseListener(this);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getOrg() {
        return this.org;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMaster() {
        return this.master;
    }

    public File getSaveFile() {
        return this.file;
    }

    public byte[] getProjectInfo() {
        StringBuffer buff = new StringBuffer();
        buff.append("Master=");
        buff.append(this.master);
        buff.append("\n");
        buff.append("Comment=");
        buff.append(this.comment);
        buff.append("\n");
        buff.append("Project_Name=");
        buff.append(this.projectName);
        buff.append("\n");
        buff.append("Copyright=");
        buff.append(this.copyright);
        buff.append("\n");
        buff.append("Main_Class=");
        buff.append(this.mainClass);
        buff.append("\n");
        return buff.toString().getBytes();
    }

    public boolean setProjectInfo(byte[] info) {
        StringArray list = new StringArray(new ByteArrayInputStream(info));
        this.master = (String)list.getContent("Master");
        this.projectName = (String)list.getContent("Project_Name");
        this.mainClass = (String)list.getContent("Main_Class");
        this.comment = (String)list.getContent("Comment");
        this.copyright = (String)list.getContent("Copyright");
        return true;
    }

    public void setMainClass(String clazz) {
        this.mainClass = clazz;
    }

    public void setCopyright(String copy) {
        this.copyright = copy;
    }

    public void setProjectName(String name) {
        this.projectName = name;
        Enumeration array = this.listeners.elements();
        while (array.hasMoreElements()) {
            ((NameUpdataListener)array.nextElement()).updataName(new NameUpdataEvent((Object)this, name));
        }
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setSaveFile(File file) {
        this.file = file;
    }

    public void addEditor(Editor editor) {
        editor.addInternalFrameListener(this.listener);
        this.newListener.addWindow(editor);
        editor.setBounds(this.newx, this.newy, 400, 300);
        this.newx += 40;
        this.newy += 40;
        this.editors.addElement(editor);
        this.dp.add(editor);
        editor.setVisible(true);
        String[] pack = TextBuffer.cutString(editor.getDirectory(), "/");
        DefaultMutableTreeNode node = this.node;
        DefaultMutableTreeNode temp = null;
        int count = 0;
        while (count < pack.length) {
            if (pack[count].equals("")) break;
            Enumeration<TreeNode> enu = node.children();
            enu = node.children();
            TreeNode[] arrays = node.getPath();
            boolean found = false;
            while (enu.hasMoreElements() && !found) {
                temp = (DefaultMutableTreeNode)enu.nextElement();
                if (!pack[count].equals(temp.getUserObject())) continue;
                node = temp;
                found = true;
            }
            if (!found) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(pack[count]);
                node.add(newNode);
                node = newNode;
            }
            editor.toFront();
            ++count;
        }
        temp = new FileNode(editor);
        node.add(temp);
        this.model.reload();
        this.jt.treeDidChange();
    }

    /*
     * Loose catch block
     */
    public void addFile() {
        block11: {
            FileInputStream fis;
            block10: {
                FileDialog fd = new FileDialog((Frame)MainWindow.getMainWindow(), "Add File", 0);
                fd.show();
                fis = null;
                if (fd.getFile() == null) {
                    return;
                }
                File file = new File(fd.getDirectory() + fd.getFile());
                fis = new FileInputStream(file);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int data = 0;
                while ((data = fis.read()) != -1) {
                    os.write(data);
                }
                final byte[] datas = os.toByteArray();
                String extension = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(46) + 1);
                final FileType type = FileDataBase.getWithExtension(extension);
                final EditorComponent comp = type.getEditor();
                if (comp == null) break block10;
                final AddFileDialog afd = new AddFileDialog(file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(47) + 1));
                afd.show();
                afd.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent e) {
                        comp.init(afd.getMap(), type);
                        comp.readData(datas);
                        Project.this.addEditor(new Editor(comp));
                    }
                });
            }
            Object var12_12 = null;
            try {
                fis.close();
            }
            catch (Exception e2) {
                Debug.print(e2);
                new ErrorDialog(e2).show();
            }
            break block11;
            {
                catch (IOException e) {
                    Debug.print(e);
                    new ErrorDialog(e).show();
                    Object var12_13 = null;
                    try {
                        fis.close();
                    }
                    catch (Exception e2) {
                        Debug.print(e2);
                        new ErrorDialog(e2).show();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    fis.close();
                }
                catch (Exception e2) {
                    Debug.print(e2);
                    new ErrorDialog(e2).show();
                }
                throw throwable;
            }
        }
    }

    public ProjectFile[] getProjectFiles() {
        return this.getEditors();
    }

    protected Editor[] getEditors() {
        Editor[] edits = new Editor[this.editors.size()];
        int loop = 0;
        int size = edits.length;
        while (loop < size) {
            edits[loop] = (Editor)this.editors.elementAt(loop);
            ++loop;
        }
        return edits;
    }

    protected Editor getSelectedEditor() {
        JInternalFrame jif = this.listener.getSelectedFrame();
        if (jif == null) {
            return null;
        }
        if (jif instanceof Editor) {
            return (Editor)jif;
        }
        return null;
    }

    public void showFilePreference() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().showFilePreference();
        }
    }

    public void showProjectPreference() {
        ProjectPreference pre = new ProjectPreference(this);
        pre.show();
    }

    public void copy() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().copy();
        }
    }

    public void cut() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().cut();
        }
    }

    public void paste() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().paste();
        }
    }

    public void delete() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().delete();
        }
    }

    public void undo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().undo();
        }
    }

    public void redo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().redo();
        }
    }

    public void task() {
    }

    public void save() {
        if (this.file == null) {
            this.saveAs();
        }
        final File f = this.file;
        final Project p = this;
        new Thread(){

            public void run() {
                ProjectWriter.save(f, p);
            }
        }.start();
    }

    public void saveAs() {
        FileDialog fd = new FileDialog((Frame)MainWindow.getMainWindow(), "Save Project", 1);
        fd.setFile(this.getProjectName() + ".gtb");
        fd.show();
        if (fd.getFile() != null) {
            this.file = new File(fd.getDirectory() + fd.getFile());
            this.save();
        }
    }

    public void addNameUpdataListener(NameUpdataListener listener) {
        if (this.listeners.indexOf(listener) != -1) {
            return;
        }
        this.listeners.addElement(listener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            this.task();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (node instanceof FileNode && mouseEvent.getClickCount() == 2) {
            ((Editor)((FileNode)node).getProjectFile()).show();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class FileNode
    extends DefaultMutableTreeNode
    implements NameUpdataListener {
        private ProjectFile file = null;

        public FileNode(ProjectFile file) {
            this.file = file;
            this.setUserObject(file.getFileName());
        }

        public void updataName(NameUpdataEvent event) {
            this.setUserObject(this.file.getFileName());
        }

        public ProjectFile getProjectFile() {
            return this.file;
        }
    }

    class WindowListener
    implements InternalFrameListener {
        private JInternalFrame selectedFrame = null;

        WindowListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            this.selectedFrame = (JInternalFrame)internalFrameEvent.getSource();
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            if (this.selectedFrame == internalFrameEvent.getSource()) {
                this.selectedFrame = null;
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public JInternalFrame getSelectedFrame() {
            return this.selectedFrame;
        }
    }
}

