/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.project;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.sourceforge.gtibuilder.io.ProjectReader;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.NewDialog;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.WindowManager;
import jp.sourceforge.gtibuilder.plugin.PluginManager;
import jp.sourceforge.gtibuilder.project.NameUpdataEvent;
import jp.sourceforge.gtibuilder.project.NameUpdataListener;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class ProjectManager
extends JPanel
implements NewWindowListener,
NameUpdataListener {
    public static final String FILE = "FILE";
    public static final String EDIT = "EDIT";
    public static final String TOOLS = "TOOLS";
    public static final String PROJECT = "PROJECT";
    public static final String HELP = "HELP";
    private JTabbedPane tp = null;
    private JMenuBar bar = null;
    private boolean barSet = false;
    private boolean keySet = false;
    private WindowManager wmanager;
    private PluginManager pmanager;
    private StringArray keyMenuItems;
    private int menuAddPoint = 0;

    public ProjectManager() {
        this.setLayout(new GridLayout(1, 1));
        this.wmanager = new WindowManager();
        this.pmanager = new PluginManager(this);
        String filePath = UserPreferences.getSystemPreferences().getData("OPENED_PROJECT");
        boolean autoOpen = Boolean.valueOf(UserPreferences.getSystemPreferences().getData("AUTO_OPEN_PROJECT"));
        if (filePath != null && autoOpen) {
            Debug.print("Auto open system");
            String[] files = TextBuffer.cutString(filePath, File.pathSeparator);
            int count = 0;
            while (files.length - 1 > count) {
                Debug.print("OPEN = " + files[count]);
                this.add(ProjectReader.read(new File(files[count]), this, false));
                ++count;
            }
        }
    }

    public void add(Project pro) {
        if (this.tp == null) {
            this.tp = new JTabbedPane();
            this.add(this.tp);
        }
        pro.addNameUpdataListener(this);
        this.tp.addTab(pro.getProjectName(), pro);
    }

    public void addMenuAt(String key, JMenuItem item) {
        ((JMenu)this.keyMenuItems.getContent(key)).add(item);
    }

    public void addMenuAt(String key, JMenuItem[] item) {
        int count = 0;
        while (item.length > count) {
            ((JMenu)this.keyMenuItems.getContent(key)).add(item[count]);
            ++count;
        }
    }

    public void addMenu(JMenu menu) {
        JMenu temp = this.bar.getMenu(this.bar.getMenuCount() - 1);
        this.bar.remove(this.bar.getMenuCount() - 1);
        this.bar.add(menu);
        this.bar.add(temp);
    }

    public Project getProject() {
        if (this.tp == null) {
            return null;
        }
        return (Project)this.tp.getSelectedComponent();
    }

    public void openProject() {
        final ProjectManager manager = this;
        new Thread(){

            public void run() {
                FileDialog fd = new FileDialog((Frame)MainWindow.getMainWindow(), "Open Project", 0);
                fd.setFilenameFilter(new FilenameFilter(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File file, String name) {
                        File ff = new File(file.getAbsolutePath() + File.separator + name);
                        if (ff.isDirectory()) {
                            return true;
                        }
                        Debug.print(ff);
                        return name.lastIndexOf(".gtb") == name.length() - 4;
                    }
                });
                fd.show();
                if (fd.getFile() != null) {
                    String name = fd.getFile();
                    if (name.lastIndexOf(".gtb") != name.length() - 4) {
                        name = name + ".gtb";
                    }
                    File file = new File(fd.getDirectory() + name);
                    Project project = ProjectReader.read(file, manager, true);
                    manager.add(project);
                }
            }
        }.start();
    }

    public void remove(Project pro) {
        if (this.tp == null) {
            return;
        }
        this.tp.remove(pro);
    }

    public void closeProject() {
        Project p = this.getProject();
        this.remove(p);
    }

    public void newFile() {
        NewDialog np = new NewDialog(this);
        np.show();
    }

    public boolean exit() {
        if (this.tp == null) {
            return true;
        }
        Component[] comp = this.tp.getComponents();
        StringBuffer buff = new StringBuffer();
        int count = 0;
        while (comp.length > count) {
            buff.append(((Project)comp[count]).getSaveFile().getAbsolutePath());
            buff.append(File.pathSeparator);
            ++count;
        }
        UserPreferences.getSystemPreferences().setData("OPENED_PROJECT", buff.toString());
        return true;
    }

    public void setJMenuBar(JMenuBar menu) {
        if (!this.barSet) {
            this.bar = menu;
            this.barSet = true;
        }
        if (this.keySet) {
            this.pmanager.init();
        }
    }

    public void setKeyMenuItems(StringArray array) {
        if (!this.keySet) {
            this.keyMenuItems = array;
            this.keySet = true;
        }
        if (this.barSet) {
            this.pmanager.init();
        }
    }

    public void addWindow(Frame window) {
        this.wmanager.addWindow(window);
    }

    public void addWindow(JInternalFrame frame) {
        this.wmanager.addWindow(frame);
    }

    public void updataName(NameUpdataEvent event) {
        this.tp.setTitleAt(this.tp.indexOfComponent((Project)event.getSource()), event.getNewName());
        this.tp.setToolTipTextAt(this.tp.indexOfComponent((Project)event.getSource()), ((Project)event.getSource()).getComment());
    }

    public WindowManager getWindowManager() {
        return this.wmanager;
    }

    public PluginManager getPluginManager() {
        return this.pmanager;
    }
}

