/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FieldLayout
implements LayoutManager,
Serializable {
    public static final String HEADLINE = "HEADLINE";
    public static final String CONTENT = "CONTENT";
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 3;
    private Component headline = null;
    private Component content = null;
    private int layoutStyle = 3;

    public FieldLayout() {
        this.layoutStyle = 2;
    }

    public FieldLayout(int layoutStyle) {
        this.layoutStyle = layoutStyle;
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name.equals(HEADLINE)) {
            this.headline = comp;
        } else if (name.equals(CONTENT)) {
            this.content = comp;
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (this.headline == comp) {
            this.headline = null;
        }
        if (this.content == comp) {
            this.content = null;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.headline == null || this.content == null) {
            return new Dimension(0, 0);
        }
        int xsize = 0;
        int ysize = 0;
        xsize = this.headline.getPreferredSize().width + this.content.getPreferredSize().width;
        int tempy1 = this.headline.getPreferredSize().height;
        int tempy2 = this.content.getPreferredSize().height;
        ysize = tempy1 == tempy2 ? tempy1 : (tempy1 > tempy2 ? tempy1 : tempy2);
        return new Dimension(xsize, ysize);
    }

    public Dimension minimumLayoutSize(Container parent) {
        if (this.headline == null || this.content == null) {
            return new Dimension(0, 0);
        }
        int xsize = 0;
        int ysize = 0;
        xsize = this.headline.getMinimumSize().width + this.content.getPreferredSize().width;
        int tempy1 = this.headline.getMinimumSize().height;
        int tempy2 = this.content.getMinimumSize().height;
        ysize = tempy1 == tempy2 ? tempy1 : (tempy1 > tempy2 ? tempy1 : tempy2);
        return new Dimension(xsize, ysize);
    }

    public void layoutContainer(Container parent) {
        if (this.headline == null || this.content == null) {
            return;
        }
        int height = parent.getSize().height;
        int width = parent.getSize().width;
        Dimension hld = new Dimension();
        Dimension cnd = new Dimension();
        if (this.headline.getPreferredSize().height >= height) {
            this.headline.setLocation(0, 0);
            hld.height = height;
        } else {
            if (this.layoutStyle == 1) {
                this.headline.setLocation(0, 0);
            } else if (this.layoutStyle == 2) {
                this.headline.setLocation(0, (height - this.headline.getPreferredSize().height) / 2);
            } else {
                this.headline.setLocation(0, height - this.headline.getPreferredSize().height);
            }
            hld.height = this.headline.getPreferredSize().height;
        }
        hld.width = this.headline.getPreferredSize().width;
        if (this.content.getPreferredSize().height >= height) {
            this.content.setLocation(hld.width, 0);
            cnd.height = height;
        } else {
            if (this.layoutStyle == 1) {
                this.content.setLocation(hld.width, 0);
            } else if (this.layoutStyle == 2) {
                this.content.setLocation(hld.width, (height - this.content.getPreferredSize().height) / 2);
            } else {
                this.content.setLocation(hld.width, height - this.content.getPreferredSize().height);
            }
            cnd.height = this.content.getPreferredSize().height;
        }
        cnd.width = width - hld.width;
        this.content.setSize(cnd);
        this.headline.setSize(hld);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof String) {
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        if (this.headline == null || this.content == null) {
            return new Dimension(0, 0);
        }
        int xsize = 0;
        int ysize = 0;
        xsize = this.headline.getMaximumSize().width + this.content.getMaximumSize().width;
        int tempy1 = this.headline.getMaximumSize().height;
        int tempy2 = this.content.getMaximumSize().height;
        ysize = tempy1 == tempy2 ? tempy1 : (tempy1 > tempy2 ? tempy1 : tempy2);
        return new Dimension(xsize, ysize);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
    }
}

