/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.build;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.sourceforge.gtibuilder.build.BuildPreference;
import jp.sourceforge.gtibuilder.build.Export;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.plugin.Plugin;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class Build
implements Plugin,
ActionListener {
    private JMenuItem[] menus = new JMenuItem[4];
    private JMenu menu = null;
    private ProjectManager manager = null;

    public Build() {
        this.menus[0] = new JMenuItem("Build");
        this.menus[1] = new JMenuItem("Run");
        this.menus[2] = new JMenuItem("Build&Run");
        this.menus[3] = new JMenuItem("Build&Run Preference");
        this.menu = new JMenu("Build");
        this.menu.add(this.menus[0]);
        this.menu.add(this.menus[1]);
        this.menu.add(this.menus[2]);
        this.menu.add(this.menus[3]);
        this.menus[0].addActionListener(this);
        this.menus[1].addActionListener(this);
        this.menus[2].addActionListener(this);
        this.menus[3].addActionListener(this);
    }

    public JMenuItem[] getJMenuItem() {
        return this.menus;
    }

    public int getMenuAddPoint() {
        return -1;
    }

    public JMenu getJMenu() {
        return this.menu;
    }

    public String getPluginName() {
        return "Build";
    }

    public String getPluginVersion() {
        return "0.0";
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.manager = projectManager;
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                if (actionEvent.getSource().equals(Build.this.menus[0])) {
                    Build.this.build();
                } else if (actionEvent.getSource().equals(Build.this.menus[1])) {
                    Build.this.exec();
                } else {
                    if (actionEvent.getSource().equals(Build.this.menus[2])) {
                        if (Build.this.build()) {
                            Build.this.exec();
                        }
                        return;
                    }
                    if (actionEvent.getSource().equals(Build.this.menus[3])) {
                        BuildPreference buildPreference = new BuildPreference(Build.this.manager.getProject());
                        buildPreference.show();
                        Build.this.manager.getProject().setMainClass(buildPreference.getMainClass());
                    }
                }
            }
        }.start();
    }

    public boolean build() {
        Export export = (Export)this.manager.getPluginManager().getPlugin("Export");
        File file = new File(System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION" + File.separator + "Build");
        export.export(file);
        ProjectFile[] projectFileArray = this.manager.getProject().getProjectFiles();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n < projectFileArray.length) {
            if (projectFileArray[n].getFileType() != FileDataBase.getWithExtension("java")) {
                ++n;
                continue;
            }
            if ("".equals(projectFileArray[n].getDirectory()) || projectFileArray[n].getDirectory() == null) {
                stringBuffer.append(file.getAbsolutePath() + File.separator + projectFileArray[n].getFileName());
            } else {
                stringBuffer.append(file.getAbsolutePath() + File.separator + TextBuffer.replace(projectFileArray[n].getDirectory(), "/", File.separator) + File.separator + projectFileArray[n].getFileName());
            }
            stringBuffer.append(" ");
            ++n;
            ++n2;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("javac");
        stringBuffer2.append(" ");
        stringBuffer2.append("-encoding");
        stringBuffer2.append(" ");
        stringBuffer2.append("UTF-8");
        stringBuffer2.append(" ");
        stringBuffer2.append("-classpath");
        stringBuffer2.append(" ");
        stringBuffer2.append(file.getAbsolutePath());
        stringBuffer2.append(" ");
        stringBuffer2.append(stringBuffer.toString());
        Debug.print(stringBuffer2);
        try {
            Process process = Runtime.getRuntime().exec(stringBuffer2.toString());
            OutputFrame outputFrame = new OutputFrame(process, "Build", stringBuffer2.toString());
            this.manager.getProject().addInternalFrame(outputFrame);
            outputFrame.setVisible(true);
            outputFrame.getThread().join();
            return outputFrame.isSucceed();
        }
        catch (IOException iOException) {
            new ErrorDialog(iOException);
        }
        catch (Exception exception) {
            new ErrorDialog(exception);
        }
        return false;
    }

    public void exec() {
        File file = new File(System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION" + File.separator + "Build");
        String string = "java -classpath " + file.getAbsolutePath() + " " + this.manager.getProject().getMainClass();
        try {
            Process process = Runtime.getRuntime().exec(string);
            OutputFrame outputFrame = new OutputFrame(process, "Run", string);
            this.manager.getProject().addInternalFrame(outputFrame);
            outputFrame.setVisible(true);
        }
        catch (IOException iOException) {
            new ErrorDialog(iOException);
        }
        catch (Exception exception) {
            new ErrorDialog(exception);
        }
    }

    class OutputFrame
    extends JInternalFrame
    implements Runnable {
        BufferedReader sbr = null;
        BufferedReader ebr = null;
        PrintWriter out = null;
        JTextArea ta = null;
        boolean stop = false;
        boolean succeed = false;
        Process process = null;
        Thread thread = null;

        public OutputFrame(Process process, String string, String string2) {
            super(string, true, true, true, true);
            Thread thread;
            this.sbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            this.out = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
            this.ta = new JTextArea(string2 + "\n");
            this.getContentPane().add(new JScrollPane(this.ta));
            this.thread = thread = new Thread(this);
            this.process = process;
            this.setBounds(0, 0, 300, 200);
            thread.start();
        }

        public Thread getThread() {
            return this.thread;
        }

        public boolean isSucceed() throws IllegalThreadStateException {
            if (!this.stop) {
                throw new IllegalThreadStateException();
            }
            return this.succeed;
        }

        public void run() {
            while (!this.stop) {
                int n = 0;
                try {
                    boolean bl = true;
                    try {
                        n = this.process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        bl = false;
                    }
                    if (!bl) {
                        String string = null;
                        while ((string = this.sbr.readLine()) != null) {
                            this.ta.setText(this.ta.getText() + string + "\n");
                        }
                        string = null;
                        while ((string = this.ebr.readLine()) != null) {
                            this.ta.setText(this.ta.getText() + string + "\n");
                        }
                    } else {
                        this.sbr.close();
                        this.ebr.close();
                        this.out.close();
                        this.stop = true;
                    }
                }
                catch (IOException iOException) {
                    new ErrorDialog(iOException);
                }
                try {
                    Thread.sleep(100L);
                    Thread.yield();
                    Thread.yield();
                    Thread.yield();
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.process.exitValue() == 0) {
                this.ta.setText(this.ta.getText() + "NO ERRORS.");
                this.succeed = true;
            } else {
                this.ta.setText(this.ta.getText() + "Done. " + this.process.exitValue());
            }
        }
    }
}

