/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.project;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.io.ProjectWriter;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.main.WindowManager;
import jp.sourceforge.gtibuilder.project.AddFileDialog;
import jp.sourceforge.gtibuilder.project.EditorUpdataEvent;
import jp.sourceforge.gtibuilder.project.EditorUpdataListener;
import jp.sourceforge.gtibuilder.project.NameUpdataEvent;
import jp.sourceforge.gtibuilder.project.NameUpdataListener;
import jp.sourceforge.gtibuilder.project.ProjectPreference;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class Project
extends JPanel
implements MouseListener {
    public static final String MASTER = "MASTER";
    public static final String NAME = "NAME";
    public static final String COPYRIGHT = "COPYRIGHT";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String COMMENT = "COMMENT";
    public static final String WINDOW_MANAGER = "WINDOW_MANAGER";
    public static final String MAIN_CLASS = "MAIN_CLASS";
    private JSplitPane sp = null;
    private JDesktopPane dp = null;
    private JTree jt = null;
    private Vector editors = new Vector();
    private DefaultMutableTreeNode node = null;
    private DefaultTreeModel model = null;
    private File file = null;
    private boolean edited = false;
    private StringArray infomation = new StringArray();
    private Timer timer = null;
    private WindowListener listener = null;
    private NewWindowListener newListener = null;
    private Vector listeners = new Vector();
    private int newx = 0;
    private int newy = 0;

    public Project(StringArray stringArray) {
        this.infomation.add(NAME, (String)stringArray.getContent(NAME));
        this.infomation.add(COPYRIGHT, (String)stringArray.getContent(COPYRIGHT));
        this.infomation.add(ORGANIZATION, (String)stringArray.getContent(ORGANIZATION));
        this.infomation.add(MASTER, (String)stringArray.getContent(MASTER));
        this.infomation.add(COMMENT, (String)stringArray.getContent(COMMENT));
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.getProjectName());
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, jScrollPane, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = (NewWindowListener)stringArray.getContent(WINDOW_MANAGER);
        this.jt.addMouseListener(this);
    }

    public Project(byte[] byArray, WindowManager windowManager) {
        this.setProjectInfo(byArray);
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.getProjectName());
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, jScrollPane, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = windowManager;
        this.jt.addMouseListener(this);
    }

    public String getMainClass() {
        return (String)this.infomation.getContent(MAIN_CLASS);
    }

    public String getCopyright() {
        return (String)this.infomation.getContent(COPYRIGHT);
    }

    public String getProjectName() {
        return (String)this.infomation.getContent(NAME);
    }

    public String getOrg() {
        return (String)this.infomation.getContent(ORGANIZATION);
    }

    public String getComment() {
        return (String)this.infomation.getContent(COMMENT);
    }

    public String getMaster() {
        return (String)this.infomation.getContent(MASTER);
    }

    public File getSaveFile() {
        return this.file;
    }

    public byte[] getProjectInfo() {
        return this.infomation.getData();
    }

    public boolean setProjectInfo(byte[] byArray) {
        StringArray stringArray = new StringArray(new ByteArrayInputStream(byArray));
        this.infomation.copyArray(stringArray);
        return true;
    }

    public void setMainClass(String string) {
        this.infomation.add(MAIN_CLASS, string);
    }

    public void setCopyright(String string) {
        this.infomation.add(COPYRIGHT, string);
    }

    public void setProjectName(String string) {
        this.infomation.add(NAME, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((NameUpdataListener)enumeration.nextElement()).updataName(new NameUpdataEvent((Object)this, string));
        }
    }

    public void setOrg(String string) {
        this.infomation.add(ORGANIZATION, string);
    }

    public void setMaster(String string) {
        this.infomation.add(MASTER, string);
    }

    public void setComment(String string) {
        this.infomation.add(COMMENT, string);
    }

    public void setInfomation(String string, String string2) {
        if (!this.infomation.add(string, string2)) {
            this.infomation.change(string, string2);
        }
    }

    public String getInfomation(String string) {
        return (String)this.infomation.getContent(string);
    }

    public void setSaveFile(File file) {
        this.file = file;
    }

    public void addEditor(Editor editor) {
        editor.addInternalFrameListener(this.listener);
        this.newListener.addWindow(editor, this);
        editor.setBounds(this.newx, this.newy, 400, 300);
        this.newx += 40;
        this.newy += 40;
        this.editors.addElement(editor);
        this.dp.add(editor);
        editor.setVisible(true);
        this.addNode(editor);
        this.model.reload();
        this.jt.treeDidChange();
    }

    private void addNode(Editor editor) {
        String[] stringArray = null;
        stringArray = TextBuffer.cutString(editor.getDirectory(), "/");
        DefaultMutableTreeNode defaultMutableTreeNode = this.node;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && !stringArray[i].equals(""); ++i) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                enumeration = defaultMutableTreeNode.children();
                TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
                boolean bl = false;
                while (enumeration.hasMoreElements() && !bl) {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!stringArray[i].equals(defaultMutableTreeNode2.getUserObject())) continue;
                    defaultMutableTreeNode = defaultMutableTreeNode2;
                    bl = true;
                    break;
                }
                if (!bl) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringArray[i]);
                    defaultMutableTreeNode.add(defaultMutableTreeNode3);
                    defaultMutableTreeNode = defaultMutableTreeNode3;
                }
                editor.toFront();
            }
        }
        defaultMutableTreeNode2 = new FileNode(editor);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        editor.addEditorUpdataListener((EditorUpdataListener)((Object)defaultMutableTreeNode2));
    }

    public void removeEditor() {
        this.removeEditor(this.getSelectedEditor());
    }

    public void removeEditor(Editor editor) {
        int n = JOptionPane.showConfirmDialog(MainWindow.getMainWindow(), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.deleteFile1") + editor.getFileName() + ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.deleteFile2"), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.deleteFileTitle") + this.getProjectName(), 0, 2);
        if (n != 0) {
            return;
        }
        editor.removeInternalFrameListener(this.listener);
        editor.dispose();
        this.removeNode(editor, this.node);
        this.model.reload();
        this.jt.treeDidChange();
        this.editors.removeElement(editor);
        this.edited = true;
    }

    private boolean removeNode(Editor editor, TreeNode treeNode) {
        if (treeNode.isLeaf()) {
            FileNode fileNode;
            if (treeNode instanceof FileNode && (fileNode = (FileNode)treeNode).getProjectFile() == editor) {
                editor.removeEditorUpdataListener(fileNode);
                ((DefaultMutableTreeNode)fileNode.getParent()).remove(fileNode);
                return true;
            }
            return false;
        }
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            bl = this.removeNode(editor, (DefaultMutableTreeNode)enumeration.nextElement());
        }
        if (bl) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
            if (treeNode.isLeaf() && !defaultMutableTreeNode.isRoot()) {
                ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).remove(defaultMutableTreeNode);
            }
            return true;
        }
        return false;
    }

    public void addInternalFrame(JInternalFrame jInternalFrame) {
        this.dp.add(jInternalFrame);
    }

    public void removeIntarnalFrame(JInternalFrame jInternalFrame) {
        ((Container)this.dp).remove(jInternalFrame);
    }

    public void addFile() {
        FileDialog fileDialog = new FileDialog((Frame)MainWindow.getMainWindow(), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.addFile"), 0);
        fileDialog.show();
        if (fileDialog.getDirectory() != null) {
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            this.addFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addFile(File file) {
        block16: {
            InputStream inputStream;
            block15: {
                Object object;
                Object object2;
                inputStream = null;
                String string = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(46) + 1);
                FileType fileType = FileDataBase.getWithExtension(string);
                byte[] byArray = null;
                inputStream = new FileInputStream(file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                if (fileType.getMimeType().startsWith("text")) {
                    object2 = new String(byArray);
                    object = TextBuffer.replace((String)object2, "\r\n", "\n");
                    try {
                        byArray = ((String)object).getBytes("UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                object2 = byArray;
                object = fileType.getEditor();
                if (object == null) break block15;
                AddFileDialog addFileDialog = new AddFileDialog(file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(47) + 1));
                addFileDialog.show();
                addFileDialog.addWindowListener(new WindowAdapter((EditorComponent)object, addFileDialog, fileType, (byte[])object2){
                    private final /* synthetic */ EditorComponent val$comp;
                    private final /* synthetic */ AddFileDialog val$afd;
                    private final /* synthetic */ FileType val$type;
                    private final /* synthetic */ byte[] val$datas;
                    {
                        this.val$comp = editorComponent;
                        this.val$afd = addFileDialog;
                        this.val$type = fileType;
                        this.val$datas = byArray;
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        this.val$comp.init(this.val$afd.getMap(), this.val$type);
                        this.val$comp.readData(this.val$datas);
                        Project.this.addEditor(new Editor(this.val$comp));
                    }
                });
            }
            Object var12_13 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block16;
            }
            catch (Exception exception) {
                ErrorDialog.showError(exception);
            }
            break block16;
            {
                catch (IOException iOException) {
                    ErrorDialog.showError(iOException);
                    Object var12_14 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        ErrorDialog.showError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    ErrorDialog.showError(exception);
                }
                throw throwable;
            }
        }
        this.edited = true;
    }

    public ProjectFile[] getProjectFiles() {
        return this.getEditors();
    }

    protected Editor[] getEditors() {
        Editor[] editorArray = new Editor[this.editors.size()];
        int n = editorArray.length;
        for (int i = 0; i < n; ++i) {
            editorArray[i] = (Editor)this.editors.elementAt(i);
        }
        return editorArray;
    }

    public Editor getSelectedEditor() {
        JInternalFrame jInternalFrame = this.listener.getSelectedFrame();
        if (jInternalFrame == null) {
            return null;
        }
        if (jInternalFrame instanceof Editor) {
            return (Editor)jInternalFrame;
        }
        return null;
    }

    public void showFilePreference() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().showFilePreference();
        }
        this.edited = true;
    }

    public void showProjectPreference() {
        ProjectPreference projectPreference = new ProjectPreference(this);
        projectPreference.show();
        this.edited = true;
    }

    public void copy() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().copy();
        }
    }

    public void cut() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().cut();
        }
    }

    public void paste() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().paste();
        }
    }

    public void delete() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().delete();
        }
    }

    public void undo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().undo();
        }
    }

    public void redo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().redo();
        }
    }

    public void save() {
        if (this.file == null) {
            this.saveAs();
        }
        final File file = this.file;
        final Project project = this;
        new Thread(){

            public void run() {
                ProjectWriter.save(file, project);
                Project.this.edited = false;
            }
        }.start();
    }

    public void saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)MainWindow.getMainWindow(), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.saveProject"), 1);
        fileDialog.setFile(this.getProjectName() + ".gtb");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            this.save();
        }
    }

    public void close() {
        int n;
        ProjectFile[] projectFileArray = this.getProjectFiles();
        boolean bl = false;
        for (n = 0; n < projectFileArray.length; ++n) {
            if (!projectFileArray[n].isEdited()) continue;
            bl = true;
            break;
        }
        if ((bl || this.edited) && (n = JOptionPane.showConfirmDialog(MainWindow.getMainWindow(), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.notSaved"), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.closing") + this.getProjectName(), 0, 2)) == 0) {
            this.save();
        }
        for (n = 0; n < projectFileArray.length; ++n) {
            ((Editor)projectFileArray[n]).dispose();
        }
    }

    public void print() {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(MainWindow.getMainWindow(), this.getSelectedEditor().getFileName() + ResourceBundle.getBundle("jp/sourceforge/gtibuilder/project/Bundle").getString("Project.print"), null);
        if (printJob != null) {
            Component component = this.getSelectedEditor().getEditorComponent().getPrintComponent();
            Graphics graphics = printJob.getGraphics();
            component.print(graphics);
            graphics.dispose();
            printJob.end();
        }
    }

    public void addNameUpdataListener(NameUpdataListener nameUpdataListener) {
        if (this.listeners.indexOf(nameUpdataListener) != -1) {
            return;
        }
        this.listeners.addElement(nameUpdataListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (defaultMutableTreeNode instanceof FileNode && mouseEvent.getClickCount() == 2) {
            ((Editor)((FileNode)defaultMutableTreeNode).getProjectFile()).show();
            ((Editor)((FileNode)defaultMutableTreeNode).getProjectFile()).toFront();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class FileNode
    extends DefaultMutableTreeNode
    implements EditorUpdataListener {
        private ProjectFile file = null;
        private String directory = null;

        public FileNode(ProjectFile projectFile) {
            this.file = projectFile;
            this.setUserObject(projectFile.getFileName());
            this.directory = projectFile.getDirectory();
        }

        public ProjectFile getProjectFile() {
            return this.file;
        }

        public void updataEditor(EditorUpdataEvent editorUpdataEvent) {
            this.setUserObject(this.file.getFileName());
            if (editorUpdataEvent.getPackage() != this.directory) {
                Project.this.removeNode((Editor)this.file, Project.this.node);
                Project.this.addNode((Editor)this.file);
                Project.this.model.reload();
                Project.this.jt.treeDidChange();
            }
            Project.this.edited = true;
        }
    }

    class WindowListener
    implements InternalFrameListener {
        private JInternalFrame selectedFrame = null;

        WindowListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            this.selectedFrame = (JInternalFrame)internalFrameEvent.getSource();
            MainWindow.getMainWindow().setEditMenuEnabled(((Editor)this.selectedFrame).usingEditMenu());
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            if (this.selectedFrame == internalFrameEvent.getSource()) {
                this.selectedFrame = null;
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public JInternalFrame getSelectedFrame() {
            return this.selectedFrame;
        }
    }
}

