/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.Debug;

public class DebugWindow
extends JFrame {
    private static StringBuffer sb = new StringBuffer();
    private static Vector errors = new Vector();
    private static DebugWindow dw = null;
    private DefaultListModel pModel = new DefaultListModel();
    private DefaultListModel eModel = new DefaultListModel();
    private DefaultListModel wModel = new DefaultListModel();
    private DefaultListModel pModel2 = new DefaultListModel();
    private JTextArea aError;
    private JTextArea aOut;
    private JTextArea aProject;
    private JButton bProject;
    private JButton cOut;
    private JButton exitButton;
    private JButton gcButton;
    private JPanel iOut;
    private JSplitPane jSplitPane1;
    private JList lError;
    private JList lProject1;
    private JList lProject2;
    private JList lWindows;
    private JComboBox locale;
    private JButton mainWindow;
    private JPanel pjButtonPanel;
    private JScrollPane sOut;
    private JScrollPane scError;
    private JScrollPane scError2;
    private JScrollPane scProject1;
    private JScrollPane scProject2;
    private JScrollPane scProject3;
    private JScrollPane scWindows;
    private JSplitPane spError;
    private JSplitPane spProject;
    private JPanel tError;
    private JPanel tOut;
    private JPanel tProject;
    private JPanel tWindows;
    private JTabbedPane tab;
    private JToolBar toolbar;
    private JPanel wButtonPanel;
    private JButton windowReload;

    public DebugWindow() {
        this.initComponents();
        dw = this;
        this.setTitle("Debug Window");
        this.reloadText();
        this.reloadError();
        this.show();
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.gcButton = new JButton();
        this.exitButton = new JButton();
        this.mainWindow = new JButton();
        this.locale = new JComboBox();
        this.tab = new JTabbedPane();
        this.tOut = new JPanel();
        this.sOut = new JScrollPane();
        this.aOut = new JTextArea();
        this.iOut = new JPanel();
        this.cOut = new JButton();
        this.tError = new JPanel();
        this.spError = new JSplitPane();
        this.scError = new JScrollPane();
        this.lError = new JList();
        this.scError2 = new JScrollPane();
        this.aError = new JTextArea();
        this.tProject = new JPanel();
        this.spProject = new JSplitPane();
        this.scProject1 = new JScrollPane();
        this.lProject1 = new JList();
        this.jSplitPane1 = new JSplitPane();
        this.scProject2 = new JScrollPane();
        this.lProject2 = new JList();
        this.scProject3 = new JScrollPane();
        this.aProject = new JTextArea();
        this.pjButtonPanel = new JPanel();
        this.bProject = new JButton();
        this.tWindows = new JPanel();
        this.scWindows = new JScrollPane();
        this.lWindows = new JList();
        this.wButtonPanel = new JPanel();
        this.windowReload = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DebugWindow.this.exitForm(windowEvent);
            }
        });
        this.gcButton.setText("System.gc()");
        this.gcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugWindow.this.gcButton(actionEvent);
            }
        });
        this.toolbar.add(this.gcButton);
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugWindow.this.exit(actionEvent);
            }
        });
        this.toolbar.add(this.exitButton);
        this.mainWindow.setText("Main Window");
        this.mainWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugWindow.this.showMainWindow(actionEvent);
            }
        });
        this.toolbar.add(this.mainWindow);
        this.locale.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "Japanese"}));
        this.locale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugWindow.this.changeLocale(actionEvent);
            }
        });
        this.locale.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DebugWindow.this.setLocale(mouseEvent);
            }
        });
        this.toolbar.add(this.locale);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.tOut.setLayout(new BorderLayout());
        this.aOut.setEditable(false);
        this.sOut.setViewportView(this.aOut);
        this.tOut.add((Component)this.sOut, "Center");
        this.cOut.setText("Clear");
        this.cOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugWindow.this.cOutActionPerformed(actionEvent);
            }
        });
        this.iOut.add(this.cOut);
        this.tOut.add((Component)this.iOut, "South");
        this.tab.addTab("Output", this.tOut);
        this.tError.setLayout(new BorderLayout());
        this.spError.setDividerLocation(100);
        this.lError.setModel(this.eModel);
        this.lError.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DebugWindow.this.errorSelect(mouseEvent);
            }
        });
        this.scError.setViewportView(this.lError);
        this.spError.setLeftComponent(this.scError);
        this.aError.setEditable(false);
        this.scError2.setViewportView(this.aError);
        this.spError.setRightComponent(this.scError2);
        this.tError.add((Component)this.spError, "Center");
        this.tab.addTab("Errors", this.tError);
        this.tProject.setLayout(new BorderLayout());
        this.spProject.setDividerLocation(100);
        this.lProject1.setModel(this.pModel);
        this.lProject1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DebugWindow.this.projectSelect(mouseEvent);
            }
        });
        this.scProject1.setViewportView(this.lProject1);
        this.spProject.setLeftComponent(this.scProject1);
        this.jSplitPane1.setDividerLocation(70);
        this.jSplitPane1.setOrientation(0);
        this.lProject2.setModel(this.pModel2);
        this.lProject2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DebugWindow.this.selectProjectFile(mouseEvent);
            }
        });
        this.scProject2.setViewportView(this.lProject2);
        this.jSplitPane1.setRightComponent(this.scProject2);
        this.aProject.setEditable(false);
        this.scProject3.setViewportView(this.aProject);
        this.jSplitPane1.setLeftComponent(this.scProject3);
        this.spProject.setRightComponent(this.jSplitPane1);
        this.tProject.add((Component)this.spProject, "Center");
        this.bProject.setText("Reload");
        this.bProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugWindow.this.reloadProjects(actionEvent);
            }
        });
        this.pjButtonPanel.add(this.bProject);
        this.tProject.add((Component)this.pjButtonPanel, "South");
        this.tab.addTab("Projects", this.tProject);
        this.tWindows.setLayout(new BorderLayout());
        this.lWindows.setModel(this.wModel);
        this.scWindows.setViewportView(this.lWindows);
        this.tWindows.add((Component)this.scWindows, "Center");
        this.windowReload.setText("Reload");
        this.windowReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DebugWindow.this.reloadWindow(actionEvent);
            }
        });
        this.wButtonPanel.add(this.windowReload);
        this.tWindows.add((Component)this.wButtonPanel, "South");
        this.tab.addTab("Windows", this.tWindows);
        this.getContentPane().add((Component)this.tab, "Center");
        this.pack();
    }

    private void changeLocale(ActionEvent actionEvent) {
        int n = this.locale.getSelectedIndex();
        Locale locale = null;
        locale = n == 0 ? Locale.ENGLISH : Locale.JAPANESE;
        Locale.setDefault(locale);
        Debug.print(locale);
    }

    private void setLocale(MouseEvent mouseEvent) {
        int n = this.locale.getSelectedIndex();
        Locale locale = null;
        locale = n == 0 ? Locale.ENGLISH : Locale.JAPANESE;
        Locale.setDefault(locale);
        Debug.print(locale);
    }

    private void selectProjectFile(MouseEvent mouseEvent) {
        int n = this.lProject2.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        --n;
        int n2 = this.lProject1.getSelectedIndex();
        if (n2 == -1) {
            return;
        }
        Project project = MainWindow.getMainWindow().getProjectManager().getProjects()[n2];
        ProjectFile[] projectFileArray = project.getProjectFiles();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("File Name:" + projectFileArray[n].getFileName() + "\n");
        stringBuffer.append("Directory Name:" + projectFileArray[n].getDirectory() + "\n");
        stringBuffer.append("File Type:" + projectFileArray[n].getFileType() + "\n");
        stringBuffer.append("Edited:" + projectFileArray[n].isEdited() + "\n");
        this.aProject.setText(stringBuffer.toString());
    }

    private void cOutActionPerformed(ActionEvent actionEvent) {
        sb = new StringBuffer();
        this.reloadText();
    }

    private void showMainWindow(ActionEvent actionEvent) {
        MainWindow.getMainWindow().show();
    }

    private void projectSelect(MouseEvent mouseEvent) {
        int n = this.lProject1.getSelectedIndex();
        if (n == -1) {
            return;
        }
        Project project = MainWindow.getMainWindow().getProjectManager().getProjects()[n];
        this.pModel2.clear();
        this.pModel2.addElement("PROJECT NAME:" + project.getProjectName());
        ProjectFile[] projectFileArray = project.getProjectFiles();
        for (int i = 0; i < projectFileArray.length; ++i) {
            if (projectFileArray[i].getDirectory() != null) {
                this.pModel2.addElement("/" + projectFileArray[i].getDirectory() + "/" + projectFileArray[i].getFileName());
                continue;
            }
            this.pModel2.addElement("/" + projectFileArray[i].getFileName());
        }
    }

    private void reloadWindow(ActionEvent actionEvent) {
        int n;
        Frame[] frameArray = MainWindow.getMainWindow().getProjectManager().getWindowManager().getFrames();
        JInternalFrame[] jInternalFrameArray = MainWindow.getMainWindow().getProjectManager().getWindowManager().getInternalFrames();
        this.wModel.clear();
        this.wModel.addElement("-------java.awt.Frame");
        for (n = 0; n < frameArray.length; ++n) {
            this.wModel.addElement(frameArray[n].toString());
        }
        this.wModel.addElement("-------javax.swing.JInternalFrame");
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            this.wModel.addElement(jInternalFrameArray[n].toString());
        }
    }

    private void errorSelect(MouseEvent mouseEvent) {
        int n = this.lError.getSelectedIndex();
        if (n == -1) {
            return;
        }
        Throwable throwable = (Throwable)errors.elementAt(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.close();
        String string = new String(byteArrayOutputStream.toByteArray());
        this.aError.setText(string);
    }

    private void reloadProjects(ActionEvent actionEvent) {
        Project[] projectArray = MainWindow.getMainWindow().getProjectManager().getProjects();
        this.pModel.clear();
        this.pModel2.clear();
        if (projectArray == null) {
            return;
        }
        for (int i = 0; i < projectArray.length; ++i) {
            this.pModel.addElement(projectArray[i].getProjectName());
        }
    }

    private void exit(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void gcButton(ActionEvent actionEvent) {
        System.gc();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setState(1);
    }

    public static void addText(String string) {
        sb.append(string);
        if (dw != null) {
            dw.reloadText();
        }
    }

    public void reloadText() {
        this.aOut.setText(sb.toString());
    }

    public static void addThrowable(Throwable throwable) {
        errors.addElement(throwable);
        if (dw != null) {
            dw.reloadError();
        }
    }

    public void reloadError() {
        Enumeration enumeration = errors.elements();
        this.eModel.clear();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.eModel.addElement(e.toString());
        }
    }

    public static void reset() {
        dw.dispose();
        dw = null;
    }
}

