/*
copyright (c) 2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include <windows.h>


int
main (int   argc,
      char *argv[])
{
  DWORD dwExit = -1;
  HANDLE hFile;

  hFile = CreateFileA (argv[1], GENERIC_READ, FILE_SHARE_READ, NULL,
                                OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if (hFile != INVALID_HANDLE_VALUE)
    {
      DWORD dwSize;

      dwSize = GetFileSize (hFile, NULL);
      if (dwSize != 0xffffffff)
        {
          LPVOID lpMem;

          lpMem = HeapAlloc (GetProcessHeap (), 0, dwSize);
          if (lpMem)
            {
              DWORD dwRead;

              if (ReadFile (hFile, lpMem, dwSize, &dwRead, NULL)
                                                        && dwRead == dwSize)
                {
                  int i, j = 0;
                  CHAR c = ' ';
                  PROCESS_INFORMATION pi;
                  STARTUPINFOA si;

                  for (i = 0; ((LPSTR)lpMem)[i] != '\0'; i++)
                    {
                      if (((LPSTR)lpMem)[i] == '\n'
                                                || ((LPSTR)lpMem)[i] == '\r'
                                                || ((LPSTR)lpMem)[i] == '\t')
                        ((LPSTR)lpMem)[i] = ' ';
                      if (c != ' ' || ((LPSTR)lpMem)[i] != ' ')
                        {
                          ((LPSTR)lpMem)[j++] = ((LPSTR)lpMem)[i];
                          c = ((LPSTR)lpMem)[i];
                        }
                    }
                  ((LPSTR)lpMem)[c == ' ' && j > 0 ? j - 1 : j] = '\0';
                  si.cb = sizeof (STARTUPINFOA);
                  GetStartupInfoA (&si);
                  if (CreateProcessA (NULL, lpMem,
                                    NULL, NULL, TRUE, 0, NULL, NULL, &si, &pi))
                    {
                      if (CloseHandle (pi.hThread)
                                && WaitForSingleObject (pi.hProcess, INFINITE)
                                                            == WAIT_OBJECT_0)
                        GetExitCodeProcess (pi.hProcess, &dwExit);
                      if (!CloseHandle (pi.hProcess))
                        dwExit = -1;
                    }
                }
              if (!HeapFree (GetProcessHeap (), 0, lpMem))
                dwExit = -1;
            }
        }
      if (!CloseHandle (hFile))
        dwExit = -1;
    }
  return dwExit;
}
