/*
    disw32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "disw32.h"
#include "code.h"
#include "header.h"
#include "info.h"
#include "misc/peimage.h"


/*  ja:ヘルプを表示する
      fp,ファイルポインタ
    file,ファイル名                                                         */
static void
help (FILE        *fp,
      const gchar *file)
{
  g_fprintf (fp,
"disw32 "VERSION" ("BUILD_ENVIRONMENT")\n"
"copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org\n"
"\n"
"Usage: %s [option...] exefile [asmfile]\n"
"\n"
"      --analyse-proc     analyse procedure entrance\n"
"      --analyse-linear   analyse linear code\n"
"      --analyse-referer  analyse refered subroutine\n"
"      --analyse-data     analyse data block\n"
"  -a  --analyse-all      analyse linear code and refered subroutine\n"
"      --display-export   display export table\n"
"      --display-import   display import table\n"
"      --display-resource display resource directory\n"
"      --display-reloc    display relocation table\n"
"  -d  --display-all      display export, import, resource and relocation\n"
"\n", file);
}


int
main (int   argc,
      char *argv[])
{
  gboolean proc = FALSE, linear = FALSE, referer = FALSE, data = FALSE;
  gboolean export = FALSE, import = FALSE, resource = FALSE, reloc = FALSE;
  gchar *infile = NULL, *outfile = NULL;
  gint i, ret = 0;
  guint8 *image;
  FILE *fp;
  Dw32Info *info;

  /* ja:初期化 */
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /* ja:引数 */
  for (i = 1; i < argc; i++)
    if (g_ascii_strcasecmp (argv[i], "--analyse-proc") == 0
                    || g_ascii_strcasecmp (argv[i], "--analyze-proc") == 0)
      {
        proc = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "--analyse-linear") == 0
                    || g_ascii_strcasecmp (argv[i], "--analyze-linear") == 0)
      {
        linear = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "--analyse-referer") == 0
                    || g_ascii_strcasecmp (argv[i], "--analyze-referer") == 0)
      {
        referer = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "--analyse-data") == 0
                    || g_ascii_strcasecmp (argv[i], "--analyze-data") == 0)
      {
        data = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "-a") == 0
                    || g_ascii_strcasecmp (argv[i], "--analyse-all") == 0
                    || g_ascii_strcasecmp (argv[i], "--analyze-all") == 0)
      {
        linear = referer = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "--display-export") == 0)
      {
        export = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "--display-import") == 0)
      {
        import = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "--display-resource") == 0)
      {
        resource = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "--display-reloc") == 0)
      {
        reloc = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "-d") == 0
                        || g_ascii_strcasecmp (argv[i], "--display-all") == 0)
      {
        export = import = resource = reloc = TRUE;
      }
    else if (g_ascii_strcasecmp (argv[i], "-h") == 0
                                || g_ascii_strcasecmp (argv[i], "-?") == 0
                                || g_ascii_strcasecmp (argv[i], "--help") == 0)
      {
        help (stdout, argv[0]);
        return 0;
      }
    else if (!infile)
      {
        infile = argv[i];
      }
    else if (!outfile)
      {
        outfile = argv[i];
      }
    else
      break;
  if (!infile || i < argc)
    {
      help (stderr, argv[0]);
      return -1;
    }

  g_fprintf (stderr, PACKAGE" "VERSION" ("BUILD_ENVIRONMENT")\n\n");
  /* ja:読み込み */
  image = peimage_file_load (infile);
  if (!image)
    {
      g_fprintf (stderr, "\'%s\' infile error.\n", infile);
      return -1;
    }
  /* ja:逆アセンブル */
  info = dw32_info_create (image);
  dw32_header_parse (info);
  dw32_code_parse (info, proc, linear, referer, data);
  dw32_info_organize (info, export, import, resource, reloc);
  g_fprintf (stderr, "\n");
  /* ja:出力 */
  fp = outfile ? g_fopen (outfile, "wt") : stdout;
  if (fp)
    {
      dw32_info_disp (fp, info);
      if (outfile)
        ret = fclose (fp);
    }
  else
    {
      g_fprintf (stderr, "\'%s\' outfile error.\n", outfile);
      ret = -1;
    }
  dw32_info_free (info);
  g_free (image);
  return ret;
}
