/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __PROCESS_H__
#define __PROCESS_H__


#include "ia32.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:プロセス/スレッド関数群                                                  *
*                                                                             *
******************************************************************************/
/*  ja: スレッド作成
    process,プロセス構造体
        RET,スレッド構造体                                                  */
Ia32Thread *
ia32_create_thread (Ia32Process *process);


/*  ja: スレッド破棄
    thread,スレッド構造体
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
ia32_destroy_thread (Ia32Thread *thread);


/*  ja:PEファイルからプロセス作成
    argv,ファイル名
     RET,プロセス                                                           */
Ia32Process *
ia32_create_process_from_argv (gchar *argv[]);


/*  ja:メモリイメージからプロセス作成
     image,ファイル名
    length,サイズ
      base,ベースアドレス
     entry,開始アドレス
       RET,プロセス                                                         */
Ia32Process *
ia32_create_process_from_image (const guint8  *image,
                                const gsize    length,
                                const guint32  base,
                                const guint32  entry);


/*  ja:プロセス破棄
    process,プロセス構造体
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
ia32_destroy_process (Ia32Process *process);


G_END_DECLS


#endif /* __PROCESS_H__ */
