/*
copyright (c) 2007-2012 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef _DIRENT_H_
#define _DIRENT_H_


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define _dirent dirent
#define _DIR DIR
#define _opendir opendir
#define _readdir readdir
#define _closedir closedir
#define _rewinddir rewinddir
#define _telldir telldir
#define _seekdir seekdir
#define _wdirent wdirent
#define _WDIR WDIR
#define _wopendir wopendir
#define _wreaddir wreaddir
#define _wclosedir wclosedir
#define _wrewinddir wrewinddir
#define _wtelldir wtelldir
#define _wseekdir wseekdir
#define _tdirent tdirent
#define _TDIR TDIR
#define _topendir topendir
#define _treaddir treaddir
#define _tclosedir tclosedir
#define _trewinddir trewinddir
#define _ttelldir ttelldir
#define _tseekdir tseekdir
#ifdef UNICODE
# define tdirent wdirent
# define TDIR WDIR
# define topendir wopendir
# define treaddir wreaddir
# define tclosedir wclosedir
# define trewinddir wrewinddir
# define ttelldir wtelldir
# define tseekdir wseekdir
#else /* not UNICODE */
# define tdirent dirent
# define TDIR DIR
# define topendir opendir
# define treaddir readdir
# define tclosedir closedir
# define trewinddir rewinddir
# define ttelldir telldir
# define tseekdir seekdir
#endif /* not UNICODE */


typedef struct dirent
{
  long           d_ino;
  unsigned short d_reclen;
  unsigned short d_namlen;
  char           d_name[MAX_PATH];
} DIRENT;
typedef struct dir
{
  int           nStat;
  LPSTR         lpszPath;
  HANDLE        hFind;
  struct dirent dd_dir;
} DIR;


typedef struct wdirent
{
  long           d_ino;
  unsigned short d_reclen;
  unsigned short d_namlen;
  wchar_t        d_name[MAX_PATH];
} WDIRENT;
typedef struct wdir
{
  int            nStat;
  LPWSTR         lpszPath;
  HANDLE         hFind;
  struct wdirent dd_dir;
} WDIR;


DIR *opendir (const char *);
struct dirent *readdir (DIR *);
int closedir (DIR *);
void rewinddir (DIR *);
long telldir (DIR *);
void seekdir (DIR *, long);


WDIR *wopendir (const wchar_t *);
struct wdirent *wreaddir (WDIR *);
int wclosedir (WDIR *);
void wrewinddir (WDIR *);
long wtelldir (WDIR *);
void wseekdir (WDIR *, long);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _DIRENT_H_ */