/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBHASH_H__
#define __GLIBHASH_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* Hash Tables                                                                 *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef struct _GHashTable GHashTable;
typedef guint (*GHashFunc) (gconstpointer key);
typedef gboolean (*GEqualFunc) (gconstpointer a, gconstpointer b);
typedef void (*GHFunc) (gpointer key, gpointer value, gpointer user_data);
typedef gboolean (*GHRFunc) (gpointer key, gpointer value, gpointer user_data);


GHashTable *g_hash_table_new (GHashFunc hash_func, GEqualFunc key_equal_func);
GHashTable *g_hash_table_new_full (GHashFunc hash_func, GEqualFunc key_equal_func, GDestroyNotify key_destroy_func, GDestroyNotify value_destroy_func);
void g_hash_table_insert (GHashTable *hash_table, gpointer key, gpointer value);
guint g_hash_table_size (GHashTable *hash_table);
gpointer g_hash_table_lookup (GHashTable *hash_table, gconstpointer key);
void g_hash_table_foreach (GHashTable *hash_table, GHFunc func, gpointer user_data);
gboolean g_hash_table_remove (GHashTable *hash_table, gconstpointer key);
guint g_hash_table_foreach_remove (GHashTable *hash_table, GHRFunc func, gpointer user_data);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,14,0)
GList *g_hash_table_get_keys (GHashTable *hash_table);
GList *g_hash_table_get_values (GHashTable *hash_table);
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
#ifdef USE_GTK_EMULATE
void g_hash_table_destroy (GHashTable *hash_table);
gboolean g_direct_equal (gconstpointer v1, gconstpointer v2);
guint g_direct_hash (gconstpointer v);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,22,0)
gboolean g_int64_equal (gconstpointer v1, gconstpointer v2);
guint g_int64_hash (gconstpointer v);
gboolean g_double_equal (gconstpointer v1, gconstpointer v2);
guint g_double_hash (gconstpointer v);
#endif /* not GLIB_CHECK_VERSION(2,22,0) */
#ifdef USE_GTK_EMULATE
gboolean g_str_equal (gconstpointer v1, gconstpointer v2);
guint g_str_hash (gconstpointer v);
#endif /* USE_GTK_EMULATE */


G_END_DECLS


#endif /* __GLIBHASH_H__ */
