/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __SAVE_H__
#define __SAVE_H__


#include "ia32.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:保存関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:プロセス保存
    process,プロセス構造体
    dynamic,TRUE:すべてのメモリを保存,FALSE:プロセス生成モジュールのみ
     import,TRUE:インポートテーブル作成,FALSE:なし
      bytes,ファイルサイズ(NULL:取得しない)
        RET,PEイメージ,NULL:エラー                                          */
guint8 *
ia32_save_process (Ia32Process    *process,
                   const gboolean  dynamic,
                   const gboolean  import,
                   gsize          *bytes);


G_END_DECLS


#endif /* __SAVE_H__ */
