using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Globalization;
using GustFront;

public class MathUtil : IHasCommand
{
    private static Random rnd = new Random();

    public void SetTarget(ScriptEngine obj)
    {
    }

    public static ScriptValue cmdGetRandom(ScriptValue[] @params)
    {
        if (@params.Length == 0) {
            return rnd.NextDouble();
        } else {
            return rnd.Next(@params[0].AsInt32(), @params[1].AsInt32());
        }
    }

    public static ScriptValue cmdResetRandom(ScriptValue[] @params)
    {
        if (@params.Length == 0) {
            rnd = new Random();
        } else {
            rnd = new Random(@params[0].AsInt32());
        }
        return null;
    }

    public static ScriptValue cmdTestBit(ScriptValue[] @params)
    {
        object v1 = @params[0].Instance;
        object v2 = @params[1].Instance;
        if (v1 is long || v2 is long) {
            return (Convert.ToInt64(v1) & Convert.ToInt64(v2)) != 0L;
        } else if (v1 is int || v2 is int) {
            return (Convert.ToInt32(v1) & Convert.ToInt32(v2)) != 0;
        } else if (v1 is short || v2 is short) {
            return (Convert.ToInt16(v1) & Convert.ToInt16(v2)) != 0;
        } else if (v1 is byte || v2 is byte) {
            return (Convert.ToByte(v1) & Convert.ToByte(v2)) != 0;
        } else {
            throw new Exception("T|[gȂlłB");
        }
    }

    public static ScriptValue cmdSetBit(ScriptValue[] @params)
    {
        object v1 = @params[0].Instance;
        object v2 = @params[1].Instance;
        if (v1 is long || v2 is long) {
            return Convert.ToInt64(v1) | Convert.ToInt64(v2);
        } else if (v1 is int || v2 is int) {
            return Convert.ToInt32(v1) | Convert.ToInt32(v2);
        } else if (v1 is short || v2 is short) {
            return Convert.ToInt16(v1) | Convert.ToInt16(v2);
        } else if (v1 is byte || v2 is byte) {
            return Convert.ToByte(v1) | Convert.ToByte(v2);
        } else {
            throw new Exception("T|[gȂlłB");
        }
    }

    public static ScriptValue cmdResetBit(ScriptValue[] @params)
    {
        object v1 = @params[0].Instance;
        object v2 = @params[1].Instance;
        if (v1 is long || v2 is long) {
            return Convert.ToInt64(v1) & ~Convert.ToInt64(v2);
        } else if (v1 is int || v2 is int) {
            return Convert.ToInt32(v1) & ~Convert.ToInt32(v2);
        } else if (v1 is short || v2 is short) {
            return Convert.ToInt16(v1) & ~Convert.ToInt16(v2);
        } else if (v1 is byte || v2 is byte) {
            return Convert.ToByte(v1) & ~Convert.ToByte(v2);
        } else {
            throw new Exception("T|[gȂlłB");
        }
    }

    public static ScriptValue cmdIsNaN(ScriptValue[] @params)
    {
        return Double.IsNaN(@params[0].AsDouble());
    }

    public static ScriptValue cmdIsPositiveInfinity(ScriptValue[] @params)
    {
        return Double.IsPositiveInfinity(@params[0].AsDouble());
    }

    public static ScriptValue cmdIsNegativeInfinity(ScriptValue[] @params)
    {
        return Double.IsNegativeInfinity(@params[0].AsDouble());
    }

    private static ScriptValue cmdE(ScriptValue[] @params)
    {
        return Math.E;
    }

    private static ScriptValue cmdPI(ScriptValue[] @params)
    {
        return Math.PI;
    }

    private static ScriptValue cmdAbs(ScriptValue[] @params)
    {
        object v = @params[0].Instance;
        if (v is byte) return (byte)v;
        if (v is short) return Math.Abs((short)v);
        if (v is int) return Math.Abs((int)v);
        if (v is long) return Math.Abs((long)v);
        if (v is decimal) return Math.Abs((decimal)v);
        if (v is float) return Math.Abs((float)v);
        return Math.Abs(@params[0].AsDouble());
    }

    private static ScriptValue cmdAcos(ScriptValue[] @params)
    {
        return Math.Acos(@params[0].AsDouble());
    }

    private static ScriptValue cmdAsin(ScriptValue[] @params)
    {
        return Math.Asin(@params[0].AsDouble());
    }

    private static ScriptValue cmdAtan(ScriptValue[] @params)
    {
        return Math.Atan(@params[0].AsDouble());
    }

    private static ScriptValue cmdAtan2(ScriptValue[] @params)
    {
        return Math.Atan2(@params[0].AsDouble(), @params[1].AsDouble());
    }

    private static ScriptValue cmdBigMul(ScriptValue[] @params)
    {
        return Math.BigMul(@params[0].AsInt32(), @params[1].AsInt32());
    }

    private static ScriptValue cmdCeiling(ScriptValue[] @params)
    {
        object v = @params[0].Instance;
        if (v is decimal) return Math.Ceiling((decimal)v);
        return Math.Ceiling(@params[0].AsDouble());
    }

    private static ScriptValue cmdCos(ScriptValue[] @params)
    {
        return Math.Cos(@params[0].AsDouble());
    }

    private static ScriptValue cmdCosh(ScriptValue[] @params)
    {
        return Math.Cosh(@params[0].AsDouble());
    }

    private static ScriptValue cmdDivRem(ScriptValue[] @params)
    {
        object v1 = @params[0].Instance;
        object v2 = @params[1].Instance;
        if ((v1 is long || v1 is int || v1 is short || v1 is byte) &&
            (v2 is long || v2 is int || v2 is short || v2 is byte)) {
            if (v1 is long || v2 is long) {
                long result = 0L;
                long ret = Math.DivRem(Convert.ToInt64(v1), Convert.ToInt64(v2), out result);
                if (@params.Length == 3 && ScriptEngine.IsVarRef(@params[2])) {
                    ScriptEngine.SetToVariable(@params[2], result);
                }
                return ret;
            } else {
                int result = 0;
                int ret = Math.DivRem(Convert.ToInt32(v1), Convert.ToInt32(v2), out result);
                if (@params.Length == 3 && ScriptEngine.IsVarRef(@params[2])) {
                    ScriptEngine.SetToVariable(@params[2], result);
                }
                return ret;
            }
        } else {
            throw new Exception("KvłB");
        }
    }

    private static ScriptValue cmdExp(ScriptValue[] @params)
    {
        return Math.Exp(@params[0].AsDouble());
    }

    private static ScriptValue cmdFloor(ScriptValue[] @params)
    {
        object v = @params[0].Instance;
        if (v is decimal) return Math.Floor((decimal)v);
        return Math.Floor(@params[0].AsDouble());
    }

    private static ScriptValue cmdIEEERemainder(ScriptValue[] @params)
    {
        return Math.IEEERemainder(@params[0].AsDouble(), @params[1].AsDouble());
    }

    private static ScriptValue cmdLog(ScriptValue[] @params)
    {
        if (@params.Length == 1) return Math.Log(@params[0].AsDouble());
        return Math.Log(@params[0].AsDouble(), @params[1].AsDouble());
    }

    private static ScriptValue cmdLog10(ScriptValue[] @params)
    {
        return Math.Log10(@params[0].AsDouble());
    }

    private static ScriptValue cmdMax(ScriptValue[] @params)
    {
        object v1 = @params[0].Instance;
        object v2 = @params[1].Instance;
        if (v1 is double || v2 is double) {
            return Math.Max(Convert.ToDouble(v1) , Convert.ToDouble(v2));
        } else if (v1 is float || v2 is float) {
            return Math.Max(Convert.ToSingle(v1), Convert.ToSingle(v2));
        } else if (v1 is decimal || v2 is decimal) {
            return Math.Max(Convert.ToDecimal(v1), Convert.ToDecimal(v2));
        } else if (v1 is long || v2 is long) {
            return Math.Max(Convert.ToInt64(v1), Convert.ToInt64(v2));
        } else if (v1 is int || v2 is int) {
            return Math.Max(Convert.ToInt32(v1), Convert.ToInt32(v2));
        } else if (v1 is short || v2 is short) {
            return Math.Max(Convert.ToInt16(v1), Convert.ToInt16(v2));
        } else if (v1 is byte || v2 is byte) {
            return Math.Max(Convert.ToByte(v1), Convert.ToByte(v2));
        } else {
            throw new Exception("T|[gȂlłB");
        }
    }

    private static ScriptValue cmdMin(ScriptValue[] @params)
    {
        object v1 = @params[0].Instance;
        object v2 = @params[1].Instance;
        if (v1 is double || v2 is double) {
            return Math.Min(Convert.ToDouble(v1), Convert.ToDouble(v2));
        } else if (v1 is float || v2 is float) {
            return Math.Min(Convert.ToSingle(v1), Convert.ToSingle(v2));
        } else if (v1 is decimal || v2 is decimal) {
            return Math.Min(Convert.ToDecimal(v1), Convert.ToDecimal(v2));
        } else if (v1 is long || v2 is long) {
            return Math.Min(Convert.ToInt64(v1), Convert.ToInt64(v2));
        } else if (v1 is int || v2 is int) {
            return Math.Min(Convert.ToInt32(v1), Convert.ToInt32(v2));
        } else if (v1 is short || v2 is short) {
            return Math.Min(Convert.ToInt16(v1), Convert.ToInt16(v2));
        } else if (v1 is byte || v2 is byte) {
            return Math.Min(Convert.ToByte(v1), Convert.ToByte(v2));
        } else {
            throw new Exception("T|[gȂlłB");
        }
    }

    private static ScriptValue cmdPow(ScriptValue[] @params)
    {
        return Math.Pow(@params[0].AsDouble(), @params[1].AsDouble());
    }

    private static ScriptValue cmdRound(ScriptValue[] @params)
    {
        object v = @params[0].Instance;
        if (v is decimal) {
            if (@params.Length == 1) {
                return Math.Round((decimal)v);
            } else if (@params.Length == 2) {
                return Math.Round((decimal)v, @params[1].AsInt32());
            } else {
                return Math.Round((decimal)v, @params[1].AsInt32(),
                    (@params[2].AsBoolean()) ? MidpointRounding.AwayFromZero : MidpointRounding.ToEven);
            }
        } else {
            if (@params.Length == 1) {
                return Math.Round(@params[0].AsDouble());
            } else if (@params.Length == 2) {
                return Math.Round(@params[0].AsDouble(), @params[1].AsInt32());
            } else {
                return Math.Round(@params[0].AsDouble(), @params[1].AsInt32(),
                    (@params[2].AsBoolean()) ? MidpointRounding.AwayFromZero : MidpointRounding.ToEven);
            }
        }
    }

    private static ScriptValue cmdSign(ScriptValue[] @params)
    {
        object v = @params[0].Instance;
        if (v is byte) return ((byte)v > 0) ? 1 : 0;
        if (v is short) return Math.Sign((short)v);
        if (v is int) return Math.Sign((int)v);
        if (v is long) return Math.Sign((long)v);
        if (v is decimal) return Math.Sign((decimal)v);
        if (v is float) return Math.Sign((float)v);
        return Math.Abs(@params[0].AsDouble());
    }

    private static ScriptValue cmdSin(ScriptValue[] @params)
    {
        return Math.Sin(@params[0].AsDouble());
    }

    private static ScriptValue cmdSinh(ScriptValue[] @params)
    {
        return Math.Sinh(@params[0].AsDouble());
    }

    private static ScriptValue cmdSqrt(ScriptValue[] @params)
    {
        return Math.Sqrt(@params[0].AsDouble());
    }

    private static ScriptValue cmdTan(ScriptValue[] @params)
    {
        return Math.Tan(@params[0].AsDouble());
    }

    private static ScriptValue cmdTanh(ScriptValue[] @params)
    {
        return Math.Tanh(@params[0].AsDouble());
    }

    private static ScriptValue cmdTruncate(ScriptValue[] @params)
    {
        object v = @params[0].Instance;
        if (v is decimal) return Math.Truncate((decimal)v);
        return Math.Truncate(@params[0].AsDouble());
    }

    public IDictionary<string, CommandImpl> GetCommandMap()
    {
        Dictionary<string, CommandImpl> dic = new Dictionary<string, CommandImpl>();

        dic.Add("GetRandom", cmdGetRandom);
        dic.Add("ResetRandom", cmdResetRandom);
        dic.Add("TestBit", cmdTestBit);
        dic.Add("SetBit", cmdSetBit);
        dic.Add("ResetBit", cmdResetBit);
        dic.Add("IsNaN", cmdIsNaN);
        dic.Add("IsPositiveInfinity", cmdIsPositiveInfinity);
        dic.Add("IsNegativeInfinity", cmdIsNegativeInfinity);
        dic.Add("E", cmdE);
        dic.Add("PI", cmdPI);
        dic.Add("Abs", cmdAbs);
        dic.Add("Acos", cmdAcos);
        dic.Add("Asin", cmdAsin);
        dic.Add("Atan", cmdAtan);
        dic.Add("Atan2", cmdAtan2);
        dic.Add("BigMul", cmdBigMul);
        dic.Add("Ceiling", cmdCeiling);
        dic.Add("Cos", cmdCos);
        dic.Add("Cosh", cmdCosh);
        dic.Add("DivRem", cmdDivRem);
        dic.Add("Exp", cmdExp);
        dic.Add("Floor", cmdFloor);
        dic.Add("IEEERemainder", cmdIEEERemainder);
        dic.Add("Log", cmdLog);
        dic.Add("Log10", cmdLog10);
        dic.Add("Max", cmdMax);
        dic.Add("Min", cmdMin);
        dic.Add("Pow", cmdPow);
        dic.Add("Round", cmdRound);
        dic.Add("Sign", cmdSign);
        dic.Add("Sin", cmdSin);
        dic.Add("Sinh", cmdSinh);
        dic.Add("Sqrt", cmdSqrt);
        dic.Add("Tan", cmdTan);
        dic.Add("Tanh", cmdTanh);
        dic.Add("Truncate", cmdTruncate);

        return dic;
    }
}

public class StringUtil : IHasCommand
{
    public void SetTarget(ScriptEngine obj)
    {
    }

    private static ScriptValue cmdLen(ScriptValue[] @params)
    {
        return (new StringInfo(@params[0].AsString())).LengthInTextElements;
    }

    public static ScriptValue cmdAsc(ScriptValue[] @params)
    {
        return (int)@params[0].AsString()[0];
    }

    public static ScriptValue cmdChr(ScriptValue[] @params)
    {
        return ((char)@params[0].AsInt32()).ToString();
    }

    public static ScriptValue cmdCompare(ScriptValue[] @params)
    {
        if (@params.Length == 2) {
            return String.Compare(@params[0].AsString(), @params[1].AsString(), 
                false, CultureInfo.InvariantCulture);
        } else if (@params.Length == 3) {
            return String.Compare(@params[0].AsString(), @params[1].AsString(),
                @params[2].AsBoolean(), CultureInfo.InvariantCulture);
        } else {
            string strA = (new StringInfo(@params[0].AsString())).SubstringByTextElements(@params[1].AsInt32() - 1);
            string strB = (new StringInfo(@params[2].AsString())).SubstringByTextElements(@params[3].AsInt32() - 1);
            int max_length = @params[4].AsInt32();
            if (strA.Length >= max_length) strA = (new StringInfo(strA)).SubstringByTextElements(0, max_length);
            if (strB.Length >= max_length) strB = (new StringInfo(strB)).SubstringByTextElements(0, max_length);
            if (@params.Length == 5) {
                return String.Compare(strA, 0, strB, 0, max_length, 
                    false, CultureInfo.InvariantCulture);
            } else {
                return String.Compare(strA, 0, strB, 0, max_length,
                    @params[5].AsBoolean(), CultureInfo.InvariantCulture);
            }
        }
    }

    public static ScriptValue cmdStartWith(ScriptValue[] @params)
    {
        StringInfo si = new StringInfo(@params[0].AsString());
        if (si.LengthInTextElements > 0) {
            string fs = si.SubstringByTextElements(0, 1);
            if (@params.Length == 3 && @params[2].AsBoolean()) {
                return fs.Equals(@params[1].AsString(), StringComparison.InvariantCulture);
            } else {
                return fs.Equals(@params[1].AsString(), StringComparison.InvariantCultureIgnoreCase);
            }
        } else {
            return @params[1].AsString().Length == 0;
        }
    }

    public static ScriptValue cmdEndWith(ScriptValue[] @params)
    {
        StringInfo si = new StringInfo(@params[0].AsString());
        if (si.LengthInTextElements > 0) {
            string fs = si.SubstringByTextElements(si.LengthInTextElements - 1, 1);
            if (@params.Length == 3 && @params[2].AsBoolean()) {
                return fs.Equals(@params[1].AsString(), StringComparison.InvariantCulture);
            } else {
                return fs.Equals(@params[1].AsString(), StringComparison.InvariantCultureIgnoreCase);
            }
        } else {
            return @params[1].AsString().Length == 0;
        }
    }

    public static ScriptValue cmdIndexOf(ScriptValue[] @params)
    {
        TextElementEnumerator te_enum = StringInfo.GetTextElementEnumerator(@params[0].AsString());
        string s = @params[1].AsString();
        int startIndex = (@params.Length >= 3) ? @params[2].AsInt32() - 1 : 0;
        int teCount = (@params.Length >= 4) ? @params[3].AsInt32() : (new StringInfo(@params[0].AsString())).LengthInTextElements;
        StringComparison sc = StringComparison.InvariantCulture;
        if (@params.Length == 5 && @params[4].AsBoolean()) sc = StringComparison.InvariantCultureIgnoreCase;

        if (teCount > 0) {
            while (te_enum.MoveNext()) {
                if (te_enum.ElementIndex >= startIndex) {
                    if (te_enum.GetTextElement().Equals(s, sc)) return te_enum.ElementIndex + 1;
                    if (--teCount == 0) break;
                }
            }
        }
        return 0;
    }

    public static ScriptValue cmdLastIndexOf(ScriptValue[] @params)
    {
        TextElementEnumerator te_enum = StringInfo.GetTextElementEnumerator(@params[0].AsString());
        string s = @params[1].AsString();
        int startIndex = (@params.Length >= 3) ? @params[2].AsInt32() - 1 : 0;
        int teCount = (@params.Length >= 4) ? @params[3].AsInt32() : (new StringInfo(@params[0].AsString())).LengthInTextElements;
        StringComparison sc = StringComparison.InvariantCulture;
        if (@params.Length == 5 && @params[4].AsBoolean()) sc = StringComparison.InvariantCultureIgnoreCase;

        int last_index = -1;
        if (teCount > 0) {
            while (te_enum.MoveNext()) {
                if (te_enum.ElementIndex >= startIndex) {
                    if (te_enum.GetTextElement().Equals(s, sc)) last_index = te_enum.ElementIndex;
                    if (--teCount == 0) break;
                }
            }
        }
        return last_index + 1;
    }

    private static ScriptValue cmdSubstring(ScriptValue[] @params)
    {
        StringInfo si = new StringInfo(@params[0].AsString());
        if (@params.Length == 2) {
            return si.SubstringByTextElements(@params[1].AsInt32() - 1);
        } else {
            return si.SubstringByTextElements(@params[1].AsInt32() - 1, @params[2].AsInt32());
        }
    }

    private static ScriptValue cmdConcat(ScriptValue[] @params)
    {
        IList strs = (IList)@params[0].Instance;
        if (@params.Length == 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < strs.Count; i++) {
                sb.Append(Convert.ToString(strs[i]));
            }
            return sb.ToString();
        } else {
            string joint = @params[1].AsString();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < strs.Count - 1; i++) {
                sb.Append(Convert.ToString(strs[i]));
                sb.Append(joint);
            }
            if (strs.Count > 0) sb.Append(Convert.ToString(strs[strs.Count - 1]));
            return sb.ToString();
        }
    }

    private static ScriptValue cmdDuplicate(ScriptValue[] @params)
    {
        string source = @params[0].AsString();
        int number = @params[1].AsInt32();
        StringBuilder sb = new StringBuilder(source.Length * number);
        for (int i = 0; i < number; i++) {
            sb.Append(source);
        }
        return sb.ToString();
    }

    public static ScriptValue cmdToUpper(ScriptValue[] @params)
    {
        return @params[0].AsString().ToUpperInvariant();
    }

    public static ScriptValue cmdToLower(ScriptValue[] @params)
    {
        return @params[0].AsString().ToLowerInvariant();
    }

    private static ScriptValue cmdMatch(ScriptValue[] @params)
    {
        string input = @params[0].AsString();
        string pattern = @params[1].AsString();
        RegexOptions ro = RegexOptions.CultureInvariant;

        if (@params.Length == 3 && @params[2].AsBoolean())
            ro |= RegexOptions.IgnoreCase;

        Match m = Regex.Match(input, pattern, ro);
        if (m.Success) {
            IList result = CollectionUtil.CreateStdList(m.Groups.Count - 1);
            for (int i = 1; i < m.Groups.Count; i++) {
                result.Add(m.Groups[i].Value);
            }
            return new ScriptValue(result);
        } else {
            return null;
        }
    }

    public IDictionary<string, CommandImpl> GetCommandMap()
    {
        Dictionary<string, CommandImpl> dic = new Dictionary<string, CommandImpl>();

        dic.Add("Len", cmdLen);
        dic.Add("Asc", cmdAsc);
        dic.Add("Chr", cmdChr);
        dic.Add("Compare", cmdCompare);
        dic.Add("StartWith", cmdStartWith);
        dic.Add("EndWith", cmdEndWith);
        dic.Add("IndexOf", cmdIndexOf);
        dic.Add("LastIndexOf", cmdLastIndexOf);
        dic.Add("Substring", cmdSubstring);
        dic.Add("Concat", cmdConcat);
        dic.Add("Duplicate", cmdDuplicate);
        dic.Add("ToUpper", cmdToUpper);
        dic.Add("ToLower", cmdToLower);
        dic.Add("Match", cmdMatch);

        return dic;
    }
}
