/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

var Config			= h5glib.Config;
var Debug			= h5glib.Debug;
var Command			= h5glib.Command;
var ListElement		= h5glib.ListElement;
var Task			= h5glib.Task;
var Message			= h5glib.Message;
var MessageHandler	= h5glib.MessageHandler;
var Scene			= h5glib.Scene;

var SCENE_NAME	= "battle";

var USAGE_HTML	= "<p>[↑][↓]: 選択 [Enter]: 実行</p>";

/**
 * MessageType
 */
var MessageType =
{
	NONE			: 0,
	RET_PREV_SCENE	: 1
};

/**
 * BattleStatus
 */
var BattleStatus =
{
	NONE	: 0,
	OFFENSE	: 1,
	END		: 2,
	ESCAPE	: 3
};

/**
 * BattleTask
 */
var BattleTask = function( scene )
{
	this.updateFunc	=
	[
		this.updateNone,
		this.updateOffense,
		this.updateEnd,
		this.updateEscape
	];

	this.command	= scene.input;
	this.player		= null;
	this.enemy		= null;

	this.lag		= this.LAG_VAL;
	this.text		= "";
	this.select		= 0;
};
BattleTask.prototype = new Task();

(function( pt )
{
	pt.color =
	{
		rect		: "rgb(32, 178, 170)",
		rectFocus	: "rgb(255, 20, 147)",
		border		: "rgb(255, 255, 255)",
		text		: "rgb(255, 255, 255)"
	};
	pt.font =
	{
		large		: "bold 18px 'ＭＳ Ｐゴシック'",
		small		: "bold 14px 'ＭＳ Ｐゴシック'"
	};
	pt.TB_OFFENSE	= "戦う";
	pt.TB_ESCAPE	= "逃げる";
	pt.TI_HP		= "HP: ";
	pt.TI_MP		= "MP: ";
	pt.TM_APPEAR	= "があらわれた。";
	pt.TM_READY		= "は様子を見ている。";
	pt.TM_OFFENSE	= "の攻撃。";
	pt.TM_DAMAGE	= "はダメージを受けた。";
	pt.TM_ESCAPE	= "は逃げ出した。";
	pt.TM_WIN		= "に勝利した。";
	pt.TM_LOSE		= "は死んでしまった。";

	pt.LAG_VAL		= 8;
	pt.SELECTIONS	= 2;

	/**
	 * 
	 */
	pt.setStatus = function( status )
	{
		this.status	= status;
		this.update	= this.updateFunc[ this.status ];
	};
	/**
	 * 
	 */
	pt.reset = function( scene, player, enemy )
	{
		this.player	= player;
		this.enemy	= enemy;

		this.setStatus( BattleStatus.NONE );
		this.select	= 0;
		this.text	= this.enemy.name + this.TM_APPEAR;
	};

	/**
	 * 
	 */
	pt.updateNone = function( scene )
	{
		var upd = false;

		if ( this.lag > 0 )
		{
			this.lag--;
		}
		else
		{
			if ( this.command.tbl.up )
			{
				this.select--;
				if ( this.select < 0 )
				{
					this.select = this.SELECTIONS - 1;
				}
				this.lag = this.LAG_VAL;
				upd = true;
			}
			else if ( this.command.tbl.down )
			{
				this.select++;
				if ( this.select >= this.SELECTIONS )
				{
					this.select = 0;
				}
				this.lag = this.LAG_VAL;
				upd = true;
			}
			else if ( this.command.tbl.enter )
			{
				switch ( this.select )
				{
				case 0:
					this.setStatus( BattleStatus.OFFENSE );
					this.lag = this.LAG_VAL * 4;
					break;
				case 1:
					this.setStatus( BattleStatus.ESCAPE );
					this.lag = this.LAG_VAL;
					break;
				}
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.updateOffense = function( scene )
	{
		var upd = false;

		var resource = scene.resource;

		if ( this.lag > 0 )
		{
			// start
			if ( this.lag == this.LAG_VAL * 4 )
			{
				resource.shootSound.play();
				this.text	= this.player.name + this.TM_OFFENSE;
				upd = true;
			}
			// judge
			if ( this.lag == this.LAG_VAL * 2 )
			{
				var r = Math.random();
				if ( r < 0.5 )
				{
					this.player.prop.hp -= 30;
					this.text	= this.player.name + this.TM_DAMAGE;
				}
				else
				{
					this.enemy.prop.hp -= 30;
					this.text	= this.enemy.name + this.TM_DAMAGE;
				}
				upd = true;
			}
			this.lag--;
		}
		// result
		else
		{
			if ( this.player.prop.hp <= 0 || this.enemy.prop.hp <= 0 )
			{
				this.setStatus( BattleStatus.END );
				this.lag = this.LAG_VAL;
			}
			else
			{
				this.setStatus( BattleStatus.NONE );
				this.text	= this.enemy.name + this.TM_READY;
				upd = true;
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.updateEnd = function( scene )
	{
		var upd = false;

		var msgManager	= scene.msgManager;

		if ( this.lag > 0 )
		{
			// judge
			if ( this.lag == this.LAG_VAL )
			{
				this.select = 1;
				if ( this.player.prop.hp > 0 )
				{
					this.text	= this.enemy.name + this.TM_WIN;
				}
				else
				{
					this.text	= this.player.name + this.TM_LOSE;
				}
				upd = true;
			}
			this.lag--;
		}
		else
		{
			if ( this.command.tbl.enter )
			{
				var message	= new Message( MessageType.RET_PREV_SCENE );
				msgManager.postBreakMessage( message );
				upd = true;
			}
			upd = true;
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.updateEscape = function( scene )
	{
		var upd = false;

		var msgManager	= scene.msgManager;

		if ( this.lag > 0 )
		{
			// judge
			if ( this.lag == this.LAG_VAL )
			{
				this.text	= this.player.name + this.TM_ESCAPE;
				upd = true;
			}
			this.lag--;
		}
		else
		{
			var message	= new Message( MessageType.RET_PREV_SCENE );
			msgManager.postBreakMessage( message );
			upd = true;
		}
		return upd;
	};

	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var canvas		= scene.canvas;
		var context		= scene.context;
		var resource	= scene.resource;
		var image;

		context.clearRect( 0, 0, canvas.width, canvas.height );

		// monster
		image = resource.monsterImages[ this.enemy.type ];
		var dx = canvas.width  / 2 - image.width  / 2;
		var dy = canvas.height / 4 - image.height / 2;
		context.drawImage(
			image,
			0,				// sx
			0,				// sy
			image.width,	// sw
			image.height,	// sh
			dx,				// dx
			dy,				// dy
			image.width,	// dw
			image.height	// dh
		);

		context.save();

		// text
		var tx	= 10;
		var ty	= canvas.height / 2;
		var tw	= canvas.width - tx * 2;
		var th	= 50;
		this.drawRect( context, tx, ty, tw, th, this.color.rect );
		context.font		= this.font.large;
		context.fillStyle	= this.color.text;
		context.fillText( this.text, tx + 10, ty + 25 );

		// hp, mp
		tx	= 10;
		ty	= canvas.height / 2 + 55;
		tw	= 150;
		th	= canvas.height - ty - 10;
		this.drawRect( context, tx, ty, tw, th, this.color.rect );
		context.font		= this.font.small;
		context.fillStyle	= this.color.text;
		context.fillText( this.TI_HP + this.player.prop.hp, tx + 10, ty + 22 );
		context.fillText( this.TI_MP + this.player.prop.mp, tx + 10, ty + 42 );

		// button
		var color;
		color	= ( this.select == 0 ) ? this.color.rectFocus : this.color.rect;
		tx		= tx + tw + 10;
		tw		= canvas.width - tx - 10;
		th		= 40;
		this.drawRect( context, tx, ty, tw, th, color );
		context.font		= this.font.small;
		context.fillStyle	= this.color.text;
		context.fillText( this.TB_OFFENSE, tx + 10, ty + 22 );

		color	= ( this.select == 1 ) ? this.color.rectFocus : this.color.rect;
		tx		= 170;
		ty		= ty + th + 5;
		th		= 40;
		this.drawRect( context, tx, ty, tw, th, color );
		context.font		= this.font.small;
		context.fillStyle	= this.color.text;
		context.fillText( this.TB_ESCAPE, tx + 10, ty + 22 );

		context.restore();
	};
	/**
	 * 
	 */
	pt.drawRect = function( context, x, y, w, h, color )
	{
		context.fillStyle	= color;
		context.fillRect( x, y, w, h );

		context.strokeStyle	= this.color.border;
		context.beginPath();
		context.strokeRect( x, y, w, h );
	};
})( BattleTask.prototype );


/**
 * InputCommand
 */
var InputCommand = function()
{
	this.tbl.left	= 0;
	this.tbl.right	= 0;
	this.tbl.up		= 0;
	this.tbl.down	= 0;
	this.tbl.enter	= 0;
	this.tbl.escape	= 0;
};
InputCommand.prototype = new Command();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function() {};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 37: case 65:	this.tbl.left	= value; break;	// ← | A
				case 39: case 68:	this.tbl.right	= value; break;	// → | D
				case 38: case 87:	this.tbl.up		= value; break;	// ↑ | W
				case 40: case 83:	this.tbl.down	= value; break;	// ↓ | S
				case 13:			this.tbl.enter	= value; break;	// ENTER
				case 27:			this.tbl.escape	= value; break;	// ESC
			}
		}
	};
})( InputCommand.prototype );


/**
 * BattleScene
 */
var BattleScene = function( app )
{
	this.app		= app;
	this.name		= SCENE_NAME;

	this.resource	= null;
	this.input		= new InputCommand();

	this.battle		= new BattleTask( this );
	this.head		= this.battle;	// head of task list

	// add message handler
	this.msgManager.addHandler( new MessageHandler( MessageType.RET_PREV_SCENE, this, this.handleRetPrevScene ) );
};
BattleScene.prototype = new Scene();

(function( pt )
{
	/**
	 * 
	 */
	pt.handleRetPrevScene = function( scene, message )
	{
		this.resource.battleSound.pause();

		this.app.sceneManager.pop();
		this.app.sceneManager.current.show();
	};
	/**
	 * 
	 */
	pt.reset = function( resource, player, enemy )
	{
		this.resource		= resource;
		this.battle.reset( this, player, enemy );

		this.resource.battleSound.loop	= true;
		this.resource.battleSound.play();
	};
	/**
	 * 
	 */
	pt.show = function()
	{
		this.setUsage( USAGE_HTML );

		this.input.clear();

		this.holdCanvas();
		this.updateTasks();
		this.drawTasks();
	};
})( BattleScene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.BattleScene	= BattleScene;


// Anonymous function end
//
})( window );
