/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

var Config			= h5glib.Config;
var Debug			= h5glib.Debug;
var Command			= h5glib.Command;
var ListElement		= h5glib.ListElement;
var Task			= h5glib.Task;
var Scene			= h5glib.Scene;

var SCENE_NAME		= "menu";
var STAGE_SCENE_NAME= "stage";

/**
 * MenuTask
 */
var MenuTask = function( scene )
{
	this.command	= scene.input;
};
MenuTask.prototype = new Task();

(function( pt )
{
	/**
	 * 描画する。
	 */
	pt.draw = function( scene )
	{
		var canvas		= scene.canvas;
		var context		= scene.context;

		context.save();

		context.fillStyle = "lightgray";
		context.fillRect( 0, 0, canvas.width, canvas.height );

		context.font		= "24px 'ＭＳ Ｐゴシック'";
		context.fillStyle	= "white";
		context.fillText( "Menu", 100, 100 );

		context.restore();
	};
})( MenuTask.prototype );

/**
 * InputCommand
 */
var InputCommand = function()
{
	this.tbl.escape	= 0;
};
InputCommand.prototype = new Command();

(function( pt )
{
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 27:	this.tbl.escape	= value; break;	// ESC
			}
		}
	};
})( InputCommand.prototype );

/**
 * MenuScene
 */
var MenuScene = function( app )
{
	this.app		= app;
	this.name		= SCENE_NAME;

	this.input		= new InputCommand();

	this.menu		= new MenuTask( this );
	this.head		= this.menu;	// head of task list
};
MenuScene.prototype = new Scene();

(function( pt )
{
	/**
	 * 
	 */
	pt.show = function()
	{
		this.input.clear();

		this.holdCanvas();
		this.drawTasks();
	};
	/**
	 * 
	 */
	pt.update = function()
	{
		this.ticks++;

		// change scene
		if ( this.input.tbl.escape )
		{
			this.app.sceneManager.push( STAGE_SCENE_NAME );
			this.app.sceneManager.current.show();
			return;
		}

		// update & draw
		if ( this.updateTasks() )
		{
			this.drawTasks();
		}
	};
})( MenuScene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.MenuScene		= MenuScene;


// Anonymous function end
//
})( window );
