/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function
//
(function( window, undefined )
{
	// initialize
	var app = new h5glib.Application();

	var menuScene	= new h5glib.MenuScene( app, "menu" );
	var stageScene	= new h5glib.StageScene( app, "stage0/" );
	var battleScene	= new h5glib.BattleScene( app, "battle" );
	var editorScene	= new h5glib.EditorScene( app, "editor" );

	menuScene.stageName		= stageScene.name;
	stageScene.battleName	= battleScene.name;
	stageScene.editorName	= editorScene.name;

	app.sceneManager.add( menuScene );
	app.sceneManager.add( stageScene );
	app.sceneManager.add( battleScene );
	app.sceneManager.add( editorScene );

	app.sceneManager.push( menuScene.name );
	app.sceneManager.push( stageScene.name );

	app.start();

	// Expose JSONP callback func
	if ( !window.h5glib ) { window.h5glib = {}; }
	window.h5glib.loadDataCB = function( json )
	{
		app.sceneManager.current.loadData( json );
	};

})( window );
