/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

// reference
var Config			= window.h5glib.Config;
var Debug			= window.h5glib.Debug;
var Command			= window.h5glib.Command;
var Task			= window.h5glib.Task;
var SoundTask		= window.h5glib.SoundTask;
var ReadyTask		= window.h5glib.ReadyTask;
var ImageAnimator	= window.h5glib.ImageAnimator;
var Message			= window.h5glib.Message;
var MessageHandler	= window.h5glib.MessageHandler;
var MessageManager	= window.h5glib.MessageManager;
var SceneStatus		= window.h5glib.SceneStatus;
var Scene			= window.h5glib.Scene;

/**
 * RenderInfo
 */
var RenderInfo =
{
	displayRect		: { x : 15, y : 71, w : 176, h : 263 },
	homeRect		: { x : 83, y : 348, w : 40, h : 40 },
	iconPixels		: 40
};

/**
 * Res
 */
var Res =
{
	String :
	{
		HTML_USAGE	: "<p>" +
					  "ホームボタンで戻ります。" +
					  "</p>",
		BS_MESSAGES :
		[
			"A problem has been detected and",
			"windows has been shut down to ",
			"prevent damage to your computer.",
			"",
			"Technical information:",
			"",
			"*** STOP: 0x00000050 (0xFD3094C2,",
		]
	},
	Color :
	{
		BACKGROUND			: "forestgreen",
		BACK_BLUESCREEN		: "blue",
		FONT_BLUESCREEN		: "white"
	},
	Font :
	{
		BLUESCREEN	: "normal 10px 'Times New Roman'",
		LARGE		: "bold 18px 'ＭＳ Ｐゴシック'",
		SMALL		: "bold 14px 'ＭＳ Ｐゴシック'"
	}
};

/**
 * StageTask
 */
var StageTask = function( scene )
{
	this.command		= scene.command;	// input
};
StageTask.prototype = new Task();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd			= false;

		return upd;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var canvas		= scene.canvas;
		var context		= scene.context;
		var resource	= scene.data.resource;

		context.save();

		// 上書きモード
		context.globalCompositeOperation	= "source-over";

		var image = resource.image.back.data;
		context.drawImage(
			image,
			0,				// sx
			0,				// sy
			image.width,	// sw
			image.height,	// sh
			( canvas.width  - image.width  ) / 2,	// dx
			( canvas.height - image.height ) / 2,	// dy
			image.width,	// dw
			image.height	// dh
		);
		context.restore();
	};
})( StageTask.prototype );

/**
 * IconListStatus
 */
var IconListStatus =
{
	HOME			: 0,
	APP_STARTING	: 1,
	APP_RUNNING		: 2
};

/**
 * IconListTask
 */
var IconListTask = function( scene )
{
	this.command	= scene.command;	// input
	this.statusObjs	=
	[
		{ update : this.updateHome },
		{ update : this.updateHome },
		{ update : this.updateApp }
	];
};
IconListTask.prototype = new Task();

(function( pt )
{
	/**
	 * 
	 */
	pt.setStatus = function( status )
	{
		this.status		= status;

		var sobj		= this.statusObjs[ this.status ];
		this.update		= sobj.update;
	};
	/**
	 * 
	 */
	pt.setData = function( scene, resource )
	{
		this.child	= null;

		var topX = RenderInfo.displayRect.x + 8;
		var topY = RenderInfo.displayRect.y + 10;
		var size = RenderInfo.iconPixels;

		// create icon list
		for ( var i = 0; i < resource.image.icons.length; i++ )
		{
			var trans =
			{
				x : topX + ( ( i % 4 ) * size ) + ( size / 2 ),
				y : topY + ( Math.floor( i / 4 ) * size ) + ( size / 2 )
			};
			var task	= new IconTask();
			task.init( scene, resource.image.icons[i].data, trans );
			// add
			if ( this.child == null )
			{
				this.child = task;
			}
			else
			{
				this.child.append( task );
			}
		}
		// set status
		this.setStatus( IconListStatus.HOME );
	};
	/**
	 * 
	 */
	pt.updateHome = function( scene )
	{
		var upd		= false;

		if ( this.updateChildren( scene ) )
		{
			upd = true;
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.updateApp = function( scene )
	{
		return false;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		this.drawChildren( scene );
	};
})( IconListTask.prototype );

/**
 * IconTask
 */
var IconTask = function()
{
	this.command	= null;
	this.image		= null;
	this.trans		= null;	// 中心位置
	this.offset		= { x : 0, y : 0 };

	this.lag		= 0;
};
IconTask.prototype = new Task();

(function( pt )
{
	pt.LAG_VAL	= 4;
	pt.OFF_VAL	= 3;

	/**
	 * 
	 */
	pt.init = function( scene, image, trans )
	{
		this.command	= scene.command;	// input
		this.image		= image;
		this.trans		= trans;
	};
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd			= false;
		var iconList	= scene.iconListTask;
		var resource	= scene.data.resource;
		var sound		= scene.soundTask;

		if ( this.lag )
		{
			this.lag--;
			if ( this.lag == 0 )
			{
				iconList.setStatus( IconListStatus.APP_RUNNING );
				sound.prepare( resource.sound.blue.data );
				// add task
				var task = new BlueScreenTask( scene );
				task.link( iconList );

				this.offset.x	= 0;
				this.offset.y	= 0;
				upd = true;
			}
		}
		else
		{
			if ( iconList.status == IconListStatus.HOME )
			{
				var size = RenderInfo.iconPixels;
				if ( this.command.mouse &&
					 this.trans.x - size / 2 <= this.command.mouseInfo.x &&
					 this.command.mouseInfo.x <= this.trans.x + size / 2 &&
					 this.trans.y - size / 2 <= this.command.mouseInfo.y &&
					 this.command.mouseInfo.y <= this.trans.y + size / 2 )
				{
					iconList.setStatus( IconListStatus.APP_STARTING );

					this.offset.x	= this.OFF_VAL;
					this.offset.y	= this.OFF_VAL;
					this.lag		= this.LAG_VAL;
					upd = true;
				}
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var canvas		= scene.canvas;
		var context		= scene.context;
		var resource	= scene.data.resource;

		context.save();

		// 上書きモード
		context.globalCompositeOperation	= "source-over";

		var w = this.image.width;
		var h = this.image.height;

		context.drawImage(
			this.image,
			0,
			0,
			w,
			h,
			this.trans.x - ( w / 2 ) + this.offset.x,
			this.trans.y - ( h / 2 ) + this.offset.y,
			w,
			h
		);
		context.restore();
	};
})( IconTask.prototype );

/**
 * BlueScreenTask
 */
var BlueScreenTask = function( scene )
{
	this.command	= scene.command;	// input

	this.lag		= 0;
};
BlueScreenTask.prototype = new Task();

(function( pt )
{
	pt.LAG_VAL	= 4;

	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd			= false;
		var iconList	= scene.iconListTask;
		var sound		= scene.soundTask;

		if ( this.lag )
		{
			this.lag--;
			if ( this.lag == 0 )
			{
				iconList.setStatus( IconListStatus.HOME );
				this.unlink();
				upd = true;
			}
		}
		else
		{
			var rect	= RenderInfo.homeRect;
			if ( this.command.mouse &&
				 rect.x <= this.command.mouseInfo.x &&
				 this.command.mouseInfo.x <= rect.x + rect.w &&
				 rect.y <= this.command.mouseInfo.y &&
				 this.command.mouseInfo.y <= rect.y + rect.h )
			{
				this.lag	= this.LAG_VAL;
				upd = true;
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var canvas		= scene.canvas;
		var context		= scene.context;
		var resource	= scene.data.resource;
		var rect		= RenderInfo.displayRect;

		context.save();

		// 上書きモード
		context.globalCompositeOperation	= "source-over";

		context.fillStyle	= Res.Color.BACK_BLUESCREEN;
		context.fillRect( rect.x, rect.y, rect.w, rect.h );

		context.font		= Res.Font.BLUESCREEN;
		context.fillStyle	= Res.Color.FONT_BLUESCREEN;
		for ( var i = 0; i < Res.String.BS_MESSAGES.length; i++ )
		{
			context.fillText( Res.String.BS_MESSAGES[i], rect.x + 5, rect.y + 5 + ( ( i + 1 ) * 12 ) );
		}
		context.restore();
	};
})( BlueScreenTask.prototype );

/**
 * DebugTask
 */
var DebugTask = function( scene )
{
	this.command	= scene.command;	// input
	this.info		= null;
	this.lag		= 0;
};
DebugTask.prototype = new Task();

(function( pt )
{
	pt.LAG_VAL	= 10;

	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;
		// lag
		if ( this.lag )
		{
			this.lag--;
		}
		else
		{
			if ( this.command.tbl.debug )
			{
				this.info	= "???=";
				this.lag	= this.LAG_VAL;
				upd = true;
			}
		}
		return upd;
	};

	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		// output debug info
		if ( this.info )
		{
			Debug.print( this.info );
			this.info = null;
		}
	};
})( DebugTask.prototype );

/**
 * InputCommand
 */
var InputCommand = function()
{
	this.tbl.escape	= 0;
	this.tbl.debug	= 0;
	this.tbl.mouse	= 0;
	this.mouseInfo	=
	{
		x		: 0,
		y		: 0
	};
};
InputCommand.prototype = new Command();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function() {};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 27:	this.tbl.escape	= value; break;	// ESC
				case 81:	this.tbl.debug	= value; break;	// Q
			}
		}
		else if ( type == "mousedown" )
		{
			this.mouse			= 1;
			this.mouseInfo.x	= event.layerX;
			this.mouseInfo.y	= event.layerY;
		}
		else if ( type == "mousemove" )
		{
			this.mouseInfo.x	= event.layerX;
			this.mouseInfo.y	= event.layerY;
		}
		else if ( type == "mouseup" || type == "mouseout" )
		{
			this.mouse = 0;
		}
	};
})( InputCommand.prototype );

/**
 * WphoneScene
 */
var WphoneScene = function( app, name )
{
	this.app			= app;
	this.name			= name;
	this.data			= null;
	this.command		= new InputCommand();

	// create task
	this.readyTask		= new ReadyTask( this );
	this.stageTask		= new StageTask( this );
	this.iconListTask	= new IconListTask( this );
	this.soundTask		= new SoundTask( this );
	this.debugTask		= new DebugTask( this );
	// create list
	this.stageTask.append( this.iconListTask );
	this.stageTask.append( this.soundTask );
	this.stageTask.append( this.debugTask );

	this.headTasks		=
	[
		this.readyTask,
		this.stageTask,
		this.readyTask
	];
	this.setStatus( SceneStatus.READY );

	// message handler
	//this.msgManager		= new MessageManager();
};
WphoneScene.prototype = new Scene();

(function( pt )
{
	/**
	 * 
	 */
	pt.setStatus = function( status )
	{
		this.status	= status;
		this.child	= this.headTasks[ this.status ];
	};

	/**
	 * 
	 */
	pt.init = function()
	{
		// window.onload のタイミング
	};
	/**
	 * 
	 */
	pt.show = function()
	{
		this.setUsage( Res.String.HTML_USAGE );

		this.command.clear();
		this.holdCanvas();
		this.drawChildren( this );
	};

	/**
	 * 
	 */
	pt.setData = function( data )
	{
		this.data	= data;

		this.iconListTask.setData( this, data.resource );
	};
	/**
	 * 
	 */
	pt.getData = function()
	{
		return this.data;
	};
	/**
	 * 
	 */
	pt.loadData = function( data )
	{
		try
		{
			// load resource
			this.app.loadResource( this.name, data.resource );
			// set data
			this.setData( data );
			// set status
			var self = this;
			window.setTimeout( function() { self.setStatus( SceneStatus.RUNNING ); self.show(); }, 500 );
		}
		catch ( e )
		{
			this.app.kill();
			Debug.alertError( e );
		}
	};
})( WphoneScene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.WphoneScene	= WphoneScene;

// Anonymous function end
//
})( window );
