/*
 * Decompiled with CFR 0.152.
 */
package org.yodatomato.haikubrowser.util;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.yodatomato.haikubrowser.beans.Entry;

public class HaikuUtil {
    private static final String BR = "<br/>";
    private static final int MIN_ROWSIZE = 50;
    private static final String FMTSTR = "yyyyMMddHHmmss";
    private static final String GMT = "GMT";
    private static final String TIMEZONE = "Z";
    private static final String EQUAL = "=";
    private static final String CRLF = "\\\\r\\\\n";
    private static final String LF = "\\\\n";
    private static final String FMTDATE = "yyyy/MM/dd HH:mm:ss";
    private static final String JST = "JST";
    private static final String HIPHEN = "-";
    private static final int MAXLENGTH = 100;

    public static Date parseHatenaDate(String dateStr) {
        try {
            String yy = dateStr.substring(0, 4);
            String mm = dateStr.substring(5, 7);
            String dd = dateStr.substring(8, 10);
            String hh = dateStr.substring(11, 13);
            String mi = dateStr.substring(14, 16);
            String ss = dateStr.substring(17, 19);
            SimpleDateFormat sdf = new SimpleDateFormat(FMTSTR);
            sdf.setTimeZone(TimeZone.getTimeZone(GMT));
            StringBuilder sb = new StringBuilder();
            sb.append(yy);
            sb.append(mm);
            sb.append(dd);
            sb.append(hh);
            sb.append(mi);
            sb.append(ss);
            sb.append(TIMEZONE);
            return sdf.parse(sb.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String removeKeyword(String target, String keyword) {
        StringBuilder sb = new StringBuilder();
        sb.append(keyword);
        sb.append(EQUAL);
        String targetAndEqual = sb.toString();
        if (target.startsWith(targetAndEqual)) {
            return target.replaceFirst(targetAndEqual, "");
        }
        return target;
    }

    public static String replaceCRLF(String target) {
        return target.replaceAll(CRLF, BR).replaceAll(LF, BR);
    }

    public static String escapeNull(String target) {
        return target == null ? HIPHEN : target;
    }

    public static String getStrFromDate(Date target) {
        SimpleDateFormat sdf = new SimpleDateFormat(FMTDATE);
        sdf.setTimeZone(TimeZone.getTimeZone(JST));
        return target == null ? HIPHEN : sdf.format(target);
    }

    public static String getURLString(String target) {
        Pattern pattern = Pattern.compile("(http://|https://){1}[\\w\\.\\-/:]+");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = null;
        while (matcher.find()) {
            String imgUrl;
            int height;
            int width;
            block17: {
                Pattern pattern_ext = Pattern.compile("\\.(jpg|png|gif|tif|bmp){1}$");
                Matcher matcher_ext = pattern_ext.matcher(matcher.group());
                width = 100;
                height = 100;
                if (!matcher_ext.find()) continue;
                imgUrl = matcher.group();
                String extStr = matcher.group(1);
                ImageInputStream iis = null;
                ImageReader reader = null;
                BufferedInputStream is = null;
                URL urlImg = null;
                Iterator<ImageReader> it = null;
                try {
                    try {
                        is = null;
                        urlImg = new URL(imgUrl);
                        is = new BufferedInputStream(urlImg.openStream());
                        iis = ImageIO.createImageInputStream(is);
                        it = ImageIO.getImageReadersBySuffix(extStr);
                        reader = it.next();
                        reader.setInput(iis);
                        BufferedImage image = reader.read(0);
                        ImageIcon imageFile = new ImageIcon(image);
                        if (width > imageFile.getIconWidth()) {
                            width = imageFile.getIconWidth();
                        }
                        if (height > imageFile.getIconHeight()) {
                            height = imageFile.getIconHeight();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            is.close();
                            iis.close();
                            if (reader != null) {
                                reader.dispose();
                            }
                            break block17;
                        }
                        catch (IOException iOException) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        iis.close();
                        if (reader != null) {
                            reader.dispose();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    is.close();
                    iis.close();
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            sb = new StringBuilder();
            sb.append("<img src=\"");
            sb.append(imgUrl);
            sb.append("\" height=\"");
            sb.append(height);
            sb.append("\" width=\"");
            sb.append(width);
            sb.append("\" />");
            target = target.replaceAll(matcher.group(), sb.toString());
        }
        return target;
    }

    public static String getDispText(String target, String keyword) {
        target = HaikuUtil.removeKeyword(target, keyword);
        target = HaikuUtil.getURLString(target);
        return HaikuUtil.replaceCRLF(target);
    }

    public static String[] getValueSets(String targetStr) {
        Pattern pattern = Pattern.compile("\"(.*)\"\\s*:\\s*(\".*\"|[\\[\\]\\{\\}.]*)");
        Matcher matcher = pattern.matcher(targetStr);
        String[] result = null;
        if (matcher.find()) {
            result = new String[matcher.groupCount()];
            int countMax = matcher.groupCount();
            int cnt = 0;
            while (cnt < countMax) {
                result[cnt] = HaikuUtil.removeDoubleQuoted(matcher.group(cnt + 1));
                ++cnt;
            }
        } else {
            result = new String[]{targetStr.trim()};
        }
        return result;
    }

    public static String removeDoubleQuoted(String targetStr) {
        String tmpStr = targetStr;
        Pattern pattern = Pattern.compile("^\"(.*)");
        Matcher matcher = pattern.matcher(tmpStr.trim());
        if (matcher.find()) {
            tmpStr = matcher.group(1);
        }
        if ((matcher = (pattern = Pattern.compile("(.*)\"$")).matcher(tmpStr.trim())).find()) {
            tmpStr = matcher.group(1);
        }
        return tmpStr;
    }

    public static String getDispText(Entry entry) {
        String target = entry.getText();
        String keyword = entry.getKeyword();
        target = HaikuUtil.removeKeyword(target, keyword);
        target = HaikuUtil.getURLString(target);
        target = HaikuUtil.replaceCRLF(target);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><p>");
        sb.append(keyword);
        sb.append("</p><p>");
        sb.append(target);
        sb.append("</p><p>by&nbsp;");
        sb.append(entry.getUser().getName());
        sb.append("&nbsp;at&nbsp;");
        sb.append(HaikuUtil.getStrFromDate(entry.getCreated_at()));
        sb.append("<br/><img src=\"http://s.hatena.ne.jp/images/star.gif\"/>\u00d7");
        sb.append(entry.getFavorited());
        sb.append("</p></html>");
        return sb.toString();
    }

    public static int getRowHeight(String displayStr) {
        if (displayStr == null) {
            return 50;
        }
        int result = 0;
        result = (displayStr.split(BR).length + 3) * 20;
        Pattern pattern = Pattern.compile("<img src=\"(http://|https://){1}[\\w\\.\\-/:]+\\.(jpg|png|gif|tif|bmp)\"");
        Matcher matcher = pattern.matcher(displayStr);
        while (matcher.find()) {
            result += 110;
        }
        return (result -= 110) < 51 ? 50 : result;
    }

    public static boolean isNotEmpty(String target) {
        return target != null && target.length() != 0;
    }
}

