//  vorbis_file_example.cpp: an example for vorbis_file<Source>

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <hamigaki/audio/vorbis_file.hpp>
#include <boost/iostreams/device/file.hpp>
#include <boost/iostreams/copy.hpp>
#include <exception>
#include <iostream>

namespace io = boost::iostreams;

int main(int argc, char* argv[])
{
    try
    {
        if (argc != 3)
        {
            std::cerr
                << "Usage: vorbis_file_example (input file) (output file)"
                << std::endl;

            return 1;
        }

        io::copy(
            hamigaki::audio::vorbis_file_source(argv[1]),
            io::file_sink((std::string(argv[2])),  BOOST_IOS::binary));

        return 0;
    }
    catch (const std::exception& e)
    {
        std::cerr << "Error: " << e.what() << std::endl;
    }
    return 1;
}
