/* $Id: hardmeter.h,v 1.4 2003/02/24 09:23:08 tkubo Exp $ */

/* hardmeter.h
 *
 * Copyright (C) 2003 Hardmeter Project <http://hardmeter.sourceforge.jp>
 *
 * This project is supported by IPA(Information-technology Promotion
 * Agency, Japan).
 *
 * "hardmeter" is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _HARDMETER_H_
#define _HARDMETER_H_ 1
#include <sys/types.h>
#include <linux/perfctr.h>

#define HARDMETER_DEFAULT_INTERVAL 10000
#define HARDMETER_DEFAULT_COUNT 2000

typedef struct hardmeter_t hardmeter_t; /* opaque data type */

#define HMT_COUNTER 0x1
#define HMT_EBS     0x2
#define HMT_PEBS    0x4
#define HMT_HIDDEN  0x100

struct hardmeter_event_mask_t {
	const char *name;
	const char *description;
	int position;
	unsigned int val;
	int is_default;
};
typedef struct hardmeter_event_mask_t hardmeter_event_mask_t;

struct hardmeter_template_t {
	const char *name;
	const char *description;
	const struct vperfctr_control *control;
	const hardmeter_event_mask_t *eventmask;
	int type; /* HMT_COUNTER, HMT_EBS or HMT_PEBS */
};
typedef struct hardmeter_template_t hardmeter_template_t;

struct hardmeter_option_t {
	const hardmeter_template_t *template;
	int eventmask;
	int user;
	int kernel;
	int interval;
	int count;
};
typedef struct hardmeter_option_t hardmeter_option_t;

/* hardmeter.c */

int hardmeter_init(const char **err);
const hardmeter_template_t *hardmeter_get_templates(const char **err);
const hardmeter_template_t *hardmeter_search_template(const char *name, const char **err);
int hardmeter_update_eventmask(int *eventmask, const hardmeter_template_t *, const char *name, const char **err);

hardmeter_t *hardmeter_open(const hardmeter_option_t *opt, const char **err);
hardmeter_t *hardmeter_attach_process(const hardmeter_option_t *opt, pid_t pid, const char **err);
hardmeter_t *hardmeter_start_process(const hardmeter_option_t *opt, const char *file, char *const argv[], const char **err);
int hardmeter_dump(hardmeter_t *h, const char *filename, int non_blocking, const char **err);
int hardmeter_terminate(hardmeter_t *h, const char **err);
int hardmeter_close(hardmeter_t *h, const char **err);

/* p4_template.c */
extern hardmeter_template_t hardmeter_p4_template[];
int hardmeter_p4_fill_control(struct vperfctr_control *dest, const hardmeter_option_t *opt);

/* rc.c */
extern int hardmeter_parse_rc(struct hardmeter_option_t *opt, char **filenamep, const char *name, const char **err);

/* self.c */
int hardmeter_start(const char *name);
int hardmeter_stop(void);

#endif
