/* $Id: global.c,v 1.5 2003/03/10 22:07:58 mikpe Exp $
 * Library interface to global-mode performance counters.
 *
 * Copyright (C) 1999-2003  Mikael Pettersson
 */

#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "libperfctr.h"

struct gperfctr {	/* XXX: kill this struct */
    int fd;
};

struct gperfctr *gperfctr_open(void)
{
    struct gperfctr *gperfctr;

    gperfctr = malloc(sizeof(*gperfctr));
    if( gperfctr ) {
	gperfctr->fd = open("/dev/perfctr", O_RDONLY);
	if( gperfctr->fd >= 0 ) {
	    if( perfctr_abi_check_fd(gperfctr->fd) >= 0 )
		return gperfctr;
	    close(gperfctr->fd);
	}
	free(gperfctr);
    }
    return NULL;
}

void gperfctr_close(struct gperfctr *gperfctr)
{
    close(gperfctr->fd);
    free(gperfctr);
}

int gperfctr_control(const struct gperfctr *gperfctr,
		     struct gperfctr_control *arg)
{
    return ioctl(gperfctr->fd, GPERFCTR_CONTROL, (long)arg);
}

int gperfctr_read(const struct gperfctr *gperfctr, struct gperfctr_state *arg)
{
    return ioctl(gperfctr->fd, GPERFCTR_READ, (long)arg);
}

int gperfctr_stop(const struct gperfctr *gperfctr)
{
    return ioctl(gperfctr->fd, GPERFCTR_STOP, 0);
}

int gperfctr_info(const struct gperfctr *gperfctr, struct perfctr_info *info)
{
    return perfctr_info(gperfctr->fd, info);
}
