; naskfunc
; TAB=4

[FORMAT "WCOFF"]                ; IuWFNgt@C郂[h
[INSTRSET "i486p"]              ; 486̖߂܂ŎgƂLq
[BITS 32]                       ; 32rbg[hp̋@B点
[FILE "naskfunc.nas"]           ; \[Xt@C

        GLOBAL    _io_hlt, _io_cli, _io_sti, _io_stihlt
        GLOBAL    _io_in8,  _io_in16,  _io_in32
        GLOBAL    _io_out8, _io_out16, _io_out32
        GLOBAL    _io_load_eflags, _io_store_eflags
        GLOBAL    _load_gdtr, _load_idtr
        GLOBAL    _load_cr0, _store_cr0
        GLOBAL    _load_tr
        GLOBAL    _asm_inthandler20, _asm_inthandler21
        GLOBAL    _asm_inthandler2c
        GLOBAL    _asm_inthandler0c, _asm_inthandler0d
        GLOBAL    _asm_end_app
        GLOBAL    _get_physical_size
        GLOBAL    _farjmp, _farcall
        GLOBAL    _asm_hrb_api, _start_app
        EXTERN    _inthandler20, _inthandler21
        EXTERN    _inthandler2c
        EXTERN    _inthandler0d, _inthandler0c
        EXTERN    _hrb_api

[SECTION .text]

_io_hlt:    ; void io_hlt(void);
        HLT
        RET

_io_cli:    ; void io_cli(void);
        CLI
        RET

_io_sti:    ; void io_sti(void);
        STI
        RET

_io_stihlt: ; void io_stihlt(void);
        STI
        HLT
        RET

_io_in8:    ; int io_in8(int port);
        MOV        EDX,[ESP+4]        ; port
        MOV        EAX,0
        IN         AL,DX
        RET

_io_in16:   ; int io_in16(int port);
        MOV        EDX,[ESP+4]        ; port
        MOV        EAX,0
        IN         AX,DX
        RET

_io_in32:   ; int io_in32(int port);
        MOV        EDX,[ESP+4]        ; port
        IN         EAX,DX
        RET

_io_out8:   ; void io_out8(int port, int data);
        MOV        EDX,[ESP+4]        ; port
        MOV        AL,[ESP+8]         ; data
        OUT        DX,AL
        RET

_io_out16:  ; void io_out16(int port, int data);
        MOV        EDX,[ESP+4]        ; port
        MOV        EAX,[ESP+8]        ; data
        OUT        DX,AX
        RET

_io_out32:  ; void io_out32(int port, int data);
        MOV        EDX,[ESP+4]        ; port
        MOV        EAX,[ESP+8]        ; data
        OUT        DX,EAX
        RET

_io_load_eflags:     ; int io_load_eflags(void);
        PUSHFD                        ; PUSH EFLAGS ƂӖ
        POP        EAX
        RET

_io_store_eflags:    ; void io_store_eflags(int eflags);
        MOV        EAX,[ESP+4]
        PUSH       EAX
        POPFD                        ; POP EFLAGS ƂӖ
        RET

_load_gdtr: ; void load_gdtr(int limit, int addr);
        MOV        AX,[ESP+4]        ; limit
        MOV        [ESP+6],AX
        LGDT       [ESP+6]
        RET

_load_idtr: ; void load_idtr(int limit, int addr);
        MOV        AX,[ESP+4]        ; limit
        MOV        [ESP+6],AX
        LIDT       [ESP+6]
        RET

_load_cr0:  ; int load_cr0(void);
        MOV        EAX,CR0
        RET

_store_cr0: ; void store_cr0(int cr0);
        MOV        EAX,[ESP+4]
        MOV        CR0,EAX
        RET

_load_tr:   ; void load_tr(int tr);
        LTR        [ESP+4]           ; tr
        RET

_asm_inthandler20:
        PUSH       ES
        PUSH       DS
        PUSHAD
        MOV        EAX,ESP
        PUSH       EAX
        MOV        AX,SS
        MOV        DS,AX
        MOV        ES,AX
        CALL       _inthandler20
        POP        EAX
        POPAD
        POP        DS
        POP        ES
        IRETD

_asm_inthandler21:
        PUSH       ES
        PUSH       DS
        PUSHAD
        MOV        EAX,ESP
        PUSH       EAX
        MOV        AX,SS
        MOV        DS,AX
        MOV        ES,AX
        CALL       _inthandler21
        POP        EAX
        POPAD
        POP        DS
        POP        ES
        IRETD

_asm_inthandler2c:
        PUSH       ES
        PUSH       DS
        PUSHAD
        MOV        EAX,ESP
        PUSH       EAX
        MOV        AX,SS
        MOV        DS,AX
        MOV        ES,AX
        CALL       _inthandler2c
        POP        EAX
        POPAD
        POP        DS
        POP        ES
        IRETD

_asm_inthandler0c:
        STI
        PUSH       ES
        PUSH       DS
        PUSHAD
        MOV        EAX,ESP
        PUSH       EAX
        MOV        AX,SS
        MOV        DS,AX
        MOV        ES,AX
        CALL       _inthandler0c
        CMP        EAX,0
        JNE        _asm_end_app
        POP        EAX
        POPAD
        POP        DS
        POP        ES
        ADD        ESP,4             ; INT 0x0c łAꂪKv
        IRETD

_asm_inthandler0d:
        STI
        PUSH       ES
        PUSH       DS
        PUSHAD
        MOV        EAX,ESP
        PUSH       EAX
        MOV        AX,SS
        MOV        DS,AX
        MOV        ES,AX
        CALL       _inthandler0d
        CMP        EAX,0             ; Ⴄ
        JNE        _asm_end_app      ; Ⴄ
        POP        EAX
        POPAD
        POP        DS
        POP        ES
        ADD        ESP,4             ; INT 0x0d ł́AꂪKv
        IRETD

_get_physical_size:  ; dword get_physical_size(dword start, dword end)
        PUSH       EDI               ; iEBX, ESI, EDI ĝŁj
        PUSH       ESI
        PUSH       EBX
        MOV        ESI,0xaa55aa55    ; pat0 = 0xaa55aa55;
        MOV        EDI,0x55aa55aa    ; pat1 = 0x55aa55aa;
        MOV        EAX,[ESP+12+4]    ; i = start;
mts_loop:
        MOV        EBX,EAX
        ADD        EBX,0xffc         ; p = i + 0xffc;
        MOV        EDX,[EBX]         ; old = *p;
        MOV        [EBX],ESI         ; *p = pat0;
        XOR        DWORD [EBX],0xffffffff    ; *p ^= 0xffffffff;
        CMP        EDI,[EBX]         ; if (*p != pat1) goto fin;
        JNE        mts_fin
        XOR        DWORD [EBX],0xffffffff    ; *p ^= 0xffffffff;
        CMP        ESI,[EBX]         ; if (*p != pat0) goto fin;
        JNE        mts_fin
        MOV        [EBX],EDX         ; *p = old;
        ADD        EAX,0x1000        ; i += 0x1000;
        CMP        EAX,[ESP+12+8]    ; if (i <= end) goto mts_loop;
        JBE        mts_loop
        POP        EBX
        POP        ESI
        POP        EDI
        RET
mts_fin:
        MOV        [EBX],EDX         ; *p = old;
        POP        EBX
        POP        ESI
        POP        EDI
        RET

_farjmp:    ; void farjmp(int eip, int cs);
        JMP        FAR    [ESP+4]    ; eip, cs
        RET

_farcall:   ; void farcall(int eip, int cs);
        CALL       FAR    [ESP+4]    ; eip, cs
        RET

_asm_hrb_api:
        STI
        PUSH       DS
        PUSH       ES
        PUSHAD                       ; ۑ̂߂PUSH
        PUSHAD                       ; hrb_apiɂ킽߂PUSH
        MOV        AX,SS
        MOV        DS,AX             ; OSp̃ZOgDSESɂ
        MOV        ES,AX
        CALL       _hrb_api
        CMP        EAX,0             ; EAX0łȂ΃AvI
        JNE        _asm_end_app
        ADD        ESP,32
        POPAD
        POP        ES
        POP        DS
        IRETD
_asm_end_app:
        MOV        ESP,[EAX]         ; EAXtss.esp0̔Ԓn
        MOV        DWORD [EAX+4],0
        POPAD
        RET                    ; cmd_app֋A

_start_app: ; void start_app(int eip, int cs, int esp, int ds, int *tss_esp0);
        PUSHAD                       ; 32rbgWX^SۑĂ
        MOV        EAX,[ESP+36]      ; AvpEIP
        MOV        ECX,[ESP+40]      ; AvpCS
        MOV        EDX,[ESP+44]      ; AvpESP
        MOV        EBX,[ESP+48]      ; AvpDS/SS
        MOV        EBP,[ESP+52]      ; tss.esp0̔Ԓn
        MOV        [EBP  ],ESP       ; OSpESPۑ
        MOV        [EBP+4],SS        ; OSpSSۑ
        MOV        ES,BX
        MOV        DS,BX
        MOV        FS,BX
        MOV        GS,BX
; ȉRETFŃAvɍs邽߂̃X^bN
        OR         ECX,3            ; Avp̃ZOgԍ3OR
        OR         EBX,3            ; Avp̃ZOgԍ3OR
        PUSH       EBX              ; AvSS
        PUSH       EDX              ; AvESP
        PUSH       ECX              ; AvCS
        PUSH       EAX              ; AvEIP
        RETF
; AvIĂɂ͗Ȃ
