#if !defined(_BAYOS_UTIL_SCHEDULER_H_INCLUDED_)
#define _BAYOS_UTIL_SCHEDULER_H_INCLUDED_

#define MAX_TASKS       64    /* ő^XN */
#define TASK_GDT_0      3     /* TSSGDT̉Ԃ犄蓖Ă̂ */
#define TASK_KEYBOARD   2     /* L[{[h^XN̔ԍ */
#define TASK_MOUSE      3     /* }EX^XN̔ԍ */

/* C̊֐錾 */
extern "C"
{
    /* ACh^XN */
    void task_idle(void);

    /* L[{[h^XN */
    void task_keyboard(void);

    /* }EX^XN */
    void task_mouse(void);

    /* 32rbgTSS */
    typedef struct TSS32
    {
        int backlink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
        int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
        int es, cs, ss, ds, fs, gs;
        int ldtr, iomap;
    };

    /* ^XN\ */
    typedef struct Task
    {
        int   selector;  /* GDT̔ԍ */
        bool  enable;    /* tO */
        char* name;      /* ^XN */
        TSS32 tss;       /* 32rbgTSS */
        int   ds_base;   /* f[^ZOgJnAhX */
        List<int>* fifo; /* FIFOobt@ */
        SEGMENT_DESCRIPTOR ldt[2]; /* [JfXNv^ */
        Memory* memory;  /* Avp}l[W */
    };
}

namespace system
{
    /* ^XNXPW[[ */
    class Scheduler
    {
    public:
        static Task** task_list;
        static List<Task*>* runq;
        static Task* current;
        static bool ready;

    public:
        static void  init(void);
        static Task* allocateTask(int eip, const char* name);
        static void  switchTask(void);
    };
}

#endif
