#include "../../baygui.h"

namespace baygui {
    namespace awt {
        /** R|[lgV\z܂B*/
        Component::Component() {
            addClassName(baygui_awt_Component);
            this->tx = 0;
            this->ty = 0;
            this->background = Color::lightGray;
            this->foreground = Color::black;
            this->rectangle = new Rectangle();
            this->graphics = new Graphics();
            this->focused = false;
            this->enabled = true;
            this->mouseEntered = false;
            this->parent = NULL;
            this->keyListeners = new ArrayList();
            this->mouseListeners = new ArrayList();
            this->mouseMotionListeners = new ArrayList();
        }

        /** fXgN^łB*/
        Component::~Component() {
            delete this->rectangle;
            delete this->graphics;
            delete this->keyListeners;
            delete this->mouseListeners;
            delete this->mouseMotionListeners;
        }

        /**
         * ̃R|[lgL[Cxg󂯎邽߂ɁA
         * w肳ꂽL[Xi[ǉ܂B
        */
        void Component::addKeyListener(KeyListener* l) {
            this->keyListeners->add((Object*) l);
        }

        /**
         * ̃R|[lg}EXCxg󂯎邽߂ɁA
         * w肳ꂽ}EXXi[ǉ܂B
        */
        void Component::addMouseListener(MouseListener* l) {
            this->mouseListeners->add((Object*) l);
        }

        /**
         * ̃R|[lg}EX[VCxg󂯎邽߂ɁA
         * w肳ꂽ}EX[VXi[ǉ܂B
        */
        void Component::addMouseMotionListener(MouseMotionListener* l) {
            this->mouseMotionListeners->add((Object*) l);
        }

        /** ̃R|[lg܂͂̃TuR|[lg 1 ɃCxgfBXpb`܂B*/
        void Component::dispatchEvent(AWTEvent* e) {
            processEvent(e);
        }

        /** ̃R|[lg̃obNOEhJ[Ԃ܂B*/
        unsigned int Component::getBackground() {
            return this->background;
        }

        /** ̃R|[lg̋E Rectangle IuWFNgƂĕԂ܂B*/
        Rectangle* Component::getBounds() {
            return this->rectangle;
        }

        /**
         * ̃R|[lg܂͂̒ڂ̃TuR|[lgʒu (x, y) 
         * ܂ł邩ǂ𔻒肵܂B
        */
        Component* Component::getComponentAt(int x, int y) {
            return (getX() < x && x < getX() + getWidth() &&
                    getY() < y && y < getY() + getHeight())
                   ? this : NULL;
        }

        /** ̃R|[lg̃tHAOEhJ[Ԃ܂B*/
        unsigned int Component::getForeground() {
            return this->foreground;
        }

        /** ̃R|[lg̃OtBbNXReLXg쐬܂B*/
        Graphics* Component::getGraphics() {
            if (this->graphics->frame == NULL) {
                /* ̃R|[lg̐ΈʒuvZ */
                this->tx = getX();
                this->ty = getY();
                Component* c = this;
                while (1) {
                    if (c->getParent() == NULL) {
                        /* AvP[Vt[ݒ肵AΈʒuݒ */
                        this->graphics->frame  = (Frame *) c;
                        this->graphics->buffer = ((Frame *) c)->buffer;
                        this->graphics->translate(this->tx, this->ty);
                        break;
                    } else {
                        c = c->getParent();
                    }
                    this->tx += c->getX();
                    this->ty += c->getY();
                }
            }
            return this->graphics;
        }

        /** ̃R|[lg̃TCYԂ܂B*/
        int Component::getHeight() {
            return this->rectangle->height;
        }

        /**  Component L[{[htH[JXꍇ true Ԃ܂B*/
        bool Component::hasFocus() {
            return this->focused;
        }

        /** ̃R|[lggp\ł邩ǂ𔻒肵܂B*/
        bool Component::isEnabled() {
            return this->enabled;
        }

        /** ̃R|[lg̐eԂ܂B*/
        Container* Component::getParent() {
            return this->parent;
        }

        /** ̃R|[lg̃TCYԂ܂B*/
        int Component::getWidth() {
            return this->rectangle->width;
        }

        /** ̃R|[lg̈ʒuAR|[lg̍w肷_ƂĕԂ܂B*/
        int Component::getX() {
            return this->rectangle->x;
        }

        /** ̃R|[lg̈ʒuAR|[lg̍w肷_ƂĕԂ܂B*/
        int Component::getY() {
            return this->rectangle->y;
        }

        /** ̃R|[lgyCg܂B*/
        void Component::paint(Graphics* g) {
            if (getWidth() == 0 || getHeight() == 0) return;
        }

        /** ̃R|[lgŔR|[lgCxg܂B*/
        void Component::processEvent(AWTEvent* e) {
            /* 񊈐̂Ƃ̓Cxg󂯕tȂB*/
            if (isEnabled() == false) return;

            switch (e->getID()) {
            case MouseEvent::MOUSE_DRAGGED:
            case MouseEvent::MOUSE_MOVED:
            {
                int mouse_x = ((MouseEvent*) e)->getX() - this->tx;
                int mouse_y = ((MouseEvent*) e)->getY() - this->ty;
                int mouse_m = ((MouseEvent*) e)->getModifiers();

                if (Component::getComponentAt(mouse_x + getX(), mouse_y + getY()) == this) {
                    /* }EX */
                    if (this->mouseEntered == false) {
                        this->mouseEntered = true;
                        MouseEvent* me = new MouseEvent(
                            e->getSource(),
                            MouseEvent::MOUSE_ENTERED,
                            mouse_m,
                            mouse_x,
                            mouse_y
                        );
                        processMouseEvent(me);
                        delete(me);
                    /* }EX */
                    } else {
                        MouseEvent* me = new MouseEvent(
                            e->getSource(),
                            e->getID(),
                            mouse_m,
                            mouse_x,
                            mouse_y
                        );
                        processMouseMotionEvent(me);
                        delete(me);
                    }
                } else {
                    /* }EXo */
                    if (this->mouseEntered == true) {
                        this->mouseEntered = false;
                        MouseEvent* me = new MouseEvent(
                            e->getSource(),
                            MouseEvent::MOUSE_EXITED,
                            mouse_m,
                            mouse_x,
                            mouse_y
                        );
                        processMouseEvent(me);
                        delete(me);
                    }
                }
                break;
            }
            case MouseEvent::MOUSE_PRESSED:
            case MouseEvent::MOUSE_RELEASED:
            {
                int mouse_x = ((MouseEvent*) e)->getX() - this->tx;
                int mouse_y = ((MouseEvent*) e)->getY() - this->ty;
                int mouse_m = ((MouseEvent*) e)->getModifiers();

                if (Component::getComponentAt(mouse_x + getX(), mouse_y + getY()) == this) {
                    MouseEvent* me = new MouseEvent(
                        e->getSource(),
                        e->getID(),
                        mouse_m,
                        mouse_x,
                        mouse_y
                    );
                    processMouseEvent(me);
                    delete(me);
                }
                break;
            }
            case KeyEvent::KEY_PRESSED:
            case KeyEvent::KEY_RELEASED:
                processKeyEvent((KeyEvent*) e);
                break;
            default:
                break;
            }
        }

        /**
         * ̃R|[lgŔL[CxgA
         * o^Ă邷ׂĂ KeyListener IuWFNgɑ邱ƂɂA
         * L[Cxg܂B
        */
        void Component::processKeyEvent(KeyEvent* e) {
            int I = this->keyListeners->size();
            for (int i = I - 1; i >= 0; i--) {
                KeyListener* l = (KeyListener*) this->keyListeners->get(i);
                switch (e->getID()) {
                case KeyEvent::KEY_PRESSED:
                    l->keyPressed(e);
                    break;
                case KeyEvent::KEY_RELEASED:
                    l->keyReleased(e);
                    break;
                }
            }
        }

        /**
         * ̃R|[lgŔ}EXCxgA
         * o^Ă邷ׂĂ MouseListener IuWFNgɑ邱ƂɂA
         * }EXCxg܂B
        */
        void Component::processMouseEvent(MouseEvent* e) {
            int I = this->mouseListeners->size();
            for (int i = I - 1; i >= 0; i--) {
                MouseListener* l = (MouseListener*) this->mouseListeners->get(i);
                switch (e->getID()) {
                case MouseEvent::MOUSE_ENTERED:
                    l->mouseEntered(e);
                    break;
                case MouseEvent::MOUSE_EXITED:
                    l->mouseExited(e);
                    break;
                case MouseEvent::MOUSE_PRESSED:
                    l->mousePressed(e);
                    break;
                case MouseEvent::MOUSE_RELEASED:
                    l->mouseReleased(e);
                    break;
                }
            }
            /* tH[JX */
            if (this->focused == false && e->getID() == MouseEvent::MOUSE_PRESSED) {
                requestFocus();
            }
        }

        /**
         * ̃R|[lgŔ}EX[VCxgA
         * o^Ă邷ׂĂ MouseMotionListener IuWFNgɑ邱ƂɂA
         * }EX[VCxg܂B
        */
        void Component::processMouseMotionEvent(MouseEvent* e) {
            int I = this->mouseMotionListeners->size();
            for (int i = I - 1; i >= 0; i--) {
                MouseMotionListener* l = (MouseMotionListener*) this->mouseMotionListeners->get(i);
                switch (e->getID()) {
                case MouseEvent::MOUSE_DRAGGED:
                    l->mouseDragged(e);
                    break;
                case MouseEvent::MOUSE_MOVED:
                    l->mouseMoved(e);
                    break;
                }
            }
        }

        /**
         * ̃R|[lgL[Cxg󂯎Ȃ悤ɁA
         * w肳ꂽL[Xi[폜܂B
        */
        void Component::removeKeyListener(KeyListener* l) {
            this->keyListeners->remove(this->keyListeners->indexOf((Object*) l));
        }

        /**
         * ̃R|[lg}EXCxg󂯎Ȃ悤ɁA
         * w肳ꂽ}EXXi[폜܂B
        */
        void Component::removeMouseListener(MouseListener* l) {
            this->mouseListeners->remove(this->mouseListeners->indexOf((Object*) l));
        }

        /**
         * ̃R|[lg}EX[VCxg󂯎Ȃ悤ɁA
         * w肳ꂽ}EX[VXi[폜܂B
        */
        void Component::removeMouseListener(MouseMotionListener* l) {
            this->mouseListeners->remove(this->mouseListeners->indexOf((Object*) l));
        }

        /** ̃R|[lgĕ`悵܂B*/
        void Component::repaint(int x, int y, int width, int height) {
            update(getGraphics(), x, y, width, height);
        }

        /** ̃R|[lg̓tH[JX擾邱Ƃv܂B*/
        void Component::requestFocus() {
            this->focused = true;
            if (this->graphics->frame->active != NULL) {
                this->graphics->frame->active->transferFocus();
            }
            this->graphics->frame->active = this;
            repaint();
        }

        /** ̃R|[lgړATCYύX܂B*/
        void Component::setBounds(int x, int y, int width, int height) {
            this->rectangle->x = x;
            this->rectangle->y = y;
            this->rectangle->width  = width;
            this->rectangle->height = height;
        }

        /** ̃R|[lg̃obNOEhJ[ݒ肵܂B*/
        void Component::setBackground(unsigned int c) {
            this->background = c;
        }

        /** ̃R|[lg̐eR|[lgw肵܂B*/
        void Component::setParent(Container* parent) {
            this->parent = parent;
        }

        /** ̃R|[lg̃tHAOEhJ[ݒ肵܂B*/
        void Component::setForeground(unsigned int c) {
            this->foreground = c;
        }

        /** ̃R|[lgɃtH[JXړ܂B*/
        void Component::transferFocus() {
            this->focused = false;
            repaint();
        }

        /** ̃R|[lgXV܂B*/
        void Component::update(Graphics* g, int x, int y, int w, int h) {
            paint(g);
#ifdef HARIBOTE
            if (w == 0 && h == 0) {
                api_refreshwin(
                    g->frame->handle,
                    this->tx,
                    this->ty,
                    this->tx + getWidth(),
                    this->ty + getHeight()
                );
            } else {
                api_refreshwin(
                    g->frame->handle,
                    this->tx + x,
                    this->ty + y,
                    this->tx + w,
                    this->ty + h
                );
            }
#endif
        }
    }
}
