#include "../../baygui.h"

namespace baygui {
    namespace awt {
        /** VRei\z܂B*/
        Container::Container() {
            addClassName(baygui_awt_Container);
            this->components = new ArrayList();
        }

        /** fXgN^łB*/
        Container::~Container() {
            delete this->components;
        }

        /** w肳ꂽR|[lg̃Rei̍Ōɒǉ܂B*/
        Component* Container::add(Component* c) {
            c->setParent(this);
            this->components->add(c);
            return c;
        }

        /**
         * ̃R|[lg܂͂̃TuR|[lg 1 
         * CxgfBXpb`܂B
        */
        void Container::dispatchEvent(AWTEvent* e) {
            Component::dispatchEvent(e);
            int I = this->components->size();
            for (int i = I - 1; i >= 0; i--) {
                Component* c = (Component*) this->components->get(i);
                c->dispatchEvent(e);
            }
        }

        /**
         * ̃R|[lg܂͂̒ڂ̃TuR|[lg
         * ʒu (x, y) ܂ł邩ǂ𔻒肵܂B
        */
        Component* Container::getComponentAt(int x, int y) {
            int I = this->components->size();
            for (int i = I - 1; i >= 0; i--) {
                Component* p = (Component*) this->components->get(i);
                Component* c = p->getComponentAt(x - p->getX(), y - p->getY());
                if (c != NULL) {
                    return c;
                }
            }
            return Component::getComponentAt(x, y);
        }

        /** ReîׂẴR|[lgԂ܂B*/
        ArrayList* Container::getComponents() {
            return this->components;
        }

        /** ReiAw肳ꂽR|[lg폜܂B*/
        void Container::remove(Component* c) {
            this->components->remove(this->components->indexOf(c));
        }

        /**
         * Reiĕ`悵܂B
         * ̃\bh́ÃRei̎qłyʃR|[lgɍXVv]܂B
         * ̃\bhĎꂽꍇAContainer::update(g) ĂяoČyʃR|[lg
         * K؂ɕ`悳悤ɂKv܂B
        */
        void Container::update(Graphics* g, int x, int y, int w, int h) {
            paint(g);
            int I = this->components->size();
            for (int i = 0; i < I; i++) {
                Component* c = (Component*) this->components->get(i);
                c->paint(c->getGraphics());
            }
#ifdef HARIBOTE
            if (w == 0 && h == 0) {
                api_refreshwin(
                    g->frame->handle,
                    this->tx,
                    this->ty,
                    this->tx + getWidth(),
                    this->ty + getHeight()
                );
            } else {
                api_refreshwin(
                    g->frame->handle,
                    this->tx + x,
                    this->ty + y,
                    this->tx + w,
                    this->ty + h
                );
            }
#endif
        }
    }
}
