#include "../../baygui.h"

namespace baygui {
    namespace awt {
        /** ̃x\z܂B*/
        Label::Label() {
            addClassName(baygui_awt_Label);
            this->alignment = Label::LEFT;
            this->text = NULL;
        }

        /** VxāAw肳ꂽeLXgō\z܂B*/
        Label::Label(const char* text) {
            addClassName(baygui_awt_Label);
            this->alignment = Label::LEFT;
            setText(text);
        }

        /** w肳ꂽeLXgAw肳ꂽzuŕ\Vx\z܂B*/
        Label::Label(const char* text, int alignment) {
            addClassName(baygui_awt_Label);
            this->alignment = alignment;
            setText(text);
        }

        /** fXgN^łB*/
        Label::~Label() {
            delete this->text;
        }

        /** ̃x݂̌̔zuԂ܂B*/
        int Label::getAlignment() {
            return this->alignment;
        }

        /** ̃x̃eLXgԂ܂B*/
        char* Label::getText() {
            return this->text;
        }

        /** ̃R|[lgyCg܂B*/
        void Label::paint(Graphics* g) {
            int w = getWidth();
            int h = getHeight();

            /* xwiFŃNA */
            g->setColor(getBackground());
            g->fillRect(0, 0, w, h);

            /* ` */
            int fw = FontMetrice::stringWidth(this->text);
            int fh = FontMetrice::getHeight();
            if (isEnabled() == true) {
                g->setColor(getForeground());
            } else {
                g->setColor(Color::gray);
            }
            if (this->alignment == Label::RIGHT) {
                g->drawString(this->text, (w - fw), (h - fh) / 2);
            } else if (this->alignment == Label::CENTER) {
                g->drawString(this->text, (w - fw) / 2, (h - fh) / 2);
            } else {
                g->drawString(this->text, 0, (h - fh) / 2);
            }
        }

        /** ̃x̔zuAw肳ꂽzuɐݒ肵܂B*/
        void Label::setAlignment(int alignment) {
            this->alignment = alignment;
        }

        /** ̃x̃eLXgAw肳ꂽeLXgɐݒ肵܂B*/
        void Label::setText(const char* text) {
            if (this->text != NULL) delete this->text;
            int I = strlen(text) + 1;
            this->text = new char[I];
            memcpy(this->text, text, I);
        }
    }
}
