/* OS̊j */
#include "bootpack.h"

struct fifo fifo;		/* VXep */
struct mdec mdec;		/* }EX */
struct memorys *mem;	/* Ǘp */
unsigned int memtotal;	/* vTCY */
int *fat;				/* FATe[u */
unsigned char *nihongo;	/* {tHg */

void HariMain(void)
{
	struct bootinfo *binfo = (struct bootinfo *) BOOTINFO_ADDR;
	int fbuf[32];
	static char ktable[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0x09,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char ktable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0x09,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	int kshf = 0, kleds = (binfo->leds >> 4) & 7, kcwait = -1, kph = 0;
	struct task *task_sys, *task_fdc, *task_clock;
	struct sheet *sht_back, *sht_tbar, *sht_mouse;
	unsigned char *buf_back, *buf_tbar, *buf_mouse;
	struct sheet *sht = 0, *sht2, *snow = 0;
	int mmx = -1, mmx2 = 0, mmy = -1, x, y;
	int nmx = -1, nmy = 0, nwx = 0x7fffffff, nwy = 0;
	struct file *file;
	int i, j;
	char c;

	/* n[hEFȀ */
	gdtidt_init();
	pic_init();
	pit_init();

	/* ̏ */
	mem = (struct memorys *) MEMORY_ADDR;
	memtotal = memory_test(0x00400000, 0xbfffffff);
	memory_init(mem);
	memory_free(mem, 0x00001000, 0x0009e000);
	memory_free(mem, 0x00400000, memtotal - 0x00400000);

	/* ^C}̏ */
	timers_init();

	/* FIFȌ */
	fifo_init(&fifo, 0, fbuf, 32);

	/* ^XN̏ */
	task_sys = task_init();
	fifo.task = task_sys;

	/* FDC */
	task_fdc = task_alloc();
	fdc_tinit(task_fdc);

	/* I/OXg̏ */
	io_init();

	/* 荞݋ */
	outb(PIC0_IMR, 0xb8);	/* 10111000 PITƃL[{[hPIC1FDC */
	outb(PIC1_IMR, 0xef);	/* 11101111 }EX */
	sti();

	/* ʂ̏ */
	palette_init();
	sheets_init(binfo->vram, binfo->scrnx, binfo->scrny);

	/* fXNgbv */
	sht_back = sheet_alloc();
	buf_back = (unsigned char *) memory_alloc(mem, binfo->scrnx * binfo->scrny);
	sheet_set(sht_back, buf_back, binfo->scrnx, binfo->scrny, -1);
	graphic_box(sht_back, COLOR_008484, 0, 0, binfo->scrnx - 1, binfo->scrny - 1);	/* wi */

	/* ʂ̕\ */
	sheet_slide(sht_back, 0, 0);
	sheet_updown(sht_back, 0);

	/* FATe[ȕ */
	fat = (int *) memory_alloc(mem, 11520);
	fat_read(fat, (unsigned char *) FAT_ADDR);

	/* ǎK */
	screen_init(sht_back);
	sheet_refresh(sht_back, 0, 0, binfo->scrnx, binfo->scrny);

	/* ^XNo[ */
	sht_tbar = sheet_alloc();
	buf_tbar = (unsigned char *) memory_alloc(mem, 166 * 22);
	sheet_set(sht_tbar, buf_tbar, 166, 22, -1);
	tbar_init(sht_tbar);

	sheet_slide(sht_tbar, 0, 0);
	sheet_updown(sht_tbar, 1);

	/* {tHg̓ǂݍ */
	file = file_search("nihongo.fnt");
	nihongo = 0;
	if(file != 0) {
		i = file->size;
		nihongo = file_read(file->cno, &i);
	}
	if(nihongo == 0) {	/* tHgȂߓhԂ */
		nihongo = (unsigned char *) memory_alloc(mem, 16 * 256 + 32 * 94 * 47);
		for(i = 0; i < 16 * 256 + 32 * 94 * 47; i++) {
			nihongo[i] = 0xff;
		}
	}

	/* v */
	task_clock = task_alloc();
	clock_tinit(task_clock, sht_tbar);

	/* }EXJ[\ */
	sht_mouse = sheet_alloc();
	buf_mouse = (unsigned char *) memory_alloc(mem, 10 * 16);
	sheet_set(sht_mouse, buf_mouse, 10, 16, 99);
	mdec.mx = (binfo->scrnx - 10) / 2;	/* ʒu͉ʒ */
	mdec.my = (binfo->scrny - 16) / 2;
	mcursor_init(buf_mouse, 99);

	sheet_slide(sht_mouse, mdec.mx, mdec.my);
	sheet_updown(sht_mouse, 2);

	/* L[{[hƃ}EX̗L */
	keyboard_init();
	mouse_enable();

	for(;;) {
		cli();
		if(fifo_stat(&fifo) == 0) {	/* `ς܂ */
			if(nmx >= 0) {
				sti();
				sheet_slide(sht_mouse, nmx, nmy);
				nmx = -1;
			} else if(nwx != 0x7fffffff) {
				sti();
				sheet_slide(sht, nwx, nwy);
				nwx = 0x7fffffff;
			} else {
				task_sleep(task_sys);
				sti();
			}
		} else {
			i = fifo_get(&fifo);
			sti();

			if(i == 1 || (snow->flag == SHEET_NONE && snow != 0)) {	/* ̓EBhE̐؂ւ */
				if(shts->top <= 2) {	/* EBhEȂ */
					snow = 0;
				} else {
					window_passive(snow);
					snow = shts->s[shts->top - 1];
					window_active(snow);
				}
			}
			if(256 <= i && i <= 511) {	/* KCփf[^𑗂 */
				kcwait = i - 256;
				kc_rwait();
				outb(PORT_KEYDATA, kcwait);
			} else if(512 <= i && i <= 767) {	/* L[R[h */
				if(kph != 0) {	/* oCg̃R[h */
					fifo_put(&snow->task->fifo, 256 + (i - 512));
					kph = 0;
				} else {
					if(i - 512 < 0x80) {	/* R[hɕϊ */
						if(kshf != 0) {
							c = ktable1[i - 512];
						} else {
							c = ktable[i - 512];
						}
					} else {
						c = 0;
					}
					if('A' <= c && c <= 'Z') {	/* At@xbg */
						if(((kleds & 4) == 0 && kshf == 0) || ((kleds & 4) && kshf != 0)) {
							c += 0x20;
						}
					}
					if(c != 0 && snow != 0) {	/* obNXy[XAEnterAʏ핶 */
						fifo_put(&snow->task->fifo, 256 + (int) c);
					}
					if(i == 512 + 0x2a) {	/* VtgON */
						kshf |= 1;
					} else if(i == 512 + 0x36) {	/* EVtgON */
						kshf |= 2;
					} else if(i == 512 + 0x3a) {	/* CapsLock */
						kleds ^= 4;
						fifo_put(&fifo, 256 + KEYCMD_LED);
						fifo_put(&fifo, 256 + kleds);
					} else if(i == 512 + 0x3b) {	/* F1L[ */
						/* VKR\[̓EBhEɂ */
						if(snow != 0) {
							window_passive(snow);
							i = snow->x + 28;
							j = snow->y + 28;
							if(i > shts->xsize - 28) {
								i = shts->xsize - 28;
							}
							if(j > shts->ysize - 28) {
								j = shts->ysize - 28;
							}
						} else {
							i = 28;
							j = 28;
						}
						snow = cons_open();
						sheet_slide(snow, i, j);
						sheet_updown(snow, shts->top);
						window_active(snow);
					} else if(i == 512 + 0x3e) {	/* F4L[ */
						cli();
						snow->task->tss.eax = (int) &(snow->task->tss.esp0);
						snow->task->tss.eip = (int) app_end;
						sti();
						task_run(snow->task, -1, 0);
					} else if(i == 512 + 0x45) {	/* NUMLock */
						kleds ^= 2;
						fifo_put(&fifo, 256 + KEYCMD_LED);
						fifo_put(&fifo, 256 + kleds);
					} else if(i == 512 + 0x46) {	/* ScrollLock */
						kleds ^= 1;
						fifo_put(&fifo, 256 + KEYCMD_LED);
						fifo_put(&fifo, 256 + kleds);
					} else if(i == 512 + 0xe0) {	/* 2oCgR[h̍ŏ */
						fifo_put(&snow->task->fifo, 256 + 0xff);
						kph = 1;
					} else if(i == 512 + 0xaa) {	/* VtgOFF */
						kshf &= ~1;
					} else if(i == 512 + 0xb6) {	/* EVtgOFF */
						kshf &= ~2;
					} else if(i == 512 + 0xfa) {	/* KCf[^󂯎 */
						kcwait = -1;
					} else if(i == 512 + 0xfe) {	/* KCf[^󂯎Ȃ */
						kc_rwait();
						outb(PORT_KEYDATA, kcwait);
					}
				}
			} else if(768 <= i && i <= 1023) {	/* }EXf[^ */
				if(mouse_decode(i - 768) != 0) {	/* }EXJ[\̈ړ */
					sheet_slide(sht_mouse, mdec.mx, mdec.my);
					if((mdec.btn & 0x01) != 0) {	/* {^Ă */
						if(mmx < 0) {	/* ʏ탂[hiEBhEォTĎOɎĂj */
							for(j = shts->top - 1; j > 1; j--) {
								sht = shts->s[j];
								x = mdec.mx - sht->x;
								y = mdec.my - sht->y;
								if(mouse_cchk(x, y, 0, 0, sht->sx, sht->sy) >= 1) {
									if(sht->buf[y * sht->sx + x] != sht->cinv) {
										sheet_updown(sht, shts->top - 1);
										window_passive(snow);
										snow = sht;
										window_active(snow);
										if(mouse_cchk(x, y, 0, 0, sht->sx, 20) == MOUSE_DOUBLE) {	/* ŏƕ */
											sheet_min(sht);
										}
										if(mouse_cchk(x, y, 0, 0, sht->sx, 20) == MOUSE_PRESSED) {	/* EBhEړ[h */
											mmx = mdec.mx;
											mmy = mdec.my;
											mmx2 = sht->x;
											nwy = sht->y;
										}
										if(mouse_cchk(x, y, 6, 6, 14, 14) >= MOUSE_PRESSED) {	/* u~v{^NbN */
											if((sht->flag & SHEET_FROMAPP) != 0) {	/* Avp̃EBhEȂI */
												cli();
												snow->task->tss.eax = (int) &(snow->task->tss.esp0);
												snow->task->tss.eip = (int) app_end;
												sti();
												task_run(snow->task, -1, 0);
											} else {	/* R\[ */
												cli();
												fifo_put(&snow->task->fifo, 4);
												sheet_updown(snow, -1);
												fifo_put(&fifo, 1);
												sti();
											}
										}
									}
									break;
								}
							}
						} else {	/* EChEړ[hiړʂvZēj */
							x = mdec.mx - mmx;
							y = mdec.my - mmy;
							nwx = (mmx2 + x + 2) & ~3;
							nwy = nwy + y;
							mmy = mdec.my;
						}
					} else {	/* {^ĂȂ */
						mmx = -1;	/* ʏ탂[h */
						if(nwx != 0x7fffffff) {
							sheet_slide(sht, nwx, nwy);
							nwx = 0x7fffffff;
						}
					}
				}
			} else if(1024 <= i && i <= 1279) {	/* R\[I */
				cons_close(shts->sheet + (i - 1024));
			} else if(1280 <= i && i <= 1535) {
				cons_tclose(tasks->task + (i - 1280));
			} else if(1536 <= i && i <= 1791) {	/* R\[ */
				sht2 = shts->sheet + (i - 1536);
				memory_free(mem, (int) sht2->buf, (CONSOLE_X * 8 + 2) * (CONSOLE_Y * 16 + 22));
				sheet_free(sht2);
			}
		}
	}
}
