/* R\[ */
#include "bootpack.h"
#include <stdio.h>
#include <string.h>

void cons_task(void)
{
	struct task *task = task_now();
	struct console *cons = task->cons;
	int kph = 0;
	char line[40];
	int i;

	task->line = line;
	cons_font(cons, '>', 1);

	for(;;) {
		cli();
		if(fifo_stat(&task->fifo) == 0) {
			task_sleep(task);
			sti();
		} else {
			i = fifo_get(&task->fifo);
			sti();

			if(i == 2) {	/* J[\ON */
				cons->cc = COLOR_000000;
			} else if(i == 3) {	/* J[\OFF */
				cons_font(cons, ' ', 0);
				cons->cc = -1;
			} else  if(i == 4) {	/* R\[̏I */
				cli();
				fifo_put(&fifo, cons->sht - shts->sheet + 1024);
				cons->sht = 0;
				sti();
			} else if(256 <= i && i < 512) {	/* L[{[h */
				if(kph != 0) {	/* oCgR[h */
					kph = 0;
				} else {
					if(i == 256 + 8) {	/* obNXy[X */
						if(cons->cx > 9) {
							cons_font(cons, ' ', 0);
							cons->cx -= 8;
						}
					} else if(i == 256 + 10) {	/* Enter */
						cons_font(cons, ' ', 0);
						line[(cons->cx - 9) / 8] = 0;
						cons_nline(cons);

						/* R}hs */
						cons_cmd_run(cons, line);
						if(cons->sht == 0) {
							fifo_put(&fifo, task - tasks->task + 1280);
						}

						/* ̓EBhE̐؂ւ */
						fifo_put(&fifo, 1);

						/* vvg\ */
						cons_font(cons, '>', 1);
					} else if(i == 256 + 0xff) {	/* oCgR[h */
						kph = 1;
					} else {	/* ʕ */
						cons_font(cons, ' ', 0);
						if(cons->cx < CONSOLE_X * 8 - 9) {
							line[(cons->cx - 9) / 8] = i - 256;
							cons_font(cons, i - 256, 1);
						}
					}
				}
			}
			if(cons->sht != 0 && cons->cc != -1) {	/* J[\\ */
				graphic_box(cons->sht, cons->cc, cons->cx, cons->cy, cons->cx + 7, cons->cy + 15);
			}
		}
	}
}

struct sheet *cons_open(void)
{
	struct sheet *sht = sheet_alloc();
	unsigned char *buf = (unsigned char *) memory_alloc(mem, (CONSOLE_X * 8 + 2) * (CONSOLE_Y * 16 + 22));

	/* V[g̏ */
	sheet_set(sht, buf, CONSOLE_X * 8 + 2, CONSOLE_Y * 16 + 22, -1);
	window_open(sht, "R\[", 0);
	window_tbox(sht, COLOR_FFFFFF, 1, 21, CONSOLE_X * 8 - 1, CONSOLE_Y * 16 - 1);

	/* ^XN̏ */
	sht->task = cons_topen(sht);
	sht->flag |= SHEET_CONSOLE;
	return sht;
}

void cons_close(struct sheet *sht)
{
	struct task *task = sht->task;

	/* V[g̕Еt */
	memory_free(mem, (int) sht->buf, (CONSOLE_X * 8 + 2) * (CONSOLE_Y * 16 + 22));
	sheet_free(sht);

	/* ^XN̕Еt */
	cons_tclose(task);
	return;
}

struct task *cons_topen(struct sheet *sht)
{
	struct task *task = task_alloc();
	struct console *cons = (struct console *) memory_alloc(mem, sizeof(struct console));
	struct fhandle *fhandle = (struct fhandle *) memory_alloc(mem, sizeof(struct fhandle) * 8);
	int *fbuf = (int *) memory_alloc(mem, 32 * 4), i;

	/* ^XN̏ */
	task->stack = memory_alloc(mem, 65536);
	task->tss.eip = (int) &cons_task;
	task->tss.esp = task->stack + 65536;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;

	/* R\[ŗLf[^̏ */
	cons->sht = sht;
	cons->cx = 1;
	cons->cy = 21;
	cons->cc = COLOR_000000;
	task->cons = cons;

	/* t@Cnh̏ */
	for(i = 0; i < 8; i++) {
		fhandle[i].buf = 0;
	}
	task->fh = fhandle;

	/* FIFȌ */
	fifo_init(&task->fifo, task, fbuf, 32);

	task_run(task, 1, 1);
	return task;
}

void cons_tclose(struct task *task)
{
	/* ^XNX[v̊ԂׂĂJ */
	task_sleep(task);
	memory_free(mem, task->stack, 65536);
	memory_free(mem, (int) task->cons, sizeof(struct console));
	memory_free(mem, (int) task->fifo.buf, 32 * 4);
	memory_free(mem, (int) task->fh, sizeof(struct fhandle) * 8);
	task->flag = TASK_NONE;
	cli();
	if(tasks->tfpu == task) {
		tasks->tfpu = 0;
	}
	sti();
	return;
}

void cons_fonts(struct console *cons, char *s)
{
	for(; *s != 0; s++) {
		cons_font(cons, *s, 1);
	}
	return;
}

void cons_font(struct console *cons, char c, char m)
{
	char s[2];

	if(c == 0x09) {	/* ^u */
		for(;;) {
			if(cons->sht != 0) {
				graphic_fonts(cons->sht, COLOR_FFFFFF, COLOR_000000, cons->cx, cons->cy, " ");
			}
			cons->cx += 8;
			if(cons->cx == 1 + CONSOLE_X * 8) {
				cons_nline(cons);
			}
			if(((cons->cx - 1) & 0x3f) == 0) {	/* 64hbgi8Pʁj */
				break;
			}
		}
	} else if(c == 0x0a) {	/* s */
		cons_nline(cons);
	} else if(c == 0x0d) {	/* A */
	} else {
		s[0] = c;
		s[1] = 0;
		if(cons->sht != 0) {
			graphic_fonts(cons->sht, COLOR_FFFFFF, COLOR_000000, cons->cx, cons->cy, s);
		}
		if(m != 0) {
			cons->cx += 8;
			if(cons->cx == 1 + CONSOLE_X * 8) {
				cons_nline(cons);
			}
		}
	}
	return;
}

void cons_nline(struct console *cons)
{
	int x, y;

	if(cons->cy < CONSOLE_Y * 16) {
		cons->cy += 16;
	} else {	/* XN[ */
		if(cons->sht != 0) {
			for(y = 21; y < (CONSOLE_Y - 1) * 16 + 21; y++) {
				for(x = 1; x < CONSOLE_X * 8; x++) {
					cons->sht->buf[y * cons->sht->sx + x] = cons->sht->buf[(y + 16) * cons->sht->sx + x];
				}
			}
			for(y = (CONSOLE_Y - 1) * 16 + 21; y < CONSOLE_Y * 16 + 21; y++) {
				for(x = 1; x < CONSOLE_X * 8;x++) {
					cons->sht->buf[y * cons->sht->sx + x] = COLOR_FFFFFF;
				}
			}
			sheet_refresh(cons->sht, 1, 21, CONSOLE_X * 8 + 1, CONSOLE_Y * 16 + 21);
		}
	}
	cons->cx = 1;
	if(cons->sht->task->lbyte != 0) {
		cons->cx += 8;
	}
	return;
}

void cons_cmd_run(struct console *cons, char *line)
{
	if(strcmp(line, "mem") == 0 && cons->sht) {
		cons_cmd_mem(cons);
	} else if(strcmp(line, "dir") == 0 && cons->sht) {
		cons_cmd_dir(cons);
	} else if(strncmp(line, "del ", 4) == 0 && cons->sht) {
		cons_cmd_del(cons, line + 4);
	} else if(line[0] != 0) {
		if(cons_runapp(cons, line) == 0) {
			cons_fonts(cons, "̃R}h܂́AOR}h́AFĂ܂B");
		}
	}
	cons_nline(cons);
	return;
}

void cons_cmd_mem(struct console *cons)
{
	char s[30];

	sprintf(s, "F%4d^%4dMB", memory_fsize(mem) / 1048576, memtotal / 1048576);
	cons_fonts(cons, s);
	return;
}

void cons_cmd_dir(struct console *cons)
{
	struct file *file = (struct file *)FILE_ENTRY_ADDR;
	int i, j, k, m;
	char s[30];

	for(i = j = 0;i < 224;i++) {
		if((file[i].name[0] != 0x00) && (file[i].name[0] != 0xe5) && ((file[i].type & 0x18) == 0)) {
			sprintf(s, "filename ext@@%7dB", file[i].size);
			j += file[i].size;
			for(k = 0; k < 8; k++) {
				s[k] = file[i].name[k];
			}
			k++;
			for(m = 0; k < 12; k++) {
				s[k] = file[i].ext[m];
				m++;
			}
			if(file->ext[0] != ' ') {
				s[8] = '.';
			}
			cons_fonts(cons, s);
			cons_nline(cons);
		} else 
			break;
	}
	sprintf(s, "%3d̃t@C %7dB", i, j);
	cons_fonts(cons, s);
	return;
}

void cons_cmd_del(struct console *cons, char *line)
{
	struct file *file;
	int i;
	char name[14];

	for(i = 0; i < 13; i++) {
		if(line[i] <= ' ') {
			break;
		}
		name[i] = line[i];
	}
	name[i] = 0;

	file = file_search(name);
	if(file != 0) {
		i = file_delete(file);
		if(i != 0) {
			cons_fonts(cons, "t@C폜ł܂B");
		}
	} else {
		cons_fonts(cons, "t@C݂܂B");
	}
	return;
}

int cons_runapp(struct console *cons, char *line)
{
	struct task *task = task_now();
	struct file *file;
	char name[14], *p, *q;
	int ssize, dsize, esp, dhrb, asize;
	int i;

	for(i = 0; i < 13; i++) {
		if(line[i] <= ' ') {
			break;
		}
		name[i] = line[i];
	}
	name[i] = 0;

	file = file_search(name);
	if(file == 0 && name[i - 1] != '.' && i < 9) {
		/* gqčČ */
		name[i] = '.';
		name[i + 1] = 'h';
		name[i + 2] = 'r';
		name[i + 3] = 'b';
		name[i + 4] = 0;
		file = file_search(name);
	}

	if(file != 0) {
		asize = file->size;
		p = (char *) file_read(file->cno, &asize);
		if(p == 0) {
			memory_free(mem, (int) p, asize);
			cons_fonts(cons, "t@Cǂݍ߂܂B");
			return 1;
		}
		if(asize >= 36 && strncmp(p + 4, "Hari", 4) == 0 && *p == 0x00) {
			/* TCY̎擾 */
			ssize = *((int *) (p + HRB_SEG_SIZE));
			dhrb = *((int *) (p + HRB_DATA_ADDR));
			dsize = *((int *) (p + HRB_DATA_SIZE));
			esp = *((int *) (p + HRB_ESP_INIT));

			/* ̏ƃf[^̃ */
			q = (char *) memory_alloc(mem, ssize);
			task->ds = (int) q;

			/* ZOgݒƎs */
			seg_set(task->ldt, (int) p, asize - 1, AR_CODE_ER + AR_APP);
			seg_set(task->ldt + 1, (int) q, ssize - 1, AR_DATA_RW + AR_APP);
			for(i = 0; i < dsize; i++) {
				q[esp + i] = p[dhrb + i];
			}
			app_start(0x1b, 0 * 8 + 4, 1 * 8 + 4, esp, &(task->tss.esp0));

			/* EBhEƃ^C}̏̕Еt */
			for(i = 0; i < SHEET_MAX; i++) {
				if((shts->sheet[i].flag & SHEET_FROMAPP) != 0 && shts->sheet[i].task == task) {
					sheet_free(&(shts->sheet[i]));
				}
			}
			timer_cancel_auto(&task->fifo);

			/* t@Cƃ̕Еt */
			for(i = 0; i < 8; i++) {
				if(task->fh[i].buf != 0) {
					if(task->fh[i].flag != FHANDLE_NONE) {
						file_write(&task->fh[i], fat, task->fh[i].bpos);
					}
					memory_free(mem, (int) task->fh[i].buf, task->fh[i].size);
					task->fh[i].buf = 0;
				}
			}
			if((task->flag & TASK_MEMMAN) != 0) {
				memory_free(mem, *((int *) (p + HRB_MALLOC)), ssize - *((int *) (p + HRB_MALLOC)) - 32768);
				task->flag &= ~TASK_MEMMAN;
			}
			memory_free(mem, (int) q, ssize);

			/* BEEP̏ */
			beep(0);

			/* {ꏈ̐퉻 */
			task->lbyte = 0;
		} else {
			cons_fonts(cons, "LȃAvP[Vł͂܂B");
		}
		memory_free(mem, (int) p, asize);
		return 1;
	}
	return 0;
}
