/* }EX֌W */
#include "bootpack.h"

void mouse_ihandle(int *esp)
{
	int data;

	outb(PIC1_OCW2, 0x64);	/* IRQ-12ɎtPIC1ɒʒm */
	outb(PIC0_OCW2, 0x62);	/* IRQ-02ɎtPIC0ɒʒm */
	data = inb(PORT_KEYDATA);
	fifo_put(&fifo, 768 + data);
	return;
}

void mouse_enable(void)
{
	kc_rwait();
	outb(PORT_KEYCMD, KEYCMD_STMOUSE);
	kc_rwait();
	outb(PORT_KEYDATA, MOUCMD_ENABLE);	/* CPUACKi0xfaj𑗐M */
	mdec.phase = 0;	/* }EX0xfa҂ */
	mdec.obtn = 0;
	return;
}

int mouse_decode(unsigned char data)
{
	struct bootinfo *binfo = (struct bootinfo *) BOOTINFO_ADDR;

	if(mdec.phase == 0) {	/* }EX0xfa҂Ă */
		if(data == 0xfa) {
			mdec.phase = 1;
		}
		return 0;
	} else if(mdec.phase == 1) {	/* }EX1Byteڂ҂Ă */
		if((data & 0xc8) == 0x08) {
			mdec.buf[0] = data;
			mdec.phase = 2;
		}
		return 0;
	} else if(mdec.phase == 2) {	/* }EX2Byteڂ҂Ă */
		mdec.buf[1] = data;
		mdec.phase = 3;
		return 0;
	} else if(mdec.phase == 3) {	/* }EX3Byteڂ҂Ă */
		mdec.buf[2] = data;
		mdec.phase = 1;
		mdec.btn = mdec.buf[0] & 0x07;
		mdec.x = mdec.buf[1];
		mdec.y = mdec.buf[2];
		if((mdec.buf[0] & 0x10) != 0) {
			mdec.x |= 0xffffff00;
		}
		if((mdec.buf[0] & 0x20) != 0) {
			mdec.y |= 0xffffff00;
		}
		mdec.y = -mdec.y;	/* }EXy͕̕ */
		if(mdec.x == 0 && mdec.y == 0) {
			if(mdec.btn == 0) {
				mdec.stat = MOUSE_RELEASED;
			} else if(mdec.obtn == mdec.btn) {
				mdec.obtn = 0;
				mdec.stat = MOUSE_DOUBLE;
			} else {
				mdec.obtn = mdec.btn;
				mdec.stat = MOUSE_PRESSED;
			}
		} else {
			if(mdec.btn == 0) {
				mdec.obtn = 0;
				mdec.stat = MOUSE_MOVED;
			} else {
				mdec.obtn = 0;
				mdec.stat = MOUSE_DRAGGED;
			}
		}
		mdec.mx += mdec.x;
		mdec.my += mdec.y;
		if(mdec.mx < 0) { mdec.mx = 0; }
		if(mdec.my < 0) { mdec.my = 0; }
		if(mdec.mx > binfo->scrnx - 1) { mdec.mx = binfo->scrnx - 1; }
		if(mdec.my > binfo->scrny - 1) { mdec.my = binfo->scrny - 1; }
		return 1;
	}
	return -1;
}

int mouse_cchk(int x, int y, int x0, int y0, int x1, int y1)
{
	if(x0 <= x && x < x1 && y0 < y && y < y1) {
		if(mdec.stat == MOUSE_PRESSED) {
			return MOUSE_PRESSED;
		} else if(mdec.stat == MOUSE_DOUBLE) {
			return MOUSE_DOUBLE;
		} else {
			return 1;
		}
	}
	return 0;
}
