#include "../api.h"
#include <stdio.h>

struct calc {
	int win, mode;
	int data, temp;
};
#define ADD	1
#define SUB	2
#define MUL	3
#define DIV	4
#define MOD	5
int num(struct calc *calc);
void run(struct calc *calc);
void print(struct calc *calc);

void HariMain(void)
{
	unsigned char wbuf[5512];
	struct calc calc;
	int i;

	calc.win = api_walloc(104, 53, wbuf, "d", -1);
	calc.mode = 0;
	calc.data = 0;
	calc.temp = 0;
	print(&calc);

	for (;;) {
		i = num(&calc);
		if (i == 0x08) {
			calc.data = 0;
			print(&calc);
		} else if (i == 0x0a) {
			run(&calc);
		} else if (i == '+') {
			run(&calc);
			calc.mode = ADD;
			calc.temp = calc.data;
			calc.data = 0;
		} else if (i == '-') {
			run(&calc);
			calc.mode = SUB;
			calc.temp = calc.data;
			calc.data = 0;
		} else if (i == '*') {
			run(&calc);
			calc.mode = MUL;
			calc.temp = calc.data;
			calc.data = 0;
		} else if (i == '/') {
			run(&calc);
			calc.mode = DIV;
			calc.temp = calc.data;
			calc.data = 0;
		} else if (i == '%') {
			run(&calc);
			calc.mode = MOD;
			calc.temp = calc.data;
			calc.data = 0;
		}
	}
}

int num(struct calc *calc)
{
	int i;

	for (;;) {
		i = api_getc(1);
		if ('0' <= i && i <= '9') {
			calc->data = calc->data * 10 + (i - '0');
			print(calc);
		} else {
			break;
		}
	}
	return i;
}

void run(struct calc *calc)
{
	if (calc->mode == ADD) {
		calc->data += calc->temp;
	} else if (calc->mode == SUB) {
		calc->temp -= calc->data;
		calc->data = calc->temp;
	} else if (calc->mode == MUL) {
		calc->data *= calc->temp;
	} else if (calc->mode == DIV) {
		calc->temp /= calc->data;
		calc->data = calc->temp;
	} else if (calc->mode == MOD) {
		calc->temp %= calc->data;
		calc->data = calc->temp;
	}
	calc->temp = 0;
	calc->mode = 0;
	print(calc);
	return;
}

void print(struct calc *calc)
{
	unsigned char s[12];

	sprintf(s, "%11d", calc->data);
	api_wbox(calc->win, COLOR_C6C6C6, 8, 29, 96, 47);
	api_wputs(calc->win, COLOR_000000, 8, 29, s);
	return;
}
